/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.pumpkillagersquest_common_fabric.pumpkillager;

import com.mojang.datafixers.util.Pair;
import com.natamus.collective_common_fabric.functions.EntityFunctions;
import com.natamus.pumpkillagersquest_common_fabric.pumpkillager.Conversations;
import com.natamus.pumpkillagersquest_common_fabric.services.Services;
import com.natamus.pumpkillagersquest_common_fabric.util.Data;
import com.natamus.pumpkillagersquest_common_fabric.util.SpookyHeads;
import com.natamus.pumpkillagersquest_common_fabric.util.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1324;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2183;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3213;
import net.minecraft.class_3730;
import net.minecraft.class_3852;
import net.minecraft.class_3854;
import net.minecraft.class_4048;
import net.minecraft.class_5134;
import net.minecraft.class_5321;
import net.minecraft.class_7871;
import net.minecraft.class_9334;

public class Manage {
    public static void spawnPumpkillager(class_1937 level, class_1657 player, class_2338 pos) {
        Manage.spawnPumpkillager(level, player, pos, 0, 0);
    }

    public static void spawnPumpkillager(class_1937 level, class_1657 player, class_2338 pos, int conversationId, int placementId) {
        if (!Data.allPumpkillagers.containsKey(level)) {
            Data.allPumpkillagers.put(level, new CopyOnWriteArrayList());
        }
        class_1646 pumpkillager = Manage.createPumpkillager(level, pos, player, null, SpookyHeads.getJackoLantern(1), class_124.field_1054, "1.0", false);
        if (conversationId == 0) {
            pumpkillager.method_5752().add("pumpkillagersquest.initialencounter");
        }
        level.method_8649((class_1297)pumpkillager);
        pumpkillager.method_5702(class_2183.class_2184.field_9851, player.method_73189());
        Manage.placePumpkillagerBlocks(level, pos, placementId);
        Services.PUMPKILLAGER_API.pumpkillagerSummonEvent(player, pumpkillager, pos, conversationId == 0 ? "INITIAL_SUMMON" : "POST_RITUAL");
        Conversations.startTalking(level, pumpkillager, player, conversationId);
    }

    public static class_1646 createPumpkillager(class_1937 level, class_2338 pos, class_1657 player, class_5321<class_3852> profession, class_1799 headStack, class_124 nameColour, String scaleFloatString, boolean replace) {
        class_1646 oldpumpkillager = null;
        Set oldtags = Set.of("");
        if (replace) {
            for (class_1297 ea : level.method_8335(null, new class_238((double)(pos.method_10263() - 1), (double)(pos.method_10264() - 1), (double)(pos.method_10260() - 1), (double)(pos.method_10263() + 1), (double)(pos.method_10264() + 1), (double)(pos.method_10260() + 1)))) {
                if (!Util.isPumpkillager(ea)) continue;
                oldpumpkillager = (class_1646)ea;
                oldtags = oldpumpkillager.method_5752();
                break;
            }
        }
        class_1646 pumpkillager = (class_1646)class_1299.field_6077.method_5883(level, class_3730.field_16471);
        if (profession == null) {
            pumpkillager.method_7195(pumpkillager.method_7231().method_66687((class_7871.class_7872)level.method_30349(), class_3854.field_17075));
        } else {
            pumpkillager.method_7195(pumpkillager.method_7231().method_66687((class_7871.class_7872)level.method_30349(), class_3854.field_17075).method_66688((class_7871.class_7872)level.method_30349(), profession));
        }
        Object pumpkillagerName = "The Pumpkillager";
        if (!scaleFloatString.equals("1.0")) {
            pumpkillagerName = "The Pumpkillager|" + scaleFloatString;
        }
        pumpkillager.method_5814((double)pos.method_10263() + 0.5, (double)pos.method_10264(), (double)pos.method_10260() + 0.5);
        pumpkillager.method_5673(class_1304.field_6169, headStack);
        pumpkillager.method_5665((class_2561)class_2561.method_43470((String)pumpkillagerName).method_27692(nameColour));
        pumpkillager.method_6092(new class_1293(class_1294.field_5918, Integer.MAX_VALUE));
        pumpkillager.method_18868().method_35060();
        pumpkillager.method_5752().add("pumpkillagersquest.justadded");
        EntityFunctions.setEntitySize((class_1297)pumpkillager, (class_4048)Util.getDefaultVillagerDimensions().method_18383(Float.parseFloat(scaleFloatString)), (float)pumpkillager.method_5751());
        EntityFunctions.forceSetHealth((class_1309)pumpkillager, (float)Data.pumpkillagerMaxHealth);
        for (String tag : oldtags) {
            pumpkillager.method_5752().add(tag);
        }
        if (oldpumpkillager != null) {
            pumpkillager.method_5847(oldpumpkillager.method_5791());
            pumpkillager.method_5636(oldpumpkillager.field_6283);
            pumpkillager.method_36457(oldpumpkillager.method_36455());
            pumpkillager.method_36456(oldpumpkillager.method_36454());
        }
        class_1799 scaleBarrier = new class_1799((class_1935)class_1802.field_8077, 64);
        scaleBarrier.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)scaleFloatString));
        pumpkillager.method_6122(class_1268.field_5810, scaleBarrier);
        try {
            float scaleFloat = Float.parseFloat(scaleFloatString);
            class_1324 scaleAttributeInstance = pumpkillager.method_5996(class_5134.field_47760);
            if (scaleAttributeInstance != null) {
                scaleAttributeInstance.method_6192((double)scaleFloat);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        Data.pumpkillagerPlayerTarget.put(pumpkillager, player);
        Data.allPumpkillagers.get(level).add(pumpkillager);
        Data.pumpkillagerPositions.put(pumpkillager, pumpkillager.method_73189());
        if (oldpumpkillager != null) {
            Data.pumpkillagerPlayerTarget.remove(oldpumpkillager);
            Data.allPumpkillagers.get(level).remove(oldpumpkillager);
            Data.pumpkillagerPositions.remove(oldpumpkillager);
            oldpumpkillager.method_5650(class_1297.class_5529.field_26999);
        }
        return pumpkillager;
    }

    public static void placePumpkillagerBlocks(class_1937 level, class_2338 pos, int placementId) {
        ArrayList<class_2338> processedPoss = new ArrayList<class_2338>();
        ArrayList<Pair> currentStates = new ArrayList<Pair>();
        if (placementId == 0) {
            class_2338 below = pos.method_10074().method_10062();
            currentStates.add(new Pair((Object)below, (Object)level.method_8320(below)));
            level.method_8652(below, class_2246.field_22423.method_9564(), 3);
            processedPoss.add(below);
            for (class_2338 ap : Util.getSidePositions(below)) {
                currentStates.add(new Pair((Object)ap, (Object)level.method_8320(ap)));
                level.method_8652(ap, class_2246.field_10540.method_9564(), 3);
                processedPoss.add(ap);
            }
            for (class_2338 ap : Util.getSidePositions(pos)) {
                currentStates.add(new Pair((Object)ap, (Object)level.method_8320(ap)));
                level.method_8652(ap, class_2246.field_23871.method_9564(), 3);
                processedPoss.add(ap);
            }
            for (class_2338 ap : Util.getSidePositions(pos.method_10084())) {
                currentStates.add(new Pair((Object)ap.method_10062(), (Object)level.method_8320(ap)));
                level.method_8652(ap, class_2246.field_22110.method_9564(), 3);
                processedPoss.add(ap);
            }
        } else if (placementId == 1) {
            class_2338 belowPos = pos.method_10074().method_10062();
            currentStates.add(new Pair((Object)belowPos, (Object)level.method_8320(belowPos)));
            level.method_8652(belowPos, class_2246.field_10540.method_9564(), 3);
            processedPoss.add(belowPos);
        } else {
            return;
        }
        Data.globalProcessedPoss.addAll(processedPoss);
        Data.previousStates.put(pos, currentStates);
    }

    public static void resetPlacedBlocks(class_1937 level, class_1646 pumpkillager) {
        Manage.resetPlacedBlocks(level, pumpkillager.method_24515());
    }

    public static void resetPlacedBlocks(class_1937 level, class_2338 pos) {
        if (Data.previousStates.containsKey(pos)) {
            Collections.reverse(Data.previousStates.get(pos));
            for (Pair<class_2338, class_2680> replacePair : Data.previousStates.get(pos)) {
                try {
                    level.method_8652((class_2338)replacePair.getFirst(), (class_2680)replacePair.getSecond(), 3);
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                Data.globalProcessedPoss.remove(pos);
            }
            Data.previousStates.remove(pos);
        }
    }

    public static void yeetLivingEntityIntoSky(class_1937 level, class_1309 livingEntity) {
        class_2338 pos = livingEntity.method_24515();
        livingEntity.method_5752().add("pumpkillagersquest.removed");
        livingEntity.method_5875(true);
        Data.entitiesToYeet.get(level).add(livingEntity);
    }

    public static void pumpkillagerMovedWrongly(class_1937 level, class_1297 pumpkillager, class_1657 player) {
        Manage.pumpkillagerMovedWrongly(level, (class_1646)pumpkillager, player);
    }

    public static void pumpkillagerMovedWrongly(class_1937 level, class_1646 pumpkillager, class_1657 player) {
        if (!Data.pumpkillagerPositions.containsKey(pumpkillager)) {
            return;
        }
        if (!pumpkillager.method_5752().contains("pumpkillagersquest.isleaving")) {
            class_243 pumpkillagerVec = Data.pumpkillagerPositions.get(pumpkillager);
            pumpkillager.method_33574(pumpkillagerVec);
        }
    }

    public static void initiateCharacterLeave(class_1937 level, class_1646 character) {
        class_3213 serverBossEvent;
        character.method_5752().add("pumpkillagersquest.isleaving");
        if (!level.method_8608() && (serverBossEvent = Data.pumpkillagerBossEvents.get(character)) != null) {
            serverBossEvent.method_5408(0.0f);
            serverBossEvent.method_14091(false);
            serverBossEvent.method_14094();
            Data.pumpkillagerBossEvents.remove(character);
        }
        if (Util.isPumpkillager((class_1297)character)) {
            Manage.resetPlacedBlocks(level, character);
        }
        Manage.yeetLivingEntityIntoSky(level, (class_1309)character);
    }
}

