/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.pumpkillagersquest_common_neoforge.pumpkillager;

import com.natamus.collective_common_neoforge.functions.BlockPosFunctions;
import com.natamus.collective_common_neoforge.functions.EntityFunctions;
import com.natamus.pumpkillagersquest_common_neoforge.pumpkillager.Actions;
import com.natamus.pumpkillagersquest_common_neoforge.pumpkillager.Conversations;
import com.natamus.pumpkillagersquest_common_neoforge.util.Data;
import com.natamus.pumpkillagersquest_common_neoforge.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Pillager;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Vindicator;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class Summon {
    public static void summonFinalBossMinions(Level level, Villager pumpkillager, Player targetPlayer, int summonId) {
        if (level.isClientSide()) {
            return;
        }
        if (pumpkillager.getTags().contains("pumpkillagersquest.preventactions")) {
            return;
        }
        switch (summonId) {
            case 0: {
                Summon.summonFirstWave(level, pumpkillager, targetPlayer);
                break;
            }
            case 1: {
                Summon.summonSecondWave(level, pumpkillager, targetPlayer);
                break;
            }
            case 2: {
                Summon.summonThirdWave(level, pumpkillager, targetPlayer);
                break;
            }
            case 3: {
                Summon.summonFourthWave(level, pumpkillager, targetPlayer);
            }
        }
    }

    public static void checkForNewSummon(Level level, Villager pumpkillager, Player player, float newHealth) {
        float maxHealth = Data.pumpkillagerMaxHealth;
        float healthPercentage = newHealth / maxHealth;
        Set tags = pumpkillager.getTags();
        if ((double)healthPercentage <= 0.75 && !tags.contains("pumpkillagersquest.secondwave")) {
            Summon.summonFinalBossMinions(level, pumpkillager, player, 1);
            pumpkillager.getTags().add("pumpkillagersquest.secondwave");
            return;
        }
        if ((double)healthPercentage <= 0.5 && !tags.contains("pumpkillagersquest.thirdwave")) {
            Summon.summonFinalBossMinions(level, pumpkillager, player, 2);
            pumpkillager.getTags().add("pumpkillagersquest.thirdwave");
            return;
        }
        if ((double)healthPercentage <= 0.25 && !tags.contains("pumpkillagersquest.fourthwave")) {
            Summon.summonFinalBossMinions(level, pumpkillager, player, 3);
            pumpkillager.getTags().add("pumpkillagersquest.fourthwave");
        }
    }

    public static void summonMinionsAround(Level level, Villager pumpkillager, Player player, BlockPos centerPos, List<LivingEntity> minionsToSpawn) {
        if (pumpkillager.getTags().contains("pumpkillagersquest.iskilled")) {
            return;
        }
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>(Arrays.asList(centerPos.north(4).immutable(), centerPos.east(4).immutable(), centerPos.south(4).immutable(), centerPos.west(4).immutable()));
        ServerLevel serverLevel = (ServerLevel)level;
        MinecraftServer minecraftServer = serverLevel.getServer();
        int i = 0;
        for (LivingEntity livingEntity : minionsToSpawn) {
            livingEntity.getTags().add("pumpkillagersquest.summoned");
            livingEntity.getTags().add("pumpkillagersquest.justadded");
            BlockPos rawSpawnPos = (BlockPos)positions.get(i);
            BlockPos spawnPos = BlockPosFunctions.getSurfaceBlockPos((ServerLevel)serverLevel, (int)rawSpawnPos.getX(), (int)rawSpawnPos.getZ());
            livingEntity.setPos((double)spawnPos.getX() + 0.5, (double)spawnPos.getY(), (double)spawnPos.getZ() + 0.5);
            if (livingEntity instanceof Mob) {
                ((Mob)livingEntity).setCanPickUpLoot(false);
            }
            level.addFreshEntity((Entity)livingEntity);
            Util.spawnLightning(level, spawnPos, livingEntity, player, true);
            ++i;
        }
    }

    public static void summonFirstWave(Level level, Villager pumpkillager, Player player) {
        BlockPos pos = pumpkillager.blockPosition().immutable();
        ItemStack swordStack = new ItemStack((ItemLike)Items.IRON_SWORD, 1);
        swordStack.enchant((Holder)level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.VANISHING_CURSE), 1);
        ArrayList<LivingEntity> minionsToSummon = new ArrayList<LivingEntity>();
        for (int i = 0; i < 4; ++i) {
            ZombieVillager zombieVillager = (ZombieVillager)EntityType.ZOMBIE_VILLAGER.create(level, EntitySpawnReason.EVENT);
            zombieVillager.setItemInHand(InteractionHand.MAIN_HAND, swordStack.copy());
            EntityFunctions.getTargetSelector((Mob)zombieVillager).removeAllGoals(goal -> true);
            EntityFunctions.getTargetSelector((Mob)zombieVillager).addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)zombieVillager, Player.class, false));
            minionsToSummon.add((LivingEntity)zombieVillager);
        }
        Summon.summonMinionsAround(level, pumpkillager, player, pos, minionsToSummon);
        Conversations.addEmptyMessage(level, pumpkillager, player, 0);
        Conversations.addMessage(level, pumpkillager, player, "My zombified followers, forwards!", ChatFormatting.RED, 0);
        pumpkillager.getTags().add("pumpkillagersquest.summoninglightning");
        Actions.pumpkillagerLightning(level, pumpkillager, player);
    }

    public static void summonSecondWave(Level level, Villager pumpkillager, Player player) {
        BlockPos pos = pumpkillager.blockPosition().immutable();
        ItemStack bowStack = new ItemStack((ItemLike)Items.BOW, 1);
        bowStack.enchant((Holder)level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.VANISHING_CURSE), 1);
        ArrayList<LivingEntity> minionsToSummon = new ArrayList<LivingEntity>();
        for (int i = 0; i < 4; ++i) {
            Skeleton skeleton = (Skeleton)EntityType.SKELETON.create(level, EntitySpawnReason.EVENT);
            skeleton.setItemInHand(InteractionHand.MAIN_HAND, bowStack.copy());
            EntityFunctions.getTargetSelector((Mob)skeleton).removeAllGoals(goal -> true);
            EntityFunctions.getTargetSelector((Mob)skeleton).addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)skeleton, Player.class, false));
            minionsToSummon.add((LivingEntity)skeleton);
        }
        Summon.summonMinionsAround(level, pumpkillager, player, pos, minionsToSummon);
        Conversations.addEmptyMessage(level, pumpkillager, player, 0);
        Conversations.addMessage(level, pumpkillager, player, "Attack, my skeletons!", ChatFormatting.RED, 0);
    }

    public static void summonThirdWave(Level level, Villager pumpkillager, Player player) {
        BlockPos pos = pumpkillager.blockPosition().immutable();
        ArrayList<LivingEntity> minionsToSummon = new ArrayList<LivingEntity>();
        for (int i = 0; i < 2; ++i) {
            minionsToSummon.add((LivingEntity)EntityType.WITCH.create(level, EntitySpawnReason.EVENT));
            minionsToSummon.add((LivingEntity)EntityType.PHANTOM.create(level, EntitySpawnReason.EVENT));
        }
        Summon.summonMinionsAround(level, pumpkillager, player, pos, minionsToSummon);
        Conversations.addEmptyMessage(level, pumpkillager, player, 0);
        Conversations.addMessage(level, pumpkillager, player, "My loyal witches and your pets, destroy the human!", ChatFormatting.RED, 0);
    }

    public static void summonFourthWave(Level level, Villager pumpkillager, Player player) {
        Registry enchantmentRegistry = level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT);
        BlockPos pos = pumpkillager.blockPosition().immutable();
        ItemStack axeStack = new ItemStack((ItemLike)Items.WOODEN_AXE, 1);
        axeStack.enchant((Holder)enchantmentRegistry.getOrThrow(Enchantments.VANISHING_CURSE), 1);
        ItemStack crossbowStack = new ItemStack((ItemLike)Items.CROSSBOW, 1);
        crossbowStack.enchant((Holder)enchantmentRegistry.getOrThrow(Enchantments.VANISHING_CURSE), 1);
        ArrayList<LivingEntity> minionsToSummon = new ArrayList<LivingEntity>();
        for (int i = 0; i < 2; ++i) {
            Vindicator vindicator = (Vindicator)EntityType.VINDICATOR.create(level, EntitySpawnReason.EVENT);
            Pillager pillager = (Pillager)EntityType.PILLAGER.create(level, EntitySpawnReason.EVENT);
            vindicator.setItemInHand(InteractionHand.MAIN_HAND, axeStack.copy());
            pillager.setItemInHand(InteractionHand.MAIN_HAND, crossbowStack.copy());
            EntityFunctions.getTargetSelector((Mob)vindicator).removeAllGoals(goal -> true);
            EntityFunctions.getTargetSelector((Mob)pillager).removeAllGoals(goal -> true);
            EntityFunctions.getTargetSelector((Mob)vindicator).addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)vindicator, Player.class, false));
            EntityFunctions.getTargetSelector((Mob)pillager).addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)pillager, Player.class, true));
            minionsToSummon.add((LivingEntity)vindicator);
            minionsToSummon.add((LivingEntity)pillager);
        }
        Summon.summonMinionsAround(level, pumpkillager, player, pos, minionsToSummon);
        Conversations.addEmptyMessage(level, pumpkillager, player, 0);
        Conversations.addMessage(level, pumpkillager, player, "Illagers! Finish that scum!", ChatFormatting.RED, 0);
    }
}

