/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.pumpkillagersquest.forge.events;

import com.natamus.collective_common_forge.functions.WorldFunctions;
import com.natamus.pumpkillagersquest_common_forge.events.PkBlockEvents;
import java.lang.invoke.MethodHandles;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.bus.BusGroup;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;

public class ForgePkBlockEvents {
    public static void registerEventsInBus() {
        BusGroup.DEFAULT.register(MethodHandles.lookup(), ForgePkBlockEvents.class);
    }

    @SubscribeEvent
    public static boolean onBlockBreak(BlockEvent.BreakEvent e) {
        Level level = WorldFunctions.getWorldIfInstanceOfAndNotRemote((LevelAccessor)e.getLevel());
        if (level.isClientSide) {
            return false;
        }
        return !PkBlockEvents.onBlockBreak(level, e.getPlayer(), e.getPos(), e.getState(), null);
    }

    @SubscribeEvent
    public static boolean onCandleClick(PlayerInteractEvent.RightClickBlock e) {
        return !PkBlockEvents.onCandleClick(e.getLevel(), e.getEntity(), e.getHand(), e.getPos(), e.getHitVec());
    }

    @SubscribeEvent
    public static void onBlockPlace(BlockEvent.EntityPlaceEvent e) {
        Level level = WorldFunctions.getWorldIfInstanceOfAndNotRemote((LevelAccessor)e.getLevel());
        if (level == null) {
            return;
        }
        Entity entity = e.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        PkBlockEvents.onBlockPlace(level, e.getPos(), e.getPlacedBlock(), (LivingEntity)entity, null);
    }
}

