/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.pumpkillagersquest_common_fabric.pumpkillager;

import com.mojang.datafixers.util.Pair;
import com.natamus.pumpkillagersquest_common_fabric.config.ConfigHandler;
import com.natamus.pumpkillagersquest_common_fabric.pumpkillager.Conversations;
import com.natamus.pumpkillagersquest_common_fabric.pumpkillager.Manage;
import com.natamus.pumpkillagersquest_common_fabric.pumpkillager.Prisoner;
import com.natamus.pumpkillagersquest_common_fabric.services.Services;
import com.natamus.pumpkillagersquest_common_fabric.util.Data;
import com.natamus.pumpkillagersquest_common_fabric.util.GenerateStructure;
import com.natamus.pumpkillagersquest_common_fabric.util.Scheduler;
import com.natamus.pumpkillagersquest_common_fabric.util.SpookyHeads;
import com.natamus.pumpkillagersquest_common_fabric.util.Util;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_124;
import net.minecraft.class_1259;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1309;
import net.minecraft.class_1506;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1843;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2484;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2631;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3213;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3852;
import net.minecraft.class_5321;
import net.minecraft.class_9296;
import net.minecraft.class_9334;

public class Actions {
    public static void sendDistanceMessage(class_1937 level, class_1646 pumpkillager, class_1657 player) {
        Set pumpkillagerTags = pumpkillager.method_5752();
        if (pumpkillagerTags.contains("pumpkillagersquest.isleaving")) {
            return;
        }
        if (pumpkillagerTags.contains("pumpkillagersquest.initialencounter")) {
            Conversations.addEmptyMessage(level, pumpkillager, player, 0);
            Conversations.addMessage(level, pumpkillager, player, "Fine. Just leave me here.", class_124.field_1068, 0);
            Conversations.addMessage(level, pumpkillager, player, "Goodbye, " + player.method_5477().getString() + ".", class_124.field_1068, 0);
        } else if (pumpkillagerTags.contains("pumpkillagersquest.finalform")) {
            Conversations.addEmptyMessage(level, pumpkillager, player, 0);
            Conversations.addMessage(level, pumpkillager, player, "There's no running from my new world order, " + player.method_5477().getString() + ".", class_124.field_1068, 0);
            Conversations.addMessage(level, pumpkillager, player, "I will find you again. Goodbye.", class_124.field_1068, 0);
        }
    }

    public static void givePlayerQuestbook(class_1937 level, class_1646 pumpkillager, class_1657 player) {
        if (!(pumpkillager.method_5998(class_1268.field_5808).method_7909() instanceof class_1843) || pumpkillager.method_5752().contains("pumpkillagersquest.questbookgiven")) {
            return;
        }
        pumpkillager.method_5752().add("pumpkillagersquest.questbookgiven");
        player.method_5752().add("pumpkillagersquest.questbookgiven");
        pumpkillager.method_6122(class_1268.field_5808, class_1799.field_8037);
        Conversations.addEmptyMessage(level, pumpkillager, player, 50);
        Conversations.addMessage(level, pumpkillager, player, "Thank you for accepting my quest. Take this book, it will give you more information.", class_124.field_1068, 60, Data.getQuestbook(level), "give");
        Conversations.addEmptyMessage(level, pumpkillager, player, 2000);
        if (!player.method_5752().contains("pumpkillagersquest.wasgiventnt")) {
            Conversations.addMessage(level, pumpkillager, player, "--Before I leave, take this. It might come in handy.", class_124.field_1068, 2010, new class_1799((class_1935)class_1802.field_8626, 1), "give");
            Conversations.addEmptyMessage(level, pumpkillager, player, 4000);
            player.method_5752().add("pumpkillagersquest.wasgiventnt");
        } else {
            Conversations.addMessage(level, pumpkillager, player, "I've already given you some tnt.", class_124.field_1068, 2010);
        }
        Conversations.addMessage(level, pumpkillager, player, "Bye!", class_124.field_1068, 4010);
        Scheduler.scheduleCharacterLeave(level, pumpkillager, 5000);
    }

    public static class_1799 generatePrisonAndCoordinatePaper(class_1937 level, class_1646 pumpkillager, class_1657 player) {
        Object coordinateString = "";
        class_2338 prisonerCampCoordinates = Util.getPrisonerCampCoordinates(level, pumpkillager, player);
        if (prisonerCampCoordinates != null) {
            coordinateString = prisonerCampCoordinates.method_10263() + ", " + prisonerCampCoordinates.method_10264() + ", " + prisonerCampCoordinates.method_10260();
        }
        class_1799 paperStack = new class_1799((class_1935)class_1802.field_8407, 1);
        paperStack.method_57379(class_9334.field_49631, (Object)class_2561.method_43471((String)("Prisoner Coordinates: " + (String)coordinateString + ".")));
        CompletableFuture.runAsync(() -> GenerateStructure.generatePrisonerCamp(level, player, prisonerCampCoordinates, 40));
        return paperStack;
    }

    public static void makePrisonerGuardsStepOffHorse(class_1937 level, class_1646 prisoner, class_1657 targetPlayer) {
        for (class_1297 entityAround : level.method_8335(null, new class_238(prisoner.method_23317() - 30.0, prisoner.method_23318() - 30.0, prisoner.method_23321() - 30.0, prisoner.method_23317() + 30.0, prisoner.method_23318() + 30.0, prisoner.method_23321() + 30.0))) {
            if (!(entityAround instanceof class_1506)) continue;
            class_1506 skeletonHorse = (class_1506)entityAround;
            skeletonHorse.method_18375();
            break;
        }
    }

    public static void processPrisonerItemGeneration(class_1937 level, class_1646 prisoner, class_1657 player, int msDelay) {
        new Thread(() -> {
            try {
                Thread.sleep(msDelay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            class_243 pvec = prisoner.method_19538();
            level.method_55117(null, level.method_48963().method_48819(null, null), null, pvec.field_1352, pvec.field_1351, pvec.field_1350, 3.0f, false, class_1937.class_7867.field_40888);
            Conversations.startTalking(level, prisoner, player, 6);
        }).start();
    }

    public static void startFinalBossSequence(class_1937 level, class_1657 player, class_2338 centerPos, List<Pair<class_2338, class_2680>> candlePositions) {
        class_243 centerVec = new class_243((double)centerPos.method_10263() + 0.5, (double)centerPos.method_10264(), (double)centerPos.method_10260() + 0.5);
        level.method_55117(null, level.method_48963().method_48819(null, null), null, centerVec.field_1352, centerVec.field_1351, centerVec.field_1350, 3.0f, false, class_1937.class_7867.field_40888);
        level.method_8652(centerPos, class_2246.field_10124.method_9564(), 3);
        for (Pair<class_2338, class_2680> candlePair : candlePositions) {
            boolean bl = false;
        }
        class_1646 pumpkillager = Manage.createPumpkillager(level, centerPos, player, (class_5321<class_3852>)class_3852.field_17065, SpookyHeads.getEvilJackoLantern(1), Data.defaultPumpkillagerColour, "3.0", false);
        pumpkillager.method_5752().add("pumpkillagersquest.nodamage");
        pumpkillager.method_5752().add("pumpkillagersquest.finalform");
        level.method_8652(centerPos.method_10074(), class_2246.field_10540.method_9564(), 3);
        level.method_8649((class_1297)pumpkillager);
        Services.PUMPKILLAGER_API.pumpkillagerSummonEvent(player, pumpkillager, centerPos, "FINAL_BOSS");
        Conversations.startTalking(level, pumpkillager, player, 7);
    }

    public static void pumpkillagerLightning(class_1937 level, class_1646 pumpkillager, class_1657 targetPlayer) {
        new Thread(() -> {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (pumpkillager.method_31481() || !Data.allPumpkillagers.get(level).contains(pumpkillager)) {
                return;
            }
            if (!pumpkillager.method_5752().contains("pumpkillagersquest.summoninglightning")) {
                return;
            }
            level.method_8503().execute(() -> {
                class_2338 playerPos = targetPlayer.method_24515();
                new Thread(() -> {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    Data.lightningTasks.get(level).put(pumpkillager, () -> {
                        if (!pumpkillager.method_5752().contains("pumpkillagersquest.firstlightning")) {
                            Conversations.sendJaxMessage(level, targetPlayer, targetPlayer.method_5477().getString() + "! The Pumpkillager is summoning lightning at your position! It looks like it's delayed, so just keep moving!", class_124.field_1068, 10);
                            pumpkillager.method_5752().add("pumpkillagersquest.firstlightning");
                        }
                        Util.spawnLightning(level, playerPos, (class_1309)targetPlayer, targetPlayer, false);
                    });
                }).start();
            });
            Actions.pumpkillagerLightning(level, pumpkillager, targetPlayer);
        }).start();
    }

    public static void startWeakenedBossEvent(class_1937 level, class_1646 pumpkillager, class_1657 player) {
        Conversations.addEmptyMessage(level, null, player, 1500);
        Conversations.sendJaxMessage(level, player, "You did it! Now finish him!", class_124.field_1080, 1510);
        class_3213 serverBossEvent = new class_3213((class_2561)class_2561.method_43471((String)"The Pumpkillager"), class_1259.class_1260.field_5784, class_1259.class_1261.field_5795);
        Data.pumpkillagerBossEvents.put(pumpkillager, serverBossEvent);
        if (!level.field_9236) {
            class_3222 serverPlayer = (class_3222)player;
            serverBossEvent.method_14088(serverPlayer);
        }
        Conversations.startTalking(level, pumpkillager, player, 8);
    }

    public static void shrinkAndKillPumpkillager(class_1937 level, class_1646 pumpkillager, class_1657 targetPlayer) {
        class_1799 offhandStack;
        class_3213 serverBossEvent;
        pumpkillager.method_5752().remove("pumpkillagersquest.summoninglightning");
        pumpkillager.method_5752().add("pumpkillagersquest.iskilled");
        if (!level.field_9236 && (serverBossEvent = Data.pumpkillagerBossEvents.get(pumpkillager)) != null) {
            serverBossEvent.method_5408(0.0f);
            serverBossEvent.method_14091(false);
            serverBossEvent.method_14094();
            Data.pumpkillagerBossEvents.remove(pumpkillager);
        }
        if ((offhandStack = pumpkillager.method_6079()).method_7909().equals(class_1802.field_8077)) {
            offhandStack.method_7939(10);
        }
        if (targetPlayer != null) {
            targetPlayer.method_5752().remove("pumpkillagersquest.aimforfeet");
            Conversations.addPostDeathMessage(level, pumpkillager, targetPlayer, "", class_124.field_1068);
            Conversations.addPostDeathMessage(level, pumpkillager, targetPlayer, "I can't believe you've defeated me.. Goodbye, cruel world.", class_124.field_1068);
        }
    }

    public static void turnPumpkillagerIntoHead(class_1937 level, class_1646 pumpkillager, class_1657 targetPlayer) {
        class_2338 headPos = pumpkillager.method_24515().method_10062();
        float floatRotation = pumpkillager.method_5791() + 180.0f;
        if (floatRotation > 360.0f) {
            floatRotation -= 360.0f;
        }
        class_1799 pumpkillagerHeadStack = SpookyHeads.getEvilJackoLantern(1);
        class_9296 resolvableProfile = (class_9296)pumpkillagerHeadStack.method_57353().method_58694(class_9334.field_49617);
        int intRotation = class_3532.method_15357((double)((double)(floatRotation * 16.0f / 360.0f) + 0.5)) & 0xF;
        class_2680 playerHeadBlockState = (class_2680)class_2246.field_10432.method_9564().method_11657((class_2769)class_2484.field_11505, (Comparable)Integer.valueOf(intRotation));
        level.method_8652(headPos, playerHeadBlockState, 3);
        class_2586 blockEntity = level.method_8321(headPos);
        if (blockEntity instanceof class_2631) {
            class_2631 skullBlockEntity = (class_2631)blockEntity;
            skullBlockEntity.method_11333(resolvableProfile);
        }
        level.method_43128(null, pumpkillager.method_23317(), pumpkillager.method_23318(), pumpkillager.method_23321(), class_3417.field_15195, class_3419.field_15256, 2.0f, 1.0f);
        pumpkillager.method_5650(class_1297.class_5529.field_26998);
        new Thread(() -> {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            level.method_8503().execute(() -> Actions.spawnPostFinalBossPrisoner(level, headPos, targetPlayer));
        }).start();
    }

    public static void spawnPostFinalBossPrisoner(class_1937 level, class_2338 pumpkillagerPos, class_1657 targetPlayer) {
        class_2338 prisonerPos = pumpkillagerPos.method_10086(2).method_10062();
        class_243 prisonerVec = new class_243((double)prisonerPos.method_10263() + 0.5, (double)prisonerPos.method_10264(), (double)prisonerPos.method_10260() + 0.5);
        class_1646 prisoner = Prisoner.createPrisoner(level, prisonerPos, targetPlayer, (class_5321<class_3852>)class_3852.field_17062, SpookyHeads.getCarvedPumpkin(1), class_124.field_1065, true);
        prisoner.method_18868().method_35060();
        prisoner.method_5875(true);
        prisoner.method_5752().add("pumpkillagersquest.lookingatplayer");
        prisoner.method_5752().add("pumpkillagersquest.afterfinal");
        prisoner.method_5752().add("pumpkillagersquest.isknownto." + targetPlayer.method_5477().getString());
        targetPlayer.method_5752().add("pumpkillagersquest.completedquest");
        level.method_8649((class_1297)prisoner);
        level.method_55117(null, level.method_48963().method_48819(null, null), null, prisonerVec.field_1352, prisonerVec.field_1351, prisonerVec.field_1350, 3.0f, false, class_1937.class_7867.field_40888);
        if (!level.field_9236) {
            class_1303.method_31493((class_3218)((class_3218)level), (class_243)new class_243((double)pumpkillagerPos.method_10263() + 0.5, (double)pumpkillagerPos.method_10264(), (double)pumpkillagerPos.method_10260() + 0.5), (int)ConfigHandler.experienceAmountRewardFinalBoss);
        }
        Conversations.startTalking(level, prisoner, targetPlayer, 9);
    }
}

