/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.pumpkillagersquest_common_fabric.util;

import com.mojang.datafixers.util.Pair;
import com.natamus.collective_common_fabric.data.GlobalVariables;
import com.natamus.collective_common_fabric.functions.EntityFunctions;
import com.natamus.collective_common_fabric.schematic.ParseSchematicFile;
import com.natamus.collective_common_fabric.schematic.ParsedSchematicObject;
import com.natamus.pumpkillagersquest_common_fabric.events.rendering.ClientRenderEvent;
import com.natamus.pumpkillagersquest_common_fabric.pumpkillager.Prisoner;
import com.natamus.pumpkillagersquest_common_fabric.util.SpookyHeads;
import com.natamus.pumpkillagersquest_common_fabric.util.Util;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.class_124;
import net.minecraft.class_1267;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1400;
import net.minecraft.class_1506;
import net.minecraft.class_1507;
import net.minecraft.class_1576;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1893;
import net.minecraft.class_1923;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_3852;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_9323;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;

public class GenerateStructure {
    public static void generatePrisonerCamp(class_1937 level, class_1657 player, class_2338 cPos, int pasteNBlocksAboveSurface) {
        MinecraftServer minecraftServer = level.method_8503();
        class_2338 centerPos = cPos.method_10062();
        class_1923 chunkPos = level.method_8500(centerPos).method_12004();
        for (int x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                class_2818 levelChunk = level.method_8497(chunkPos.field_9181 + x, chunkPos.field_9180 + z);
                levelChunk.method_12221((class_3218)level);
            }
        }
        boolean isPeaceful = minecraftServer.method_27728().method_207().equals((Object)class_1267.field_5801);
        InputStream schematicInputstream = Util.getSchematicsInputStream(minecraftServer, "floating_prisoner_camp");
        if (schematicInputstream == null) {
            System.out.println("[Pumpkillager's Quest] Error generating prisoner camp: inputstream is null.");
            return;
        }
        ParsedSchematicObject parsedSchematicObject = ParseSchematicFile.getParsedSchematicObject((InputStream)schematicInputstream, (class_1937)level, (class_2338)centerPos, (int)pasteNBlocksAboveSurface, (boolean)false);
        if (!parsedSchematicObject.parsedCorrectly) {
            System.out.println("[Pumpkillager's Quest] Error generating prisoner camp: schematic object didn't parse.");
            return;
        }
        minecraftServer.execute(() -> {
            for (Pair blockPair : parsedSchematicObject.blocks) {
                level.method_8652((class_2338)blockPair.getFirst(), (class_2680)blockPair.getSecond(), 3);
            }
            minecraftServer.execute(() -> {
                List<class_1799> pumpkinHeads = SpookyHeads.getAllPumpkinHeads();
                ArrayList<Integer> chestSlotRange = new ArrayList<Integer>(IntStream.rangeClosed(0, 26).boxed().toList());
                ArrayList<Integer> randomAmounts = new ArrayList<Integer>(Arrays.asList(1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2));
                ArrayList<class_1792> candleItems = new ArrayList<class_1792>(Arrays.asList(class_1802.field_27062, class_1802.field_27026, class_1802.field_27061, class_1802.field_27025));
                ArrayList<Integer> candleAmounts = new ArrayList<Integer>(Arrays.asList(1, 2, 1, 1, 2, 1, 2, 2, 1, 1, 2));
                for (Pair blockEntityPair : parsedSchematicObject.getBlockEntities(level)) {
                    class_2338 blockPos = (class_2338)blockEntityPair.getFirst();
                    class_2586 blockEntity = (class_2586)blockEntityPair.getSecond();
                    if (!(blockEntity instanceof class_2595)) continue;
                    class_2595 chestBlockEntity = new class_2595(blockPos, blockEntity.method_11010());
                    class_9323.class_9324 dataComponentMapBuilder = class_9323.method_57827();
                    dataComponentMapBuilder.method_57840(class_9334.field_49631, (Object)class_2561.method_43470((String)"Ritual Storage"));
                    chestBlockEntity.method_58684(dataComponentMapBuilder.method_57838());
                    Collections.shuffle(pumpkinHeads);
                    Collections.shuffle(chestSlotRange);
                    Collections.shuffle(candleItems);
                    Collections.shuffle(candleAmounts);
                    ArrayList<Integer> tempChestSlotRange = new ArrayList<Integer>(chestSlotRange);
                    for (class_1799 pumpkinHead : pumpkinHeads) {
                        pumpkinHead.method_7939(((Integer)randomAmounts.get(GlobalVariables.random.nextInt(randomAmounts.size()))).intValue());
                        chestBlockEntity.method_5447(((Integer)tempChestSlotRange.getFirst()).intValue(), pumpkinHead);
                        tempChestSlotRange.removeFirst();
                    }
                    if (candleItems.size() > 0) {
                        int i = 0;
                        Iterator iterator = tempChestSlotRange.iterator();
                        while (iterator.hasNext()) {
                            int remainingChestSlot = (Integer)iterator.next();
                            chestBlockEntity.method_5447(remainingChestSlot, new class_1799((class_1935)candleItems.getFirst(), ((Integer)candleAmounts.get(i)).intValue()));
                            ++i;
                        }
                        candleItems.removeFirst();
                    }
                    level.method_8438((class_2586)chestBlockEntity);
                }
                minecraftServer.execute(() -> {
                    class_1309 ghostRider;
                    class_1309 ghostKnight;
                    class_2378 enchantmentRegistry = level.method_30349().method_30530(class_7924.field_41265);
                    int aboveFloorYLevel = pasteNBlocksAboveSurface + 18;
                    class_2338 prisonerPos = centerPos.method_10076(11).method_10089(2).method_10086(aboveFloorYLevel).method_10062();
                    class_1646 prisoner = Prisoner.createPrisoner(level, prisonerPos, player, (class_5321<class_3852>)class_3852.field_17062, SpookyHeads.getCarvedPumpkin(1), class_124.field_1065, false);
                    prisoner.method_5752().add("pumpkillagersquest.persistent");
                    level.method_8649((class_1297)prisoner);
                    class_2338 ghostKnightPos = centerPos.method_10076(3).method_10089(3).method_10086(aboveFloorYLevel).method_10062();
                    class_1506 ghostKnightHorse = (class_1506)class_1299.field_6075.method_5883(level, class_3730.field_16474);
                    ghostKnightHorse.method_5814((double)ghostKnightPos.method_10263() + 0.5, (double)ghostKnightPos.method_10264(), (double)ghostKnightPos.method_10260() + 0.5);
                    ghostKnightHorse.method_5673(class_1304.field_55946, new class_1799((class_1935)class_1802.field_8175));
                    ghostKnightHorse.method_6766(true);
                    if (!isPeaceful) {
                        ghostKnight = (class_1309)class_1299.field_6071.method_5883(level, class_3730.field_16474);
                        class_1799 swordStack = new class_1799((class_1935)class_1802.field_8845);
                        swordStack.method_7978((class_6880)enchantmentRegistry.method_46747(class_1893.field_9118), 1);
                        ghostKnight.method_5673(class_1304.field_6173, swordStack);
                        ghostKnight.method_5673(class_1304.field_6171, new class_1799((class_1935)class_1802.field_8255));
                        class_1576 husk = (class_1576)ghostKnight;
                        EntityFunctions.getTargetSelector((class_1308)husk).method_35113(goal -> true);
                        EntityFunctions.getTargetSelector((class_1308)husk).method_6277(2, (class_1352)new class_1400((class_1308)husk, class_1657.class, true));
                    } else {
                        ghostKnight = (class_1309)class_1299.field_6077.method_5883(level, class_3730.field_16474);
                    }
                    ghostKnight.method_5673(class_1304.field_6169, SpookyHeads.getGhostKnightHead(1));
                    ghostKnight.method_5814((double)ghostKnightPos.method_10263() + 0.5, (double)ghostKnightPos.method_10264(), (double)ghostKnightPos.method_10260() + 0.5);
                    ghostKnight.method_5665((class_2561)class_2561.method_43470((String)"The Ghost Knight").method_27692(class_124.field_1065));
                    level.method_8649((class_1297)ghostKnightHorse);
                    level.method_8649((class_1297)ghostKnight);
                    class_2338 ghostRiderPos = centerPos.method_10077(3).method_10088(3).method_10086(aboveFloorYLevel).method_10062();
                    class_1507 ghostRiderHorse = (class_1507)class_1299.field_6048.method_5883(level, class_3730.field_16474);
                    ghostRiderHorse.method_5814((double)ghostRiderPos.method_10263() + 0.5, (double)ghostRiderPos.method_10264(), (double)ghostRiderPos.method_10260() + 0.5);
                    ghostRiderHorse.method_5673(class_1304.field_55946, new class_1799((class_1935)class_1802.field_8175));
                    ghostRiderHorse.method_6766(true);
                    if (!isPeaceful) {
                        ghostRider = (class_1309)class_1299.field_6098.method_5883(level, class_3730.field_16474);
                        class_1799 bowStack = new class_1799((class_1935)class_1802.field_8102);
                        bowStack.method_7978((class_6880)enchantmentRegistry.method_46747(class_1893.field_9125), 1);
                        ghostRider.method_5673(class_1304.field_6173, bowStack);
                    } else {
                        ghostRider = (class_1309)class_1299.field_6077.method_5883(level, class_3730.field_16474);
                    }
                    ghostRider.method_5673(class_1304.field_6169, SpookyHeads.getGhostRiderHead(1));
                    ghostRider.method_5814((double)ghostKnightPos.method_10263() + 0.5, (double)ghostRiderPos.method_10264(), (double)ghostKnightPos.method_10260() + 0.5);
                    ghostRider.method_5665((class_2561)class_2561.method_43470((String)"The Ghost Rider").method_27692(class_124.field_1065));
                    level.method_8649((class_1297)ghostRiderHorse);
                    level.method_8649((class_1297)ghostRider);
                    minecraftServer.execute(() -> {
                        ghostKnight.method_5804((class_1297)ghostKnightHorse);
                        ghostRider.method_5804((class_1297)ghostRiderHorse);
                        for (int x = -2; x <= 2; ++x) {
                            for (int z = -2; z <= 2; ++z) {
                                class_2818 levelChunk = level.method_8497(chunkPos.field_9181 + x, chunkPos.field_9180 + z);
                                levelChunk.method_12221((class_3218)level);
                            }
                        }
                    });
                });
            });
        });
    }

    public static void generateClientRitualVision(class_1937 level, class_1657 player, class_2338 clickPos, class_1799 bookstack) {
        if (!level.field_9236) {
            return;
        }
        class_2338 centerPos = clickPos.method_10084().method_10062();
        class_2248 centerBlock = class_2246.field_10375;
        class_2248 ritualBlock = class_2246.field_10091;
        if (!bookstack.method_7954().getString().contains("Quest")) {
            centerBlock = class_2246.field_46282;
            ritualBlock = class_2246.field_27099;
        }
        ClientRenderEvent.setTemporaryRitualRender(centerPos, centerBlock, ritualBlock);
    }
}

