/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.pumpkillagersquest_common_neoforge.events;

import com.natamus.collective_common_neoforge.functions.MessageFunctions;
import com.natamus.pumpkillagersquest_common_neoforge.pumpkillager.Actions;
import com.natamus.pumpkillagersquest_common_neoforge.pumpkillager.Conversations;
import com.natamus.pumpkillagersquest_common_neoforge.pumpkillager.Manage;
import com.natamus.pumpkillagersquest_common_neoforge.util.Data;
import com.natamus.pumpkillagersquest_common_neoforge.util.Util;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.WrittenBookItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class PkPlayerEvents {
    public static InteractionResult onCharacterInteract(Player player, Level level, InteractionHand hand, Entity target, EntityHitResult hitResult) {
        if (level.isClientSide) {
            return InteractionResult.PASS;
        }
        if (!hand.equals((Object)InteractionHand.MAIN_HAND)) {
            return InteractionResult.PASS;
        }
        if (!(target instanceof Villager)) {
            return InteractionResult.PASS;
        }
        if (Util.isPumpkillager(target)) {
            Villager pumpkillager = (Villager)target;
            Vec3 pumpkillagerVec = Data.pumpkillagerPositions.get(pumpkillager);
            if (pumpkillager.position().equals((Object)pumpkillagerVec)) {
                Manage.pumpkillagerMovedWrongly(level, pumpkillager, player);
            }
            if (pumpkillager.getItemInHand(InteractionHand.MAIN_HAND).getItem() instanceof WrittenBookItem) {
                Actions.givePlayerQuestbook(level, pumpkillager, player);
            }
        } else if (Util.isPrisoner(target)) {
            Villager prisoner = (Villager)target;
            if (!Util.prisonerIsKnown(prisoner, player)) {
                prisoner.getBrain().removeAllBehaviors();
                prisoner.setDeltaMovement(0.0, 0.0, 0.0);
                prisoner.setPos(prisoner.position());
                prisoner.lookAt(EntityAnchorArgument.Anchor.EYES, player.position());
                prisoner.getTags().add("pumpkillagersquest.lookingatplayer");
                Conversations.startTalking(level, prisoner, player, 5);
            }
        } else {
            return InteractionResult.PASS;
        }
        return InteractionResult.SUCCESS;
    }

    public static InteractionResult onRightClickItem(Player player, Level level, InteractionHand hand) {
        String bookName;
        ItemStack itemStack = player.getItemInHand(hand);
        if (level.isClientSide) {
            return InteractionResult.PASS;
        }
        Item handItem = itemStack.getItem();
        if (handItem.equals(Items.PAPER)) {
            String itemName = itemStack.getHoverName().getString();
            if (!itemName.contains("Prisoner Coordinates: ")) {
                return InteractionResult.PASS;
            }
            MessageFunctions.sendMessage((Player)player, (String)itemName, (ChatFormatting)ChatFormatting.GRAY);
        } else if (handItem instanceof WrittenBookItem && (bookName = itemStack.getDisplayName().getString()).contains("Pumpkillager")) {
            Conversations.addMessageWithoutPrefix(level, null, player, "You feel the book somehow whispering to you: \"Right-click me on the ground to see a glimpse of the ritual.\"", ChatFormatting.GRAY, 10);
        }
        return InteractionResult.PASS;
    }
}

