/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.pumpkillagersquest_common_neoforge.events;

import com.mojang.datafixers.util.Pair;
import com.natamus.collective_common_neoforge.functions.BlockPosFunctions;
import com.natamus.collective_common_neoforge.functions.EntityFunctions;
import com.natamus.collective_common_neoforge.functions.MessageFunctions;
import com.natamus.pumpkillagersquest_common_neoforge.pumpkillager.Actions;
import com.natamus.pumpkillagersquest_common_neoforge.pumpkillager.Conversations;
import com.natamus.pumpkillagersquest_common_neoforge.pumpkillager.Manage;
import com.natamus.pumpkillagersquest_common_neoforge.util.Data;
import com.natamus.pumpkillagersquest_common_neoforge.util.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class PkTickEvents {
    public static void onLevelTick(Level level) {
        Vec3 vec;
        if (!Data.messagesToSend.containsKey(level)) {
            Data.entitiesToYeet.put(level, new CopyOnWriteArrayList());
            Data.messagesToSend.put(level, new ArrayList());
            Data.allPumpkillagers.put(level, new CopyOnWriteArrayList());
            Data.allPrisoners.put(level, new CopyOnWriteArrayList());
            Data.lightningTasks.put(level, new HashMap());
            Data.spawnPumpkin.put(level, new ArrayList());
            return;
        }
        if (!level.isClientSide) {
            if (Data.messagesToSend.get(level).size() > 0) {
                Pair<Player, MutableComponent> messagepair = Data.messagesToSend.get(level).getFirst();
                Player player = (Player)messagepair.getFirst();
                MutableComponent component = (MutableComponent)messagepair.getSecond();
                MessageFunctions.sendMessage((Player)player, (MutableComponent)component);
                Data.messagesToSend.get(level).removeFirst();
            }
            if (Data.entitiesToYeet.get(level).size() > 0) {
                for (LivingEntity livingEntity : Data.entitiesToYeet.get(level)) {
                    vec = livingEntity.position();
                    if (vec.y >= 200.0) {
                        Data.entitiesToYeet.get(level).remove(livingEntity);
                        if (livingEntity instanceof Villager) {
                            Villager character = (Villager)livingEntity;
                            Data.pumpkillagerPositions.remove(character);
                            Data.allPumpkillagers.get(level).remove(character);
                            Data.allPrisoners.get(level).remove(character);
                        }
                        livingEntity.setRemoved(Entity.RemovalReason.DISCARDED);
                        continue;
                    }
                    livingEntity.setPos(vec.x, vec.y + 1.0, vec.z);
                }
            }
            if (Data.spawnPumpkin.get(level).size() > 0) {
                LivingEntity livingEntity = Data.spawnPumpkin.get(level).getFirst();
                Vec3 livingVec = livingEntity.position();
                BlockPos livingPos = livingEntity.blockPosition();
                for (BlockPos posAround : BlockPos.betweenClosed((int)(livingPos.getX() - 1), (int)livingPos.getY(), (int)(livingPos.getZ() - 1), (int)(livingPos.getX() + 1), (int)livingPos.getY(), (int)(livingPos.getZ() + 1))) {
                    if (!Util.isPumpkinBlock(level.getBlockState(posAround).getBlock())) continue;
                    return;
                }
                livingEntity.setPos(livingVec.x, livingVec.y + 1.0, livingVec.z);
                level.setBlock(livingPos, Blocks.PUMPKIN.defaultBlockState(), 3);
                Data.spawnPumpkin.get(level).removeFirst();
            }
        }
        if (Data.allPumpkillagers.get(level).size() > 0) {
            for (Villager pumpkillager : Data.allPumpkillagers.get(level)) {
                boolean shouldYeet;
                float scaleCount;
                ItemStack offhandStack;
                BlockPos pumpkillagerPos = pumpkillager.blockPosition();
                Component pumpkillagerComponent = pumpkillager.getName();
                String pumpkillagerName = pumpkillagerComponent.getString();
                if (pumpkillagerName.contains("|")) {
                    pumpkillager.setCustomName((Component)Component.literal((String)"The Pumpkillager").withStyle(pumpkillagerComponent.getStyle()));
                }
                Set pumpkillagerTags = pumpkillager.getTags();
                Player targetPlayer = Data.pumpkillagerPlayerTarget.get(pumpkillager);
                if (targetPlayer != null && !pumpkillagerTags.contains("pumpkillagersquest.preventactions") && pumpkillager.tickCount % 20 == 0 && (pumpkillagerTags.contains("pumpkillagersquest.initialencounter") || pumpkillager.getTags().contains("pumpkillagersquest.finalform")) && !BlockPosFunctions.withinDistance((BlockPos)pumpkillagerPos, (BlockPos)targetPlayer.blockPosition(), (int)32).booleanValue()) {
                    Actions.sendDistanceMessage(level, pumpkillager, targetPlayer);
                    pumpkillager.getTags().add("pumpkillagersquest.preventactions");
                    Manage.initiateCharacterLeave(level, pumpkillager);
                    continue;
                }
                if (pumpkillagerTags.contains("pumpkillagersquest.finalform")) {
                    if (!pumpkillagerTags.contains("pumpkillagersquest.isleaving") && !level.isDarkOutside()) {
                        if (targetPlayer != null) {
                            Conversations.addEmptyMessage(level, pumpkillager, targetPlayer, 0);
                            Conversations.addMessage(level, pumpkillager, targetPlayer, "You're too late, " + targetPlayer.getName().getString() + ". The night has passed and the magic holding me here has disappeared.", ChatFormatting.WHITE, 0);
                            Conversations.addMessage(level, pumpkillager, targetPlayer, "Bye.", ChatFormatting.WHITE, 0);
                            pumpkillager.getTags().add("pumpkillagersquest.preventactions");
                        }
                        Manage.initiateCharacterLeave(level, pumpkillager);
                        continue;
                    }
                    if (pumpkillagerTags.contains("pumpkillagersquest.summoninglightning") && Data.lightningTasks.get(level).containsKey(pumpkillager)) {
                        Runnable lightningTask = Data.lightningTasks.get(level).get(pumpkillager);
                        Data.lightningTasks.get(level).remove(pumpkillager);
                        level.getServer().execute(lightningTask);
                    }
                }
                if (pumpkillagerTags.contains("pumpkillagersquest.initialencounter") && !pumpkillagerTags.contains("pumpkillagersquest.isleaving") && pumpkillager.tickCount > 500) {
                    if (targetPlayer != null) {
                        Conversations.addMessage(level, pumpkillager, targetPlayer, "Fine. I see I'm wasting my time here. Goodbye, " + targetPlayer.getName().getString() + ".", ChatFormatting.WHITE, 10);
                    }
                    Manage.initiateCharacterLeave(level, pumpkillager);
                    continue;
                }
                if (pumpkillager.tickCount % 2 == 0 && (offhandStack = pumpkillager.getOffhandItem()).getItem().equals(Items.BARRIER) && (scaleCount = (float)offhandStack.getCount()) < 60.0f) {
                    float scaleFloat;
                    if (scaleCount >= 10.0f) {
                        scaleCount -= 10.0f;
                    }
                    if ((scaleFloat = Float.parseFloat(offhandStack.getHoverName().getString())) < scaleCount) {
                        float roundFloat = Util.roundFloat(scaleFloat + 0.025f, 3);
                        scaleAttributeInstance = pumpkillager.getAttribute(Attributes.SCALE);
                        if (scaleAttributeInstance != null) {
                            scaleAttributeInstance.setBaseValue((double)roundFloat);
                        }
                        offhandStack.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)("" + roundFloat)));
                    } else if (scaleFloat > scaleCount && scaleFloat - scaleCount >= 0.05f) {
                        float roundFloat = Util.roundFloat(scaleFloat - 0.1f, 3);
                        scaleAttributeInstance = pumpkillager.getAttribute(Attributes.SCALE);
                        if (scaleAttributeInstance != null) {
                            scaleAttributeInstance.setBaseValue((double)roundFloat);
                        }
                        offhandStack.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)("" + roundFloat)));
                        if (scaleFloat < 0.2f) {
                            Actions.turnPumpkillagerIntoHead(level, pumpkillager, Data.pumpkillagerPlayerTarget.get(pumpkillager));
                            continue;
                        }
                    } else if (!pumpkillagerTags.contains("pumpkillagersquest.isweakened") && targetPlayer != null) {
                        Villager newpumpkillager = Manage.createPumpkillager(level, pumpkillagerPos, targetPlayer, (ResourceKey<VillagerProfession>)VillagerProfession.WEAPONSMITH, pumpkillager.getItemBySlot(EquipmentSlot.HEAD), ChatFormatting.RED, offhandStack.getHoverName().getString(), true);
                        level.addFreshEntity((Entity)newpumpkillager);
                        EntityFunctions.setEntitySize((Entity)newpumpkillager, (EntityDimensions)Util.getDefaultVillagerDimensions().scale(scaleCount), (float)newpumpkillager.getEyeHeight());
                        Conversations.startTalking(level, newpumpkillager, targetPlayer, 2);
                        continue;
                    }
                }
                if (level.isClientSide || pumpkillager.tickCount % 20 != 0 || pumpkillagerTags.contains("pumpkillagersquest.beingyeeted")) continue;
                Vec3 vec2 = pumpkillager.position();
                boolean bl = shouldYeet = !vec2.equals((Object)Data.pumpkillagerPositions.get(pumpkillager));
                if (targetPlayer == null) {
                    for (Entity ea : level.getEntities(null, new AABB(vec2.x - 10.0, vec2.y - 2.0, vec2.z - 10.0, vec2.x + 10.0, vec2.y + 2.0, vec2.z + 10.0))) {
                        if (!(ea instanceof Player)) continue;
                        targetPlayer = (Player)ea;
                        break;
                    }
                }
                if (targetPlayer != null) {
                    pumpkillager.lookAt(EntityAnchorArgument.Anchor.EYES, targetPlayer.position());
                }
                if (!shouldYeet) continue;
                Manage.pumpkillagerMovedWrongly(level, pumpkillager, targetPlayer);
            }
        }
        if (Data.allPrisoners.get(level).size() > 0) {
            for (Villager prisoner : Data.allPrisoners.get(level)) {
                if (!prisoner.getTags().contains("pumpkillagersquest.lookingatplayer")) continue;
                vec = prisoner.position();
                if (!prisoner.getTags().contains("pumpkillagersquest.isleaving")) {
                    if (Data.prisonerPositions.containsKey(prisoner)) {
                        if (!Data.prisonerPositions.get(prisoner).equals((Object)vec)) {
                            vec = Data.prisonerPositions.get(prisoner);
                            prisoner.setPos(vec);
                        }
                    } else {
                        Data.prisonerPositions.put(prisoner, vec);
                    }
                }
                for (Entity ea : level.getEntities(null, new AABB(vec.x - 5.0, vec.y - 2.0, vec.z - 5.0, vec.x + 5.0, vec.y + 2.0, vec.z + 5.0))) {
                    if (!(ea instanceof Player)) continue;
                    prisoner.lookAt(EntityAnchorArgument.Anchor.EYES, ea.position());
                }
            }
        }
    }

    public static void onPlayerTick(ServerLevel level, ServerPlayer player) {
        if (player.tickCount % 100 != 0) {
            return;
        }
        if (!Data.allPrisoners.containsKey(level)) {
            return;
        }
        if (Data.allPrisoners.get(level).size() == 0) {
            return;
        }
        String playerName = player.getName().getString();
        BlockPos playerPos = player.blockPosition();
        for (Villager prisoner : Data.allPrisoners.get(level)) {
            BlockPos prisonerPos;
            Set prisonerTags = prisoner.getTags();
            if (prisonerTags.contains("pumpkillagersquest.talkedto." + playerName) || prisonerTags.contains("pumpkillagersquest.shoutedtwiceto." + playerName) || prisonerTags.contains("pumpkillagersquest.afterfinal") || !BlockPosFunctions.withinDistance((BlockPos)playerPos, (BlockPos)(prisonerPos = prisoner.blockPosition()), (int)16).booleanValue()) continue;
            if (prisonerTags.contains("pumpkillagersquest.shoutedto." + playerName)) {
                Conversations.startTalking((Level)level, prisoner, (Player)player, 4);
                continue;
            }
            Conversations.startTalking((Level)level, prisoner, (Player)player, 3);
        }
    }
}

