/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.pumpkillagersquest.forge.api;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.eventbus.api.bus.CancellableEventBus;
import net.minecraftforge.eventbus.api.event.MutableEvent;
import net.minecraftforge.eventbus.api.event.characteristic.Cancellable;
import org.jetbrains.annotations.NotNull;

public class PumpkillagerSummonEvent
extends MutableEvent
implements Cancellable {
    public static final CancellableEventBus<@NotNull PumpkillagerSummonEvent> BUS = CancellableEventBus.create(PumpkillagerSummonEvent.class);
    private final Player summoner;
    private final Villager pumpkillager;
    private final BlockPos pos;
    private final Type type;

    public PumpkillagerSummonEvent(Player summoner, Villager pumpkillager, BlockPos pos, Type type) {
        this.summoner = summoner;
        this.pumpkillager = pumpkillager;
        this.pos = pos.immutable();
        this.type = type;
    }

    public PumpkillagerSummonEvent(Player summoner, Villager pumpkillager, BlockPos pos, String typeString) {
        this.summoner = summoner;
        this.pumpkillager = pumpkillager;
        this.pos = pos.immutable();
        this.type = this.getTypeByString(typeString);
    }

    public Player getSummoner() {
        return this.summoner;
    }

    public Villager getPumpkillager() {
        return this.pumpkillager;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public Type getType() {
        return this.type;
    }

    public Type getTypeByString(String typeString) {
        return switch (typeString) {
            case "INITIAL_SUMMON" -> Type.INITIAL_SUMMON;
            case "POST_RITUAL" -> Type.POST_RITUAL;
            case "FINAL_BOSS" -> Type.FINAL_BOSS;
            default -> null;
        };
    }

    public static enum Type {
        INITIAL_SUMMON,
        POST_RITUAL,
        FINAL_BOSS;

    }
}

