/*
 * Decompiled with CFR 0.152.
 */
package org.garsooon;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.garsooon.AuctionPlugin;
import org.garsooon.Economy.Method;

public class AuctionManager {
    private final AuctionPlugin plugin;
    private final Method economy;
    private Player currentSeller;
    private ItemStack currentItem;
    private double startPrice;
    private Player highestBidder;
    private double highestBid;
    private int taskId;
    private int countdownTaskId = -1;
    private long auctionEndTime;
    private final Map<UUID, Long> lastAuctionTime = new HashMap<UUID, Long>();
    private long auctionStartTime = 0L;
    private double minBidIncrement = 1.0;
    private double percentBidIncrement = 0.0;

    public AuctionManager(AuctionPlugin plugin, Method economy) {
        this.plugin = plugin;
        this.economy = economy;
    }

    public boolean startAuction(Player seller, ItemStack item, double price, String incrementArg) {
        long last;
        long now;
        long elapsedMinutes;
        if (this.currentItem != null) {
            return false;
        }
        int cooldownMinutes = 5;
        Object rawCooldown = this.plugin.getCustomConfig().get("cooldown-minutes");
        if (rawCooldown instanceof Integer) {
            cooldownMinutes = (Integer)rawCooldown;
        }
        if ((elapsedMinutes = ((now = System.currentTimeMillis()) - (last = this.lastAuctionTime.getOrDefault(seller.getUniqueId(), 0L).longValue())) / 60000L) < (long)cooldownMinutes) {
            long wait = (long)cooldownMinutes - elapsedMinutes;
            seller.sendMessage(ChatColor.RED + "You must wait " + wait + " more minute" + (wait == 1L ? "" : "s") + " before starting another auction.");
            return false;
        }
        ArrayList<String> blacklist = new ArrayList<String>();
        Object rawList = this.plugin.getCustomConfig().get("blacklist");
        if (rawList instanceof List) {
            for (Object o : (List)rawList) {
                if (!(o instanceof String)) continue;
                blacklist.add((String)o);
            }
        }
        if (blacklist.contains(item.getType().name())) {
            seller.sendMessage(ChatColor.RED + "This item is blacklisted from auctions.");
            return false;
        }
        int duration = 60;
        Object durationObj = this.plugin.getCustomConfig().get("duration");
        if (durationObj instanceof Integer) {
            duration = (Integer)durationObj;
        }
        this.auctionStartTime = System.currentTimeMillis();
        this.auctionEndTime = this.auctionStartTime + (long)duration * 1000L;
        this.parseIncrement(incrementArg);
        this.currentSeller = seller;
        this.currentItem = item;
        this.startPrice = this.roundDown2(price);
        Object maxStartPriceObj = this.plugin.getCustomConfig().get("max-start-price");
        double maxStartPrice = 500.0;
        if (maxStartPriceObj instanceof Number) {
            maxStartPrice = ((Number)maxStartPriceObj).doubleValue();
        }
        if (this.startPrice > maxStartPrice) {
            seller.sendMessage(ChatColor.RED + "The maximum auction start price is $" + String.format("%.2f", maxStartPrice));
            return false;
        }
        this.highestBid = this.startPrice;
        this.highestBidder = null;
        this.auctionEndTime = System.currentTimeMillis() + (long)duration * 1000L;
        this.lastAuctionTime.put(seller.getUniqueId(), System.currentTimeMillis());
        String durabilityInfo = "";
        short dur = item.getDurability();
        short maxDur = item.getType().getMaxDurability();
        if (maxDur > 0) {
            int remaining = maxDur - dur;
            int pct = (int)((double)remaining * 100.0 / (double)maxDur);
            ChatColor durColor = ChatColor.GREEN;
            if (pct <= 25) {
                durColor = ChatColor.RED;
            } else if (pct <= 50) {
                durColor = ChatColor.GOLD;
            } else if (pct <= 75) {
                durColor = ChatColor.YELLOW;
            }
            durabilityInfo = durColor + " [" + remaining + "/" + maxDur + " durability]";
        }
        Bukkit.broadcastMessage((String)(ChatColor.GREEN + seller.getName() + " is auctioning " + ChatColor.YELLOW + item.getAmount() + "x " + this.getItemDisplayName(item) + durabilityInfo + ChatColor.GREEN + " starting at $" + this.startPrice));
        if (this.percentBidIncrement > 0.0) {
            Bukkit.broadcastMessage((String)(ChatColor.GRAY + "Minimum bid increase is set to " + this.percentBidIncrement + "%"));
        } else {
            Bukkit.broadcastMessage((String)(ChatColor.GRAY + "Minimum bid increase is set to $" + this.minBidIncrement));
        }
        this.scheduleAuctionEnd();
        return true;
    }

    private void parseIncrement(String arg) {
        if (arg == null || arg.isEmpty()) {
            this.minBidIncrement = 1.0;
            this.percentBidIncrement = 0.0;
            return;
        }
        arg = arg.trim();
        try {
            if (arg.endsWith("%")) {
                String numPart = arg.substring(0, arg.length() - 1);
                int percent = Integer.parseInt(numPart);
                this.percentBidIncrement = percent;
                this.minBidIncrement = 0.0;
            } else if (arg.startsWith("$")) {
                String numPart = arg.substring(1);
                int fixed = Integer.parseInt(numPart);
                this.minBidIncrement = fixed;
                this.percentBidIncrement = 0.0;
            } else if (arg.endsWith("$")) {
                String numPart = arg.substring(0, arg.length() - 1);
                int fixed = Integer.parseInt(numPart);
                this.minBidIncrement = fixed;
                this.percentBidIncrement = 0.0;
            } else {
                int fixed = Integer.parseInt(arg);
                this.minBidIncrement = fixed;
                this.percentBidIncrement = 0.0;
            }
        }
        catch (NumberFormatException e) {
            this.minBidIncrement = 1.0;
            this.percentBidIncrement = 0.0;
        }
    }

    public boolean bid(Player bidder, double amount) {
        long maxRemaining;
        long now;
        long remaining;
        long newRemaining;
        Method.MethodAccount previous;
        Method.MethodAccount bidderAccount;
        if (this.currentItem == null || bidder == this.currentSeller) {
            return false;
        }
        amount = this.roundDown2(amount);
        if (this.highestBidder != null) {
            double requiredMin = this.highestBid + this.minBidIncrement;
            if (this.percentBidIncrement > 0.0) {
                requiredMin = this.highestBid + this.highestBid * this.percentBidIncrement / 100.0;
            }
            if (amount < (requiredMin = this.roundDown2(requiredMin))) {
                bidder.sendMessage(ChatColor.RED + "You must bid at least $" + String.format("%.2f", requiredMin) + ".");
                return false;
            }
        } else if (amount < this.startPrice) {
            bidder.sendMessage(ChatColor.RED + "You must bid at least the starting price of $" + String.format("%.2f", this.startPrice) + ".");
            return false;
        }
        if ((bidderAccount = this.economy.getAccount(bidder.getName(), bidder.getWorld())) == null || !bidderAccount.hasEnough(amount, bidder.getWorld())) {
            bidder.sendMessage(ChatColor.RED + "You don't have enough money to bid $" + amount);
            return false;
        }
        if (this.highestBidder != null && (previous = this.economy.getAccount(this.highestBidder.getName(), this.highestBidder.getWorld())) != null) {
            previous.add(this.highestBid, this.highestBidder.getWorld());
            this.highestBidder.sendMessage(ChatColor.YELLOW + "Your previous bid of $" + this.highestBid + " was refunded.");
        }
        if (!bidderAccount.subtract(amount, bidder.getWorld())) {
            bidder.sendMessage(ChatColor.RED + "Failed to withdraw money.");
            return false;
        }
        this.highestBid = amount;
        this.highestBidder = bidder;
        Bukkit.broadcastMessage((String)(ChatColor.AQUA + bidder.getName() + " bids $" + amount));
        int timeAddPerBid = 10;
        Object bidAddObj = this.plugin.getCustomConfig().get("time_add_per_bid");
        if (bidAddObj instanceof Integer) {
            timeAddPerBid = (Integer)bidAddObj;
        }
        int maxTime = 180;
        Object maxAuctionTimeObj = this.plugin.getCustomConfig().get("max_auction_time");
        if (maxAuctionTimeObj instanceof Integer) {
            maxTime = (Integer)maxAuctionTimeObj;
        }
        if ((newRemaining = (remaining = this.auctionEndTime - (now = System.currentTimeMillis())) + (long)timeAddPerBid * 1000L) > (maxRemaining = (long)maxTime * 1000L)) {
            newRemaining = maxRemaining;
        }
        this.auctionEndTime = now + newRemaining;
        Bukkit.getScheduler().cancelTask(this.taskId);
        if (this.countdownTaskId != -1) {
            Bukkit.getScheduler().cancelTask(this.countdownTaskId);
        }
        this.scheduleAuctionEnd();
        Bukkit.broadcastMessage((String)(ChatColor.GRAY + "Auction time extended. " + newRemaining / 1000L + " seconds remain."));
        return true;
    }

    private double roundDown2(double val) {
        return Math.floor(val * 100.0) / 100.0;
    }

    private void scheduleAuctionEnd() {
        long delay = (this.auctionEndTime - System.currentTimeMillis()) / 50L;
        this.taskId = Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, this::endAuction, delay);
        this.countdownTaskId = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, new Runnable(){
            private int lastAnnounced = -1;

            @Override
            public void run() {
                if (AuctionManager.this.currentItem == null) {
                    Bukkit.getScheduler().cancelTask(AuctionManager.this.countdownTaskId);
                    return;
                }
                long timeLeft = (AuctionManager.this.auctionEndTime - System.currentTimeMillis()) / 1000L;
                if ((timeLeft == 10L || timeLeft == 5L) && this.lastAnnounced != (int)timeLeft) {
                    Bukkit.broadcastMessage((String)(ChatColor.GOLD + "Auction ends in " + timeLeft + " seconds!"));
                    this.lastAnnounced = (int)timeLeft;
                }
                if (timeLeft <= 0L) {
                    Bukkit.getScheduler().cancelTask(AuctionManager.this.countdownTaskId);
                }
            }
        }, 0L, 20L);
    }

    public void endAuction() {
        if (this.currentItem == null) {
            return;
        }
        if (this.highestBidder != null) {
            Method.MethodAccount sellerAccount;
            HashMap leftover = this.highestBidder.getInventory().addItem(new ItemStack[]{this.currentItem});
            if (!leftover.isEmpty()) {
                for (ItemStack stack : leftover.values()) {
                    this.highestBidder.getWorld().dropItemNaturally(this.highestBidder.getLocation(), stack);
                }
                this.highestBidder.sendMessage(ChatColor.YELLOW + "Your inventory was full! The auction item was dropped at your feet.");
            }
            Bukkit.broadcastMessage((String)(ChatColor.GOLD + this.highestBidder.getName() + " won the auction for $" + this.highestBid));
            if (this.economy != null && (sellerAccount = this.economy.getAccount(this.currentSeller.getName(), this.currentSeller.getWorld())) != null) {
                sellerAccount.add(this.highestBid, this.currentSeller.getWorld());
                this.currentSeller.sendMessage(ChatColor.GREEN + "You received $" + this.highestBid + " from the auction.");
            }
        } else {
            HashMap leftover = this.currentSeller.getInventory().addItem(new ItemStack[]{this.currentItem});
            if (!leftover.isEmpty()) {
                for (ItemStack stack : leftover.values()) {
                    this.currentSeller.getWorld().dropItemNaturally(this.currentSeller.getLocation(), stack);
                }
                this.currentSeller.sendMessage(ChatColor.YELLOW + "Your inventory was full! The item was dropped at your feet.");
            }
            Bukkit.broadcastMessage((String)(ChatColor.RED + "Auction ended with no bids."));
        }
        this.currentItem = null;
        this.currentSeller = null;
        this.highestBid = 0.0;
        this.highestBidder = null;
    }

    public void forceEnd() {
        this.currentItem = null;
        this.currentSeller = null;
        this.highestBidder = null;
        this.highestBid = 0.0;
        this.auctionEndTime = 0L;
        this.percentBidIncrement = 0.0;
        this.minBidIncrement = 1.0;
        Bukkit.broadcastMessage((String)(ChatColor.RED + "The current auction has been forcibly reset by an admin."));
    }

    public void cleanupStuckAuction() {
        long gracePeriodEnd;
        long now;
        if (this.currentItem == null) {
            return;
        }
        long maxAuctionTime = 30L;
        Object rawMax = this.plugin.getCustomConfig().get("max_auction_time");
        if (rawMax instanceof Integer) {
            maxAuctionTime = ((Integer)rawMax).intValue();
        }
        if ((now = System.currentTimeMillis()) > (gracePeriodEnd = this.auctionEndTime + maxAuctionTime * 1000L) && this.auctionStartTime < now - maxAuctionTime * 1000L) {
            Bukkit.broadcastMessage((String)(ChatColor.RED + "Stuck auction forcibly reset due to timeout."));
            Bukkit.getLogger().warning("[Auctioneer] An auction was forcibly reset due to timeout.");
            this.forceEnd();
        }
    }

    public String getCurrentItemDisplayName() {
        return this.currentItem != null ? this.getItemDisplayName(this.currentItem) : "Unknown Item";
    }

    public int getItemAmount() {
        return this.currentItem != null ? this.currentItem.getAmount() : 0;
    }

    public String getCurrentSellerName() {
        return this.currentSeller != null ? this.currentSeller.getName() : "Unknown";
    }

    public double getCurrentBid() {
        return Math.floor(this.highestBid * 100.0) / 100.0;
    }

    public ItemStack getCurrentItem() {
        return this.currentItem;
    }

    public boolean isAuctionRunning() {
        return this.currentItem != null;
    }

    private String getItemDisplayName(ItemStack item) {
        int id = item.getTypeId();
        short data = item.getDurability();
        switch (id) {
            case 337: {
                return "Clay Ball";
            }
            case 82: {
                return "Clay Block";
            }
            case 35: {
                return this.getWoolName(data);
            }
            case 351: {
                return this.getDyeName(data);
            }
            case 17: {
                return this.getLogName(data);
            }
            case 18: {
                return this.getLeafName(data);
            }
            case 6: {
                return this.getSaplingName(data);
            }
            case 44: {
                return this.getSlabName(data);
            }
        }
        return item.getType().name().replace('_', ' ').toLowerCase();
    }

    private String getWoolName(int data) {
        switch (data) {
            case 0: {
                return "White Wool";
            }
            case 1: {
                return "Orange Wool";
            }
            case 2: {
                return "Magenta Wool";
            }
            case 3: {
                return "Light Blue Wool";
            }
            case 4: {
                return "Yellow Wool";
            }
            case 5: {
                return "Lime Wool";
            }
            case 6: {
                return "Pink Wool";
            }
            case 7: {
                return "Gray Wool";
            }
            case 8: {
                return "Light Gray Wool";
            }
            case 9: {
                return "Cyan Wool";
            }
            case 10: {
                return "Purple Wool";
            }
            case 11: {
                return "Blue Wool";
            }
            case 12: {
                return "Brown Wool";
            }
            case 13: {
                return "Green Wool";
            }
            case 14: {
                return "Red Wool";
            }
            case 15: {
                return "Black Wool";
            }
        }
        return "Wool";
    }

    private String getDyeName(int data) {
        switch (data) {
            case 0: {
                return "Ink Sack (Black Dye)";
            }
            case 1: {
                return "Red Dye";
            }
            case 2: {
                return "Cactus Green (Green Dye)";
            }
            case 3: {
                return "Cocoa Beans (Brown Dye)";
            }
            case 4: {
                return "Lapis Lazuli (Blue Dye)";
            }
            case 5: {
                return "Purple Dye";
            }
            case 6: {
                return "Cyan Dye";
            }
            case 7: {
                return "Light Gray Dye";
            }
            case 8: {
                return "Gray Dye";
            }
            case 9: {
                return "Pink Dye";
            }
            case 10: {
                return "Lime Dye";
            }
            case 11: {
                return "Yellow Dye";
            }
            case 12: {
                return "Light Blue Dye";
            }
            case 13: {
                return "Magenta Dye";
            }
            case 14: {
                return "Orange Dye";
            }
            case 15: {
                return "Bone Meal (White Dye)";
            }
        }
        return "Unknown Dye";
    }

    private String getLogName(int data) {
        switch (data) {
            case 0: {
                return "Oak Log";
            }
            case 1: {
                return "Spruce Log";
            }
            case 2: {
                return "Birch Log";
            }
        }
        return "Unknown Log";
    }

    private String getLeafName(int data) {
        switch (data) {
            case 0: {
                return "Oak Leaves";
            }
            case 1: {
                return "Spruce Leaves";
            }
            case 2: {
                return "Birch Leaves";
            }
        }
        return "Unknown Leaves";
    }

    private String getSaplingName(int data) {
        switch (data) {
            case 0: {
                return "Oak Sapling";
            }
            case 1: {
                return "Spruce Sapling";
            }
            case 2: {
                return "Birch Sapling";
            }
        }
        return "Unknown Sapling";
    }

    private String getSlabName(int data) {
        switch (data) {
            case 0: {
                return "Stone Slab";
            }
            case 1: {
                return "Sandstone Slab";
            }
            case 2: {
                return "Wooden Slab";
            }
            case 3: {
                return "Cobblestone Slab";
            }
        }
        return "Unknown Slab";
    }
}

