/*
 * Decompiled with CFR 0.152.
 */
package org.garsooon;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.garsooon.AuctionManager;
import org.garsooon.Commands.AuctionCommand;
import org.garsooon.Commands.AuctionResetCommand;
import org.garsooon.Commands.BidCommand;
import org.garsooon.Economy.Method;
import org.garsooon.Economy.Methods;
import org.garsooon.Listener.PlayerJoinListener;
import org.yaml.snakeyaml.Yaml;

public class AuctionPlugin
extends JavaPlugin {
    private static AuctionPlugin instance;
    private AuctionManager auctionManager;
    private Map<String, Object> config;
    private Method economy;

    public void onEnable() {
        instance = this;
        this.saveDefaultConfigYaml();
        this.loadConfigYaml();
        boolean economyLoaded = Methods.setMethod(this.getServer().getPluginManager());
        if (!economyLoaded || Methods.getMethod() == null) {
            Bukkit.getLogger().severe("[Auctioneer] No compatible economy plugin found! Disabling plugin.");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.economy = Methods.getMethod();
        Bukkit.getLogger().info("[Auctioneer] Economy method loaded: " + this.economy.getName() + " v" + this.economy.getVersion());
        this.auctionManager = new AuctionManager(this, this.economy);
        this.getCommand("auction").setExecutor((CommandExecutor)new AuctionCommand(this));
        this.getCommand("bid").setExecutor((CommandExecutor)new BidCommand(this));
        this.getCommand("auctionreset").setExecutor((CommandExecutor)new AuctionResetCommand(this));
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerJoinListener(this, this.auctionManager), (Plugin)this);
        this.getServer().getLogger().info("[Auctioneer] Plugin enabled.");
        Bukkit.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this, () -> this.auctionManager.cleanupStuckAuction(), 600L, 600L);
    }

    public void onDisable() {
        this.getServer().getLogger().info("[Auctioneer] Plugin disabled.");
    }

    private void saveDefaultConfigYaml() {
        File configFile = new File(this.getDataFolder(), "config.yml");
        if (!configFile.exists()) {
            this.getDataFolder().mkdirs();
            try (InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream("/config.yml");
                 FileOutputStream out = new FileOutputStream(configFile);){
                int len;
                if (in == null) {
                    System.out.println("Default config.yml missing from JAR!");
                    return;
                }
                byte[] buffer = new byte[1024];
                while ((len = in.read(buffer)) > 0) {
                    ((OutputStream)out).write(buffer, 0, len);
                }
                System.out.println("Default config.yml copied to plugin folder.");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void loadConfigYaml() {
        File configFile = new File(this.getDataFolder(), "config.yml");
        if (!configFile.exists()) {
            System.out.println("config.yml not found on disk!");
            this.config = new HashMap<String, Object>();
            return;
        }
        try (FileInputStream in = new FileInputStream(configFile);){
            Yaml yaml = new Yaml();
            Object loaded = yaml.load((InputStream)in);
            if (loaded instanceof Map) {
                this.config = (Map)loaded;
            } else {
                this.config = new HashMap<String, Object>();
                System.out.println("config.yml was not a valid YAML map.");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            this.config = new HashMap<String, Object>();
        }
    }

    public Map<String, Object> getCustomConfig() {
        return this.config;
    }

    public static AuctionPlugin getInstance() {
        return instance;
    }

    public AuctionManager getAuctionManager() {
        return this.auctionManager;
    }
}

