/*
 * Decompiled with CFR 0.152.
 */
package org.garsooon.Commands;

import java.util.HashSet;
import java.util.Set;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.garsooon.AuctionManager;
import org.garsooon.AuctionPlugin;

public class AuctionResetCommand
implements CommandExecutor {
    private final AuctionPlugin plugin;
    private final AuctionManager auctionManager;
    private final Set<String> confirmationSet = new HashSet<String>();

    public AuctionResetCommand(AuctionPlugin plugin) {
        this.plugin = plugin;
        this.auctionManager = plugin.getAuctionManager();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(ChatColor.RED + "Only players can use this command.");
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("auctioneer.admin")) {
            player.sendMessage(ChatColor.RED + "You do not have permission to use this command.");
            return true;
        }
        String name = player.getName();
        if (!this.confirmationSet.contains(name)) {
            this.confirmationSet.add(name);
            player.sendMessage(ChatColor.RED + "This will reset the current auction and NOT give items or");
            player.sendMessage(ChatColor.RED + "money back! Run the command again to confirm.");
            return true;
        }
        this.confirmationSet.remove(name);
        this.auctionManager.forceEnd();
        player.sendMessage(ChatColor.GREEN + "Auction forcibly reset.");
        return true;
    }
}

