/*
 * Decompiled with CFR 0.152.
 */
package org.garsooon.Economy.methods;

import com.earth2me.essentials.Essentials;
import com.earth2me.essentials.User;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import org.garsooon.Economy.Method;

public class EE17
implements Method {
    private Essentials essentials;

    public Essentials getPlugin() {
        return this.essentials;
    }

    @Override
    public String getName() {
        return "Essentials";
    }

    @Override
    public String getVersion() {
        return "2.2";
    }

    @Override
    public int fractionalDigits() {
        return -1;
    }

    @Override
    public String format(double amount) {
        return "$" + String.format("%.2f", amount);
    }

    @Override
    public boolean hasBanks() {
        return false;
    }

    @Override
    public boolean hasBank(String bank, World world) {
        return false;
    }

    @Override
    public boolean hasAccount(String name, World world) {
        return this.essentials.getUserMap().getUser(name) != null;
    }

    @Override
    public boolean hasBankAccount(String bank, String name, World world) {
        return false;
    }

    @Override
    public Method.MethodAccount getAccount(String name, World world) {
        if (!this.hasAccount(name, world)) {
            return null;
        }
        return new EEcoAccount(name, this.essentials);
    }

    @Override
    public Method.MethodBankAccount getBankAccount(String bank, String name, World world) {
        return null;
    }

    @Override
    public boolean isCompatible(Plugin plugin) {
        return plugin.getDescription().getName().equalsIgnoreCase("Essentials");
    }

    @Override
    public void setPlugin(Plugin plugin) {
        this.essentials = (Essentials)plugin;
    }

    public static class EEcoAccount
    implements Method.MethodAccount {
        private final String name;
        private final Essentials essentials;

        public EEcoAccount(String name, Essentials essentials) {
            this.name = name;
            this.essentials = essentials;
        }

        private User getUser() {
            return this.essentials.getUserMap().getUser(this.name);
        }

        @Override
        public double balance(World world) {
            User user = this.getUser();
            return user != null ? user.getMoney() : 0.0;
        }

        @Override
        public boolean set(double amount, World world) {
            User user = this.getUser();
            if (user == null) {
                return false;
            }
            user.setMoney(amount);
            return true;
        }

        @Override
        public boolean add(double amount, World world) {
            User user = this.getUser();
            if (user == null) {
                return false;
            }
            user.giveMoney(amount);
            return true;
        }

        @Override
        public boolean subtract(double amount, World world) {
            User user = this.getUser();
            if (user == null) {
                return false;
            }
            user.takeMoney(amount);
            return true;
        }

        @Override
        public boolean multiply(double amount, World world) {
            double current = this.balance(world);
            return this.set(current * amount, world);
        }

        @Override
        public boolean divide(double amount, World world) {
            if (amount == 0.0) {
                return false;
            }
            double current = this.balance(world);
            return this.set(current / amount, world);
        }

        @Override
        public boolean hasEnough(double amount, World world) {
            return this.balance(world) >= amount;
        }

        @Override
        public boolean hasOver(double amount, World world) {
            return this.balance(world) > amount;
        }

        @Override
        public boolean hasUnder(double amount, World world) {
            return this.balance(world) < amount;
        }

        @Override
        public boolean isNegative(World world) {
            return this.balance(world) < 0.0;
        }

        @Override
        public boolean remove() {
            return false;
        }
    }
}

