/*
 * Decompiled with CFR 0.152.
 */
package org.garsooon.Economy.methods;

import java.math.BigDecimal;
import java.util.UUID;
import me.zavdav.zcore.ZCore;
import me.zavdav.zcore.api.Economy;
import me.zavdav.zcore.util.PlayerUtils;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import org.garsooon.Economy.Method;

public class ZCoreEco
implements Method {
    private ZCore zcore;

    @Override
    public Object getPlugin() {
        return this.zcore;
    }

    @Override
    public String getName() {
        return "ZCore";
    }

    @Override
    public String getVersion() {
        return this.zcore.getDescription().getVersion();
    }

    @Override
    public int fractionalDigits() {
        return 2;
    }

    @Override
    public String format(double amount) {
        return Economy.formatBalance((BigDecimal)BigDecimal.valueOf(amount));
    }

    @Override
    public boolean hasBanks() {
        return false;
    }

    @Override
    public boolean hasBank(String bank, World world) {
        return false;
    }

    @Override
    public boolean hasAccount(String name, World world) {
        try {
            UUID uuid = PlayerUtils.getUUIDFromUsername((String)name);
            return Economy.userExists((UUID)uuid);
        }
        catch (Throwable e) {
            return false;
        }
    }

    @Override
    public boolean hasBankAccount(String bank, String name, World world) {
        return false;
    }

    @Override
    public Method.MethodAccount getAccount(String name, World world) {
        if (!this.hasAccount(name, world)) {
            return null;
        }
        return new ZEcoAccount(PlayerUtils.getUUIDFromUsername((String)name));
    }

    @Override
    public Method.MethodBankAccount getBankAccount(String bank, String name, World world) {
        return null;
    }

    @Override
    public boolean isCompatible(Plugin plugin) {
        return plugin.getDescription().getName().equalsIgnoreCase("ZCore") && plugin instanceof ZCore;
    }

    @Override
    public void setPlugin(Plugin plugin) {
        this.zcore = (ZCore)plugin;
    }

    public static class ZEcoAccount
    implements Method.MethodAccount {
        private final UUID uuid;

        public ZEcoAccount(UUID uuid) {
            this.uuid = uuid;
        }

        @Override
        public double balance(World world) {
            try {
                return Economy.getBalance((UUID)this.uuid).doubleValue();
            }
            catch (Throwable e) {
                e.printStackTrace();
                return 0.0;
            }
        }

        @Override
        public boolean set(double amount, World world) {
            try {
                Economy.setBalance((UUID)this.uuid, (BigDecimal)BigDecimal.valueOf(amount));
                return true;
            }
            catch (Throwable e) {
                e.printStackTrace();
                return false;
            }
        }

        @Override
        public boolean add(double amount, World world) {
            try {
                Economy.addBalance((UUID)this.uuid, (BigDecimal)BigDecimal.valueOf(amount));
                return true;
            }
            catch (Throwable e) {
                e.printStackTrace();
                return false;
            }
        }

        @Override
        public boolean subtract(double amount, World world) {
            try {
                Economy.subtractBalance((UUID)this.uuid, (BigDecimal)BigDecimal.valueOf(amount));
                return true;
            }
            catch (Throwable e) {
                e.printStackTrace();
                return false;
            }
        }

        @Override
        public boolean multiply(double amount, World world) {
            try {
                Economy.multiplyBalance((UUID)this.uuid, (BigDecimal)BigDecimal.valueOf(amount));
                return true;
            }
            catch (Throwable e) {
                e.printStackTrace();
                return false;
            }
        }

        @Override
        public boolean divide(double amount, World world) {
            try {
                Economy.divideBalance((UUID)this.uuid, (BigDecimal)BigDecimal.valueOf(amount));
                return true;
            }
            catch (Throwable e) {
                e.printStackTrace();
                return false;
            }
        }

        @Override
        public boolean hasEnough(double amount, World world) {
            try {
                return Economy.hasEnough((UUID)this.uuid, (BigDecimal)BigDecimal.valueOf(amount));
            }
            catch (Throwable e) {
                e.printStackTrace();
                return false;
            }
        }

        @Override
        public boolean hasOver(double amount, World world) {
            try {
                return Economy.hasOver((UUID)this.uuid, (BigDecimal)BigDecimal.valueOf(amount));
            }
            catch (Throwable e) {
                e.printStackTrace();
                return false;
            }
        }

        @Override
        public boolean hasUnder(double amount, World world) {
            try {
                return Economy.hasUnder((UUID)this.uuid, (BigDecimal)BigDecimal.valueOf(amount));
            }
            catch (Throwable e) {
                e.printStackTrace();
                return false;
            }
        }

        @Override
        public boolean isNegative(World world) {
            return false;
        }

        @Override
        public boolean remove() {
            return false;
        }
    }
}

