/*
 * Decompiled with CFR 0.152.
 */
package org.garsooon.Listener;

import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.garsooon.AuctionManager;

public class PlayerJoinListener
implements Listener {
    private final AuctionManager auctionManager;
    private final JavaPlugin plugin;

    public PlayerJoinListener(JavaPlugin plugin, AuctionManager auctionManager) {
        this.plugin = plugin;
        this.auctionManager = auctionManager;
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        if (!this.auctionManager.isAuctionRunning()) {
            return;
        }
        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
            Player player = event.getPlayer();
            String itemName = this.auctionManager.getCurrentItemDisplayName();
            int itemAmount = this.auctionManager.getItemAmount();
            String sellerName = this.auctionManager.getCurrentSellerName();
            double currentBid = this.auctionManager.getCurrentBid();
            String durabilityInfo = "";
            ItemStack item = this.auctionManager.getCurrentItem();
            short dur = item.getDurability();
            short maxDur = item.getType().getMaxDurability();
            if (maxDur > 0) {
                int remaining = maxDur - dur;
                int pct = (int)((double)remaining * 100.0 / (double)maxDur);
                ChatColor durColor = ChatColor.GREEN;
                if (pct <= 25) {
                    durColor = ChatColor.RED;
                } else if (pct <= 50) {
                    durColor = ChatColor.GOLD;
                } else if (pct <= 75) {
                    durColor = ChatColor.YELLOW;
                }
                durabilityInfo = durColor + " [" + remaining + "/" + maxDur + " durability]";
            }
            player.sendMessage(ChatColor.GOLD + "An auction is currently running!");
            player.sendMessage(ChatColor.GREEN + sellerName + " is auctioning " + ChatColor.YELLOW + itemAmount + "x " + itemName + ChatColor.GREEN + " starting at $" + String.format("%.2f", currentBid));
        }, 1L);
    }
}

