/*
 * Decompiled with CFR 0.152.
 */
package team.creative.enhancedvisuals;

import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import team.creative.creativecore.CreativeCore;
import team.creative.creativecore.ICreativeLoader;
import team.creative.creativecore.client.ClientLoader;
import team.creative.creativecore.common.CommonLoader;
import team.creative.creativecore.common.config.holder.ConfigHolderDynamic;
import team.creative.creativecore.common.config.holder.CreativeConfigRegistry;
import team.creative.creativecore.common.config.sync.ConfigSynchronization;
import team.creative.creativecore.common.network.CreativeNetwork;
import team.creative.enhancedvisuals.EVManager;
import team.creative.enhancedvisuals.EnhancedVisualsConfig;
import team.creative.enhancedvisuals.api.VisualHandler;
import team.creative.enhancedvisuals.client.EVClient;
import team.creative.enhancedvisuals.common.addon.coldsweat.ColdSweatAddon;
import team.creative.enhancedvisuals.common.addon.survive.SurviveAddon;
import team.creative.enhancedvisuals.common.addon.toughasnails.TANAddon;
import team.creative.enhancedvisuals.common.death.DeathMessages;
import team.creative.enhancedvisuals.common.event.EVEvents;
import team.creative.enhancedvisuals.common.handler.VisualHandlers;
import team.creative.enhancedvisuals.common.packet.DamagePacket;
import team.creative.enhancedvisuals.common.packet.ExplosionPacket;
import team.creative.enhancedvisuals.common.packet.PotionPacket;
import team.creative.enhancedvisuals.common.visual.VisualRegistry;
import team.creative.enhancedvisuals.server.EVManagerServer;

@Mod(value="enhancedvisuals")
public class EnhancedVisuals
implements CommonLoader,
ClientLoader {
    public static final String MODID = "enhancedvisuals";
    public static final Logger LOGGER = LogManager.getLogger((String)"enhancedvisuals");
    public static final CreativeNetwork NETWORK = new CreativeNetwork(1, LOGGER, ResourceLocation.tryBuild((String)"enhancedvisuals", (String)"main"));
    public static EVEvents EVENTS;
    public static DeathMessages MESSAGES;
    public static EnhancedVisualsConfig CONFIG;
    public static EVManager MANAGER;

    public EnhancedVisuals() {
        ICreativeLoader loader = CreativeCore.loader();
        loader.register((CommonLoader)this);
        loader.registerClient((ClientLoader)this);
    }

    public void onInitializeClient() {
        CreativeCore.loader().registerClientStarted(EVClient::init);
    }

    public void onInitialize() {
        NETWORK.registerType(ExplosionPacket.class, ExplosionPacket::new);
        NETWORK.registerType(DamagePacket.class, DamagePacket::new);
        NETWORK.registerType(PotionPacket.class, PotionPacket::new);
        ICreativeLoader loader = CreativeCore.loader();
        EVENTS = new EVEvents();
        VisualHandlers.init();
        MESSAGES = new DeathMessages();
        if (loader.isModLoaded("survive")) {
            SurviveAddon.load();
        }
        if (loader.isModLoaded("toughasnails")) {
            TANAddon.load();
        }
        if (loader.isModLoaded("cold_sweat")) {
            ColdSweatAddon.load();
        }
        ConfigHolderDynamic root = CreativeConfigRegistry.ROOT.registerFolder(MODID);
        CONFIG = new EnhancedVisualsConfig();
        root.registerValue("general", (Object)CONFIG, ConfigSynchronization.CLIENT, false);
        root.registerValue("messages", (Object)MESSAGES);
        ConfigHolderDynamic handlers = root.registerFolder("handlers", ConfigSynchronization.CLIENT);
        for (Map.Entry<ResourceLocation, VisualHandler> entry : VisualRegistry.entrySet()) {
            handlers.registerValue(entry.getKey().getPath(), (Object)entry.getValue());
        }
    }

    static {
        MANAGER = new EVManagerServer();
    }
}

