/*
 * Decompiled with CFR 0.152.
 */
package team.creative.enhancedvisuals.client.render;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collection;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.DeathScreen;
import org.joml.Matrix3x2fStack;
import team.creative.creativecore.common.util.mc.LanguageUtils;
import team.creative.enhancedvisuals.EnhancedVisuals;
import team.creative.enhancedvisuals.api.Particle;
import team.creative.enhancedvisuals.api.Visual;
import team.creative.enhancedvisuals.api.VisualCategory;
import team.creative.enhancedvisuals.api.type.VisualType;
import team.creative.enhancedvisuals.client.EVClient;
import team.creative.enhancedvisuals.client.type.VisualTypeClient;

public class EVRenderer {
    private static String lastRenderedMessage;
    private static int framebufferWidth;
    private static int framebufferHeight;
    public static boolean reloadResources;

    public static void init() {
    }

    public static void renderShaders(DeltaTracker tracker) {
        float partialTicks = tracker.getGameTimeDeltaPartialTick(false);
        RenderSystem.resetTextureMatrix();
        Minecraft mc = Minecraft.getInstance();
        int screenWidth = mc.getWindow().getWidth();
        int screenHeight = mc.getWindow().getHeight();
        RenderTarget renderTarget = mc.getMainRenderTarget();
        RenderSystem.getDevice().createCommandEncoder().clearDepthTexture(renderTarget.getDepthTexture(), 1.0);
        EVRenderer.renderVisuals(null, EnhancedVisuals.MANAGER.visuals(VisualCategory.shader), screenWidth, screenHeight, partialTicks);
    }

    public static void render(Object object) {
        GuiGraphics graphics = (GuiGraphics)object;
        if (EVClient.shouldRender()) {
            Minecraft mc = Minecraft.getInstance();
            if (reloadResources) {
                for (VisualType visualType : VisualType.types()) {
                    ((VisualTypeClient)visualType.clientSideType).loadResources(mc.getResourceManager());
                }
                reloadResources = false;
            }
            if (!(mc.screen instanceof DeathScreen)) {
                float partialTicks = Minecraft.getInstance().getDeltaTracker().getGameTimeDeltaPartialTick(false);
                if (mc.getMainRenderTarget().width != framebufferWidth || mc.getMainRenderTarget().height != framebufferHeight) {
                    for (VisualType type : VisualType.types()) {
                        ((VisualTypeClient)type.clientSideType).resize(mc.getMainRenderTarget());
                    }
                    framebufferWidth = mc.getMainRenderTarget().width;
                    framebufferHeight = mc.getMainRenderTarget().height;
                }
                int n = mc.getWindow().getGuiScaledWidth();
                int screenHeight = mc.getWindow().getGuiScaledHeight();
                EVRenderer.renderVisuals(graphics, EnhancedVisuals.MANAGER.visuals(VisualCategory.overlay), n, screenHeight, partialTicks);
                EVRenderer.renderVisuals(graphics, EnhancedVisuals.MANAGER.visuals(VisualCategory.particle), n, screenHeight, partialTicks);
            } else if (EnhancedVisuals.MESSAGES.enabled) {
                if (lastRenderedMessage == null) {
                    lastRenderedMessage = LanguageUtils.translate((String)EnhancedVisuals.MESSAGES.pickRandomDeathMessage());
                }
                if (lastRenderedMessage != null) {
                    graphics.drawString(mc.font, "\"" + lastRenderedMessage + "\"", mc.screen.width / 2 - mc.font.width(lastRenderedMessage) / 2, 114, 0xFFFFFF);
                }
            }
        }
    }

    public static void render(Visual visual, GuiGraphics graphics, int screenWidth, int screenHeight, float partialTicks) {
        VisualTypeClient ct = EVClient.get(visual.type);
        if (visual instanceof Particle) {
            Particle p = (Particle)visual;
            Matrix3x2fStack stack = graphics.pose();
            stack.pushMatrix();
            stack.translate((float)(p.x + p.width / 2), (float)(p.y + p.height / 2));
            stack.rotate((float)Math.toRadians(p.rotation));
            ct.render(graphics, visual.handler, visual, screenWidth, screenHeight, partialTicks);
            stack.popMatrix();
        } else {
            ct.render(graphics, visual.handler, visual, screenWidth, screenHeight, partialTicks);
        }
    }

    private static void renderVisuals(GuiGraphics graphics, Collection<Visual> visuals, int screenWidth, int screenHeight, float partialTicks) {
        if (visuals == null || visuals.isEmpty()) {
            return;
        }
        try {
            for (Visual visual : visuals) {
                if (!visual.isVisible()) continue;
                EVRenderer.render(visual, graphics, screenWidth, screenHeight, partialTicks);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        reloadResources = false;
    }
}

