/*
 * Decompiled with CFR 0.152.
 */
package team.creative.enhancedvisuals.client.render;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import team.creative.enhancedvisuals.client.render.TextureCacheAnimation;
import team.creative.enhancedvisuals.client.render.TextureCacheSimple;

public abstract class TextureCache {
    public abstract ResourceLocation getFirst();

    public abstract ResourceLocation getResource();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TextureCache parse(ResourceManager manager, String domain, String baseLocation) {
        ResourceLocation location = null;
        int i = 0;
        Resource resource = null;
        ArrayList<ResourceLocation> locations = null;
        while ((resource = (Resource)manager.getResource(location = ResourceLocation.tryBuild((String)domain, (String)(baseLocation + "-" + i + ".png"))).orElse(null)) != null) {
            if (locations == null) {
                locations = new ArrayList<ResourceLocation>();
            }
            locations.add(location);
            ++i;
        }
        if (locations != null) {
            int animationSpeed;
            block11: {
                animationSpeed = 1;
                try {
                    resource = manager.getResource(ResourceLocation.tryBuild((String)domain, (String)(baseLocation + ".ani"))).orElse(null);
                    if (resource == null) break block11;
                    try (InputStream input = resource.open();){
                        animationSpeed = Integer.parseInt(new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n")));
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return new TextureCacheAnimation(locations.toArray(new ResourceLocation[locations.size()]), animationSpeed);
        }
        location = ResourceLocation.tryBuild((String)domain, (String)(baseLocation + ".png"));
        if (manager.getResource(location).orElse(null) != null) {
            return new TextureCacheSimple(location);
        }
        return null;
    }
}

