/*
 * Decompiled with CFR 0.152.
 */
package team.creative.enhancedvisuals.client.sound;

import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.ChannelAccess;
import net.minecraft.client.sounds.SoundEngine;
import net.minecraft.client.sounds.SoundManager;
import team.creative.creativecore.common.config.premade.curve.DecimalCurve;
import team.creative.enhancedvisuals.common.handler.VisualHandlers;
import team.creative.enhancedvisuals.mixin.SoundEngineAccessor;
import team.creative.enhancedvisuals.mixin.SoundManagerAccessor;

public class SoundMuteHandler {
    public static boolean isMuting = false;
    public static SoundEngine engine;
    public static SoundManager manager;
    public static DecimalCurve muteGraph;
    public static int timeTick;

    public static void tick() {
        if (isMuting) {
            double factor = muteGraph.valueAt((double)timeTick);
            if (factor <= 0.0) {
                SoundMuteHandler.endMuting();
            } else {
                SoundMuteHandler.setMuteVolume((float)(1.0 - factor));
                ++timeTick;
            }
        }
    }

    public static float getClampedVolume(float volume) {
        return volume * (isMuting ? (float)(1.0 - muteGraph.valueAt((double)timeTick)) : 1.0f);
    }

    public static Map<SoundInstance, ChannelAccess.ChannelHandle> getSounds() {
        return ((SoundEngineAccessor)engine).getInstanceToChannel();
    }

    public static void setMuteVolume(float muteVolume) {
        if (!isMuting) {
            return;
        }
        SoundMuteHandler.getSounds().forEach((soundinstance, channelHandler) -> {
            if (soundinstance.getLocation().equals((Object)VisualHandlers.EXPLOSION.beepSound)) {
                return;
            }
            float f = ((SoundEngineAccessor)engine).invokeCalculateVolume((SoundInstance)soundinstance);
            channelHandler.execute(channel -> channel.setVolume(f * muteVolume));
        });
    }

    public static boolean startMuting(DecimalCurve muteGraph) {
        if (engine == null) {
            manager = Minecraft.getInstance().getSoundManager();
            engine = ((SoundManagerAccessor)manager).getSoundEngine();
        }
        if (isMuting && SoundMuteHandler.muteGraph.valueAt((double)timeTick) > muteGraph.valueAt(0.0)) {
            SoundMuteHandler.muteGraph = muteGraph;
            timeTick = 0;
            SoundMuteHandler.tick();
            return true;
        }
        if (!isMuting) {
            SoundMuteHandler.muteGraph = muteGraph;
            timeTick = 0;
            isMuting = true;
            SoundMuteHandler.tick();
            return true;
        }
        return false;
    }

    public static void endMuting() {
        SoundMuteHandler.setMuteVolume(1.0f);
        isMuting = false;
    }

    static {
        timeTick = 0;
    }
}

