/*
 * Decompiled with CFR 0.152.
 */
package team.creative.enhancedvisuals.client.type;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Optional;
import javax.imageio.ImageIO;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import team.creative.creativecore.client.render.gui.CreativeGuiGraphics;
import team.creative.creativecore.common.util.mc.ColorUtils;
import team.creative.enhancedvisuals.EnhancedVisuals;
import team.creative.enhancedvisuals.api.Visual;
import team.creative.enhancedvisuals.api.VisualHandler;
import team.creative.enhancedvisuals.api.type.VisualTypeTexture;
import team.creative.enhancedvisuals.client.render.TextureCache;
import team.creative.enhancedvisuals.client.type.VisualTypeClient;

public class VisualTypeTextureClient<T extends VisualTypeTexture>
extends VisualTypeClient<T> {
    private static final float DEFAULT_PARTICLE_SIZE = 0.15f;
    public TextureCache[] resources;
    public Dimension dimension;
    public float ratio;

    public VisualTypeTextureClient(T type) {
        super(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadResources(ResourceManager manager) {
        String baseLocation = "visuals/" + ((VisualTypeTexture)this.type).cat.name() + "/" + ((VisualTypeTexture)this.type).name + "/" + ((VisualTypeTexture)this.type).name;
        ArrayList<TextureCache> caches = new ArrayList<TextureCache>();
        int i = 0;
        TextureCache resource = null;
        String domain = ((VisualTypeTexture)this.type).domain == null ? "enhancedvisuals" : ((VisualTypeTexture)this.type).domain;
        try {
            while ((resource = TextureCache.parse(manager, domain, baseLocation + i)) != null) {
                Optional re;
                if (i == 0 && (re = manager.getResource(resource.getFirst())).isPresent()) {
                    try (InputStream input = ((Resource)re.orElseThrow()).open();){
                        BufferedImage image = ImageIO.read(input);
                        this.dimension = new Dimension(image.getWidth(), image.getHeight());
                        this.ratio = (float)this.dimension.width / (float)this.dimension.height;
                    }
                }
                caches.add(resource);
                ++i;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.resources = caches.toArray(new TextureCache[0]);
        if (this.resources.length == 0) {
            EnhancedVisuals.LOGGER.warn("Could not find any resources for '" + ((VisualTypeTexture)this.type).name + "'!");
        }
    }

    @Override
    public int getVariantAmount() {
        return this.resources.length;
    }

    public ResourceLocation getResource(Visual visual) {
        if (((VisualTypeTexture)this.type).animationSpeed > 0) {
            long time = Math.abs(System.nanoTime() / 3000000L / (long)((VisualTypeTexture)this.type).animationSpeed);
            return this.resources[(int)(time % (long)this.resources.length)].getResource();
        }
        return this.resources[visual.variant].getResource();
    }

    @Override
    public void render(GuiGraphics graphics, VisualHandler handler, Visual visual, int screenWidth, int screenHeight, float partialTicks) {
        int red = visual.color != null ? (int)visual.color.getRed() : 255;
        int green = visual.color != null ? (int)visual.color.getGreen() : 255;
        int blue = visual.color != null ? (int)visual.color.getBlue() : 255;
        int width = visual.getWidth(screenWidth);
        int height = visual.getHeight(screenHeight);
        float opacity = visual.getOpacity();
        int color = ColorUtils.rgba((int)red, (int)green, (int)blue, (int)((int)(opacity * 255.0f)));
        ((CreativeGuiGraphics)graphics).textureRectColorStretched(this.getResource(visual), 0, 0, width, height, color);
    }

    @Override
    public int getWidth(int screenWidth, int screenHeight) {
        return (int)((float)screenHeight * 0.15f * this.ratio);
    }

    @Override
    public int getHeight(int screenWidth, int screenHeight) {
        return (int)((float)screenHeight * 0.15f);
    }
}

