/*
 * Decompiled with CFR 0.152.
 */
package team.creative.enhancedvisuals.common.addon.coldsweat;

import com.momosoftworks.coldsweat.api.util.Temperature;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;
import team.creative.creativecore.common.config.api.CreativeConfig;
import team.creative.enhancedvisuals.api.Visual;
import team.creative.enhancedvisuals.api.VisualHandler;
import team.creative.enhancedvisuals.api.type.VisualType;
import team.creative.enhancedvisuals.api.type.VisualTypeOverlay;

public class TemperatureHandler
extends VisualHandler {
    @CreativeConfig
    public double defaultIntensity = 0.0;
    @CreativeConfig
    public double mediumIntensity = 0.2;
    @CreativeConfig
    public double maxIntensity = 0.3;
    @CreativeConfig
    public double fadeFactor = 0.005;
    @CreativeConfig
    public VisualType freeze = new VisualTypeOverlay("freeze");
    public Visual freezeVisual;
    @CreativeConfig
    public VisualType heat = new VisualTypeOverlay("heat");
    public Visual heatVisual;
    @CreativeConfig
    public double coldestTemperature = -100.0;
    @CreativeConfig
    public double hypotheremiaTemperature = -75.0;
    @CreativeConfig
    public double coldTemperature = -50.0;
    @CreativeConfig
    public double defaultTemperature = 0.0;
    @CreativeConfig
    public double warmTemperature = 50.0;
    @CreativeConfig
    public double hyperthermiaTemperature = 75.0;
    @CreativeConfig
    public double hottestTemperature = 100.0;

    public double getTemperature(Player player) {
        return Temperature.get((LivingEntity)player, (Temperature.Trait)Temperature.Trait.BODY);
    }

    @Override
    public void tick(@Nullable Player player) {
        if (this.freezeVisual == null) {
            this.freezeVisual = new Visual(this.freeze, this, 0);
            this.freezeVisual.setOpacityInternal(0.0f);
            this.add(this.freezeVisual);
            this.heatVisual = new Visual(this.heat, this, 0);
            this.heatVisual.setOpacityInternal(0.0f);
            this.add(this.heatVisual);
        }
        double aimedHeat = this.defaultIntensity;
        double aimedFreeze = this.defaultIntensity;
        double temp = this.defaultTemperature;
        if (player != null && player.isAlive()) {
            temp = this.getTemperature(player);
        }
        if (temp <= this.coldestTemperature) {
            aimedHeat = 0.0;
            aimedFreeze = this.maxIntensity;
        } else if (temp < this.hypotheremiaTemperature) {
            aimedHeat = 0.0;
            aimedFreeze = (1.0 - (temp - this.coldestTemperature) / (this.hypotheremiaTemperature - this.coldestTemperature)) * (this.maxIntensity - this.mediumIntensity) + this.mediumIntensity;
        } else if (temp < this.coldTemperature) {
            aimedHeat = 0.0;
            aimedFreeze = (1.0 - (temp - this.hypotheremiaTemperature) / (this.coldTemperature - this.hypotheremiaTemperature)) * this.mediumIntensity;
        } else if (temp >= this.hottestTemperature) {
            aimedHeat = this.maxIntensity;
            aimedFreeze = 0.0;
        } else if (temp > this.hyperthermiaTemperature) {
            aimedHeat = (this.hottestTemperature - temp) / (this.hottestTemperature - this.hyperthermiaTemperature) * (this.maxIntensity - this.mediumIntensity) + this.mediumIntensity;
            aimedFreeze = 0.0;
        } else if (temp > this.warmTemperature) {
            aimedHeat = (this.hyperthermiaTemperature - temp) / (this.hyperthermiaTemperature - this.warmTemperature) * this.mediumIntensity;
            aimedFreeze = 0.0;
        } else {
            aimedHeat = 0.0;
            aimedFreeze = 0.0;
        }
        if ((double)this.freezeVisual.getOpacityInternal() < aimedFreeze) {
            this.freezeVisual.setOpacityInternal((float)Math.min((double)this.freezeVisual.getOpacityInternal() + this.fadeFactor, aimedFreeze));
        } else if ((double)this.freezeVisual.getOpacityInternal() > aimedFreeze) {
            this.freezeVisual.setOpacityInternal((float)Math.max((double)this.freezeVisual.getOpacityInternal() - this.fadeFactor, aimedFreeze));
        }
        if ((double)this.heatVisual.getOpacityInternal() < aimedHeat) {
            this.heatVisual.setOpacityInternal((float)Math.min((double)this.heatVisual.getOpacityInternal() + this.fadeFactor, aimedHeat));
        } else if ((double)this.heatVisual.getOpacityInternal() > aimedHeat) {
            this.heatVisual.setOpacityInternal((float)Math.max((double)this.heatVisual.getOpacityInternal() - this.fadeFactor, aimedHeat));
        }
    }
}

