/*
 * Decompiled with CFR 0.152.
 */
package team.creative.enhancedvisuals.common.event;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownSplashPotion;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.phys.AABB;
import team.creative.creativecore.common.network.CreativePacket;
import team.creative.enhancedvisuals.EnhancedVisuals;
import team.creative.enhancedvisuals.common.packet.DamagePacket;
import team.creative.enhancedvisuals.common.packet.ExplosionPacket;
import team.creative.enhancedvisuals.common.packet.PotionPacket;
import team.creative.enhancedvisuals.mixin.EntityAccessor;

public class EVEvents {
    public void explosion(Explosion explosion, List<Entity> affected) {
        ExplosionPacket packet = new ExplosionPacket(explosion.center(), explosion.radius(), explosion.getBlockInteraction(), explosion.getDirectSourceEntity() != null ? explosion.getDirectSourceEntity().getId() : -1, explosion.getDirectSourceEntity() != null ? explosion.getDirectSourceEntity().getClass() : null);
        for (Entity entity : affected) {
            if (!(entity instanceof ServerPlayer)) continue;
            ServerPlayer s = (ServerPlayer)entity;
            EnhancedVisuals.NETWORK.sendToClient((CreativePacket)packet, s);
        }
    }

    public void impact(Projectile projectile) {
        if (projectile instanceof ThrownSplashPotion) {
            ThrownSplashPotion entity = (ThrownSplashPotion)projectile;
            if (!projectile.level().isClientSide()) {
                AABB axisalignedbb = entity.getBoundingBox().inflate(4.0, 2.0, 4.0);
                List list = entity.level().getEntitiesOfClass(LivingEntity.class, axisalignedbb);
                if (!list.isEmpty()) {
                    for (LivingEntity livingentity : list) {
                        if (!livingentity.isAffectedByPotions() || !(livingentity instanceof ServerPlayer)) continue;
                        ServerPlayer s = (ServerPlayer)livingentity;
                        double d0 = entity.distanceToSqr((Entity)livingentity);
                        if (!(d0 < 16.0)) continue;
                        EnhancedVisuals.NETWORK.sendToClient((CreativePacket)new PotionPacket(Math.sqrt(d0), entity.getItem()), s);
                    }
                }
            }
        }
    }

    public void damage(Player target, DamageSource source, float damage) {
        if (target.level().isClientSide()) {
            return;
        }
        if (EnhancedVisuals.CONFIG.enableDamageDebug) {
            target.displayClientMessage((Component)Component.literal((String)(source.getMsgId() + "," + source.getLocalizedDeathMessage((LivingEntity)target).getString())), false);
        }
        EnhancedVisuals.NETWORK.sendToClient((CreativePacket)new DamagePacket(target, source, damage), (ServerPlayer)target);
    }

    public static boolean areEyesInWater(Player player) {
        return ((EntityAccessor)player).getWasEyeInWater();
    }
}

