/*
 * Decompiled with CFR 0.152.
 */
package team.creative.enhancedvisuals.common.handler;

import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import team.creative.creativecore.common.config.api.CreativeConfig;
import team.creative.creativecore.common.config.premade.curve.Curve;
import team.creative.creativecore.common.config.premade.curve.DecimalCurve;
import team.creative.enhancedvisuals.api.VisualHandler;
import team.creative.enhancedvisuals.api.type.VisualType;
import team.creative.enhancedvisuals.api.type.VisualTypeBlur;
import team.creative.enhancedvisuals.api.type.VisualTypeOverlay;

public class HeartbeatHandler
extends VisualHandler {
    @CreativeConfig
    public boolean useHealthPercentage = false;
    @CreativeConfig
    public int maxHealth = 6;
    @CreativeConfig
    public float maxHealthPercentage = 0.3f;
    @CreativeConfig
    public float heartbeatOverlayIntensity = 0.5f;
    @CreativeConfig
    public int heartbeatOverlayDuration = 20;
    @CreativeConfig
    public float heartbeatBlurIntensity = 50.0f;
    @CreativeConfig
    public int heartbeatBlurDuration = 5;
    @CreativeConfig
    public int minHeartbeatLength = 15;
    @CreativeConfig
    public float heartbeatTimeFactor = 100.0f;
    @CreativeConfig
    public float heartbeatVolume = 1.0f;
    @CreativeConfig
    public VisualType lowhealth = new VisualTypeOverlay("lowhealth");
    @CreativeConfig
    public VisualType blur = new VisualTypeBlur("blur");
    public int effectBufferTicks;

    @Override
    public void tick(@Nullable Player player) {
        if (this.shouldHeartbeatTrigger(player)) {
            if (this.effectBufferTicks <= 0) {
                float intensity = this.getIntensity(player);
                this.resetBufferTicks(player);
                this.addVisualFadeOut(this.lowhealth, (VisualHandler)this, (Curve)new DecimalCurve(0.0, (double)(Math.min(0.7f, intensity) * this.heartbeatOverlayIntensity), (double)this.heartbeatOverlayDuration, 0.0));
                this.addVisualFadeOut(this.blur, (VisualHandler)this, (Curve)new DecimalCurve(0.0, (double)(Math.min(0.7f, intensity) * this.heartbeatBlurIntensity), (double)this.heartbeatBlurDuration, 0.0));
                this.playSound(ResourceLocation.tryBuild((String)"enhancedvisuals", (String)"heartbeatout"), this.heartbeatVolume);
            } else if (this.effectBufferTicks == 5) {
                float intensity = this.getIntensity(player);
                this.playSound(ResourceLocation.tryBuild((String)"enhancedvisuals", (String)"heartbeatin"), this.heartbeatVolume);
                this.addVisualFadeOut(this.blur, (VisualHandler)this, (Curve)new DecimalCurve(0.0, (double)(Math.min(0.7f, intensity) * this.heartbeatBlurIntensity), (double)this.heartbeatBlurDuration, 0.0));
            }
        }
        --this.effectBufferTicks;
    }

    private void resetBufferTicks(@NotNull Player player) {
        float percentHealthLeft = player.getHealth() / player.getMaxHealth();
        this.effectBufferTicks = (int)(percentHealthLeft * this.heartbeatTimeFactor + (float)this.minHeartbeatLength);
    }

    private float getIntensity(@NotNull Player player) {
        if (this.useHealthPercentage) {
            return this.maxHealthPercentage - player.getHealth() / player.getMaxHealth();
        }
        return player.getHealth() / (float)this.maxHealth;
    }

    private boolean shouldHeartbeatTrigger(@Nullable Player player) {
        if (player != null && !Minecraft.getInstance().isPaused() && player.isAlive()) {
            if (this.useHealthPercentage) {
                float percentageHealth = player.getHealth() / player.getMaxHealth();
                return percentageHealth < this.maxHealthPercentage;
            }
            return player.getHealth() < (float)this.maxHealth;
        }
        return false;
    }
}

