/*
 * Decompiled with CFR 0.152.
 */
package team.creative.enhancedvisuals.common.handler;

import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;
import team.creative.creativecore.common.config.api.CreativeConfig;
import team.creative.enhancedvisuals.api.Visual;
import team.creative.enhancedvisuals.api.VisualHandler;
import team.creative.enhancedvisuals.api.type.VisualType;
import team.creative.enhancedvisuals.api.type.VisualTypeBlur;
import team.creative.enhancedvisuals.common.event.EVEvents;

public class UnderwaterHandler
extends VisualHandler {
    @CreativeConfig
    public double intensity = 5.0;
    @CreativeConfig
    public double fadeFactor = 0.5;
    @CreativeConfig
    public VisualType blur = new VisualTypeBlur("blur");
    public Visual blurVisual;

    public UnderwaterHandler() {
        this.enabled = false;
    }

    @Override
    public void tick(@Nullable Player player) {
        if (this.blurVisual == null) {
            this.blurVisual = new Visual(this.blur, this, 0);
            this.blurVisual.setOpacityInternal(0.0f);
            this.add(this.blurVisual);
        }
        if (player != null) {
            double aimed;
            double d = aimed = EVEvents.areEyesInWater(player) ? this.intensity : 0.0;
            if ((double)this.blurVisual.getOpacityInternal() < aimed) {
                this.blurVisual.setOpacityInternal((float)Math.min((double)this.blurVisual.getOpacityInternal() + this.fadeFactor, aimed));
            } else if ((double)this.blurVisual.getOpacityInternal() > aimed) {
                this.blurVisual.setOpacityInternal((float)Math.max((double)this.blurVisual.getOpacityInternal() - this.fadeFactor, aimed));
            }
        } else {
            this.blurVisual.setOpacityInternal(0.0f);
        }
    }
}

