package team.creative.enhancedvisuals.api;

import team.creative.creativecore.common.config.premade.curve.Curve;
import team.creative.creativecore.common.util.type.Color;
import team.creative.enhancedvisuals.api.type.VisualType;

public class Visual {
    
    public final VisualType type;
    public final VisualHandler handler;
    
    private float opacity;
    
    public final boolean endless;
    public final Curve animation;
    
    private boolean displayed = false;
    private int tick = 0;
    
    public Color color;
    
    public int variant;
    
    public Visual(VisualType type, VisualHandler handler, Curve animation, int variant) {
        this.type = type;
        this.handler = handler;
        this.animation = animation;
        this.variant = variant;
        this.endless = false;
        this.color = type.getColor();
    }
    
    public Visual(VisualType type, VisualHandler handler, int variant) {
        this.type = type;
        this.handler = handler;
        this.animation = null;
        this.variant = variant;
        this.endless = true;
        this.color = type.getColor();
    }
    
    public void setOpacityInternal(float opacity) {
        this.opacity = opacity;
    }
    
    public float getOpacityInternal() {
        return opacity;
    }
    
    public float getOpacity() {
        return handler.opacity * opacity * type.opacity;
    }
    
    public boolean displayed() {
        return displayed;
    }
    
    public void addToDisplay() {
        displayed = true;
    }
    
    public void removeFromDisplay() {
        displayed = false;
    }
    
    public VisualCategory getCategory() {
        return type.cat;
    }
    
    public boolean isVisible() {
        return type.isVisible(handler, this);
    }
    
    public boolean tick() {
        if (endless)
            return true;
        opacity = (float) animation.valueAt(tick++);
        return opacity > 0;
    }
    
    public int getWidth(int screenWidth) {
        return screenWidth;
    }
    
    public int getHeight(int screenHeight) {
        return screenHeight;
    }
    
    public boolean isAffectedByWater() {
        return type.isAffectedByWater();
    }
    
}
