/*
 * Decompiled with CFR 0.152.
 */
package team.creative.enhancedvisuals.client;

import java.util.function.Function;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import team.creative.creativecore.CreativeCore;
import team.creative.creativecore.client.CreativeCoreClient;
import team.creative.creativecore.common.util.type.list.Pair;
import team.creative.creativecore.common.util.type.list.PairList;
import team.creative.enhancedvisuals.EnhancedVisuals;
import team.creative.enhancedvisuals.api.type.VisualType;
import team.creative.enhancedvisuals.api.type.VisualTypeBlur;
import team.creative.enhancedvisuals.api.type.VisualTypeFocus;
import team.creative.enhancedvisuals.api.type.VisualTypeSaturation;
import team.creative.enhancedvisuals.api.type.VisualTypeTexture;
import team.creative.enhancedvisuals.client.EVManagerClient;
import team.creative.enhancedvisuals.client.render.EVRenderer;
import team.creative.enhancedvisuals.client.type.VisualTypeBlurClient;
import team.creative.enhancedvisuals.client.type.VisualTypeClient;
import team.creative.enhancedvisuals.client.type.VisualTypeFocusClient;
import team.creative.enhancedvisuals.client.type.VisualTypeSaturationClient;
import team.creative.enhancedvisuals.client.type.VisualTypeTextureClient;

public class EVClient {
    private static final PairList<Class<? extends VisualType>, Function<? extends VisualType, VisualTypeClient>> CLIENT_TYPES = new PairList();

    public static VisualTypeClient get(VisualType type) {
        if (type.clientSideType == null) {
            Class<?> clazz = type.getClass();
            Function factory = (Function)CLIENT_TYPES.getValue(clazz);
            if (factory == null) {
                int i = CLIENT_TYPES.size();
                while (--i >= 0) {
                    Pair pair = (Pair)CLIENT_TYPES.get(i);
                    if (!((Class)pair.key).isInstance(type)) continue;
                    factory = (Function)pair.value;
                    break;
                }
            }
            if (factory == null) {
                throw new IllegalArgumentException("No client handler found for type " + String.valueOf(type));
            }
            type.clientSideType = factory.apply(type);
        }
        return (VisualTypeClient)type.clientSideType;
    }

    public static <T extends VisualType> void register(Class<T> clazz, Function<T, VisualTypeClient> factory) {
        CLIENT_TYPES.add(clazz, factory);
    }

    public static void init() {
        EVClient.register(VisualTypeTexture.class, VisualTypeTextureClient::new);
        EVClient.register(VisualTypeBlur.class, VisualTypeBlurClient::new);
        EVClient.register(VisualTypeFocus.class, VisualTypeFocusClient::new);
        EVClient.register(VisualTypeSaturation.class, VisualTypeSaturationClient::new);
        CreativeCore.loader().registerReloadListener(class_2960.method_43902((String)"enhancedvisuals", (String)"resources"), (class_3302)new class_4080<Void>(){

            protected Void prepare(class_3300 manager, class_3695 profiler) {
                return null;
            }

            protected void apply(Void object, class_3300 manager, class_3695 profiler) {
                EnhancedVisuals.MANAGER.clearEverything();
                EVRenderer.reloadResources = true;
            }
        });
        class_3300 manager = class_310.method_1551().method_1478();
        for (VisualType type : VisualType.types()) {
            EVClient.get(type).loadResources(manager);
        }
        CreativeCore.loader().registerClientRenderGui(EVRenderer::render);
        CreativeCoreClient.registerClientConfig((String)"enhancedvisuals");
        EVManagerClient evmanager = new EVManagerClient();
        EnhancedVisuals.MANAGER = evmanager;
        CreativeCore.loader().registerClientTick(evmanager::clientTick);
    }

    public static boolean shouldRender() {
        class_310 mc = class_310.method_1551();
        return mc.field_1724 != null ? !(mc.field_1724.method_7325() || mc.field_1724.method_68878() && !EnhancedVisuals.CONFIG.doEffectsInCreative) : true;
    }

    public static boolean shouldTick() {
        class_310 mc = class_310.method_1551();
        return mc.field_1724 == null || !mc.method_1493();
    }
}

