/*
 * Decompiled with CFR 0.152.
 */
package team.creative.enhancedvisuals.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collection;
import net.minecraft.class_276;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_418;
import net.minecraft.class_9779;
import org.joml.Matrix3x2fStack;
import team.creative.creativecore.common.util.mc.LanguageUtils;
import team.creative.enhancedvisuals.EnhancedVisuals;
import team.creative.enhancedvisuals.api.Particle;
import team.creative.enhancedvisuals.api.Visual;
import team.creative.enhancedvisuals.api.VisualCategory;
import team.creative.enhancedvisuals.api.type.VisualType;
import team.creative.enhancedvisuals.client.EVClient;
import team.creative.enhancedvisuals.client.type.VisualTypeClient;

public class EVRenderer {
    private static String lastRenderedMessage;
    private static int framebufferWidth;
    private static int framebufferHeight;
    public static boolean reloadResources;

    public static void init() {
    }

    public static void renderShaders(class_9779 tracker) {
        float partialTicks = tracker.method_60637(false);
        RenderSystem.resetTextureMatrix();
        class_310 mc = class_310.method_1551();
        int screenWidth = mc.method_22683().method_4489();
        int screenHeight = mc.method_22683().method_4506();
        class_276 renderTarget = mc.method_1522();
        RenderSystem.getDevice().createCommandEncoder().clearDepthTexture(renderTarget.method_30278(), 1.0);
        EVRenderer.renderVisuals(null, EnhancedVisuals.MANAGER.visuals(VisualCategory.shader), screenWidth, screenHeight, partialTicks);
    }

    public static void render(Object object) {
        class_332 graphics = (class_332)object;
        if (EVClient.shouldRender()) {
            class_310 mc = class_310.method_1551();
            if (reloadResources) {
                for (VisualType visualType : VisualType.types()) {
                    ((VisualTypeClient)visualType.clientSideType).loadResources(mc.method_1478());
                }
                reloadResources = false;
            }
            if (!(mc.field_1755 instanceof class_418)) {
                float partialTicks = class_310.method_1551().method_61966().method_60637(false);
                if (mc.method_1522().field_1482 != framebufferWidth || mc.method_1522().field_1481 != framebufferHeight) {
                    for (VisualType type : VisualType.types()) {
                        ((VisualTypeClient)type.clientSideType).resize(mc.method_1522());
                    }
                    framebufferWidth = mc.method_1522().field_1482;
                    framebufferHeight = mc.method_1522().field_1481;
                }
                int n = mc.method_22683().method_4486();
                int screenHeight = mc.method_22683().method_4502();
                EVRenderer.renderVisuals(graphics, EnhancedVisuals.MANAGER.visuals(VisualCategory.overlay), n, screenHeight, partialTicks);
                EVRenderer.renderVisuals(graphics, EnhancedVisuals.MANAGER.visuals(VisualCategory.particle), n, screenHeight, partialTicks);
            } else if (EnhancedVisuals.MESSAGES.enabled) {
                if (lastRenderedMessage == null) {
                    lastRenderedMessage = LanguageUtils.translate((String)EnhancedVisuals.MESSAGES.pickRandomDeathMessage());
                }
                if (lastRenderedMessage != null) {
                    graphics.method_25303(mc.field_1772, "\"" + lastRenderedMessage + "\"", mc.field_1755.field_22789 / 2 - mc.field_1772.method_1727(lastRenderedMessage) / 2, 114, 0xFFFFFF);
                }
            }
        }
    }

    public static void render(Visual visual, class_332 graphics, int screenWidth, int screenHeight, float partialTicks) {
        VisualTypeClient ct = EVClient.get(visual.type);
        if (visual instanceof Particle) {
            Particle p = (Particle)visual;
            Matrix3x2fStack stack = graphics.method_51448();
            stack.pushMatrix();
            stack.translate((float)(p.x + p.width / 2), (float)(p.y + p.height / 2));
            stack.rotate((float)Math.toRadians(p.rotation));
            ct.render(graphics, visual.handler, visual, screenWidth, screenHeight, partialTicks);
            stack.popMatrix();
        } else {
            ct.render(graphics, visual.handler, visual, screenWidth, screenHeight, partialTicks);
        }
    }

    private static void renderVisuals(class_332 graphics, Collection<Visual> visuals, int screenWidth, int screenHeight, float partialTicks) {
        if (visuals == null || visuals.isEmpty()) {
            return;
        }
        try {
            for (Visual visual : visuals) {
                if (!visual.isVisible()) continue;
                EVRenderer.render(visual, graphics, screenWidth, screenHeight, partialTicks);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        reloadResources = false;
    }
}

