/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.worldManager;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Difficulty;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.generator.WorldInfo;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.StringUtil;
import org.texboobcat.worldManager.WorldManager;
import org.texboobcat.worldManager.api.event.WorldTeleportEvent;
import org.texboobcat.worldManager.gui.WorldSelectorGUI;
import org.texboobcat.worldManager.model.ManagedWorld;
import org.texboobcat.worldManager.service.WorldRegistry;
import org.texboobcat.worldManager.task.WorldImportTask;

public class WorldCommand
implements CommandExecutor,
TabCompleter {
    private final WorldManager plugin;

    public WorldCommand(WorldManager plugin) {
        this.plugin = plugin;
    }

    private void handleInfo(CommandSender sender, String[] args, String label) {
        Set<EntityType> allowed;
        ManagedWorld mw;
        if (args.length < 2) {
            sender.sendMessage(this.msg("messages.usage.info").replace("%label%", label));
            return;
        }
        String worldName = args[1];
        World world = Bukkit.getWorld((String)worldName);
        ManagedWorld managedWorld = mw = world != null ? this.plugin.getRegistry().ensure(world.getName()) : this.plugin.getRegistry().get(worldName);
        if (mw == null) {
            sender.sendMessage(this.msg("messages.world_not_found").replace("%world%", worldName));
            return;
        }
        sender.sendMessage(this.msg("messages.info_header").replace("%world%", world != null ? world.getName() : worldName));
        sender.sendMessage("\u00a77- Alias: \u00a7f" + (mw.getAlias() == null ? "<none>" : mw.getAlias()));
        sender.sendMessage("\u00a77- Gamemode: \u00a7f" + (mw.getGamemode() == null ? "<unchanged>" : mw.getGamemode().name()));
        Location spawn = mw.getSpawn();
        if (spawn != null) {
            sender.sendMessage(String.format("\u00a77- Spawn: \u00a7f%.1f, %.1f, %.1f (yaw=%.1f,pitch=%.1f)", spawn.getX(), spawn.getY(), spawn.getZ(), Float.valueOf(spawn.getYaw()), Float.valueOf(spawn.getPitch())));
        } else {
            sender.sendMessage("\u00a77- Spawn: \u00a7f<world default>");
        }
        sender.sendMessage("\u00a77- Keep spawn loaded: \u00a7f" + (mw.isKeepSpawnLoaded() ? "true" : "false"));
        if (mw.getDifficulty() != null) {
            sender.sendMessage("\u00a77- Difficulty: \u00a7f" + mw.getDifficulty().name());
        }
        if (mw.getPvp() != null) {
            sender.sendMessage("\u00a77- PVP: \u00a7f" + mw.getPvp());
        }
        if (mw.getLockTime() != null) {
            sender.sendMessage("\u00a77- Lock time: \u00a7f" + mw.getLockTime());
        }
        if (mw.getTime() != null) {
            sender.sendMessage("\u00a77- Time: \u00a7f" + mw.getTime());
        }
        if (mw.getLockWeather() != null) {
            sender.sendMessage("\u00a77- Lock weather: \u00a7f" + mw.getLockWeather());
        }
        if (mw.getWeather() != null) {
            sender.sendMessage("\u00a77- Weather: \u00a7f" + mw.getWeather());
        }
        if ((allowed = mw.getAllowedMobs()).isEmpty()) {
            sender.sendMessage(this.msg("messages.info_allowed_mobs_empty"));
        } else {
            String list = allowed.stream().map(Enum::name).sorted().collect(Collectors.joining(", "));
            sender.sendMessage(this.msg("messages.info_allowed_mobs").replace("%list%", list));
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String sub;
        if (args.length == 0) {
            sender.sendMessage(this.msg("messages.usage.root").replace("%label%", label));
            return true;
        }
        switch (sub = args[0].toLowerCase(Locale.ROOT)) {
            case "list": {
                if (!this.checkPerm(sender, "worldmanager.list")) {
                    return true;
                }
                this.handleList(sender);
                return true;
            }
            case "info": {
                if (!this.checkPerm(sender, "worldmanager.info")) {
                    return true;
                }
                this.handleInfo(sender, args, label);
                return true;
            }
            case "tp": {
                if (!this.checkPerm(sender, "worldmanager.tp")) {
                    return true;
                }
                this.handleTp(sender, args, label);
                return true;
            }
            case "back": {
                if (!this.checkPerm(sender, "worldmanager.back")) {
                    return true;
                }
                this.handleBack(sender, args, label);
                return true;
            }
            case "history": {
                if (!this.checkPerm(sender, "worldmanager.history")) {
                    return true;
                }
                this.handleHistory(sender, label);
                return true;
            }
            case "gui": {
                if (!this.checkPerm(sender, "worldmanager.gui")) {
                    return true;
                }
                this.handleGui(sender, label);
                return true;
            }
            case "fav": 
            case "favorite": 
            case "favorites": {
                if (!this.checkPerm(sender, "worldmanager.favorites")) {
                    return true;
                }
                this.handleFavorites(sender, args, label);
                return true;
            }
            case "create": {
                if (!this.checkPerm(sender, "worldmanager.create")) {
                    return true;
                }
                this.handleCreate(sender, args, label);
                return true;
            }
            case "import": {
                if (!this.checkPerm(sender, "worldmanager.import")) {
                    return true;
                }
                this.handleImport(sender, args, label);
                return true;
            }
            case "unload": {
                if (!this.checkPerm(sender, "worldmanager.unload")) {
                    return true;
                }
                this.handleUnload(sender, args, label);
                return true;
            }
            case "delete": {
                if (!this.checkPerm(sender, "worldmanager.delete")) {
                    return true;
                }
                this.handleDelete(sender, args, label);
                return true;
            }
            case "setspawn": {
                if (!this.checkPerm(sender, "worldmanager.setspawn")) {
                    return true;
                }
                this.handleSetSpawn(sender, args, label);
                return true;
            }
            case "config": {
                if (!this.checkPerm(sender, "worldmanager.config")) {
                    return true;
                }
                this.handleConfig(sender, args, label);
                return true;
            }
            case "migrate": {
                if (!this.checkPerm(sender, "worldmanager.migrate")) {
                    return true;
                }
                this.handleMigrate(sender, args, label);
                return true;
            }
        }
        sender.sendMessage(this.msg("messages.usage.root").replace("%label%", label));
        return true;
    }

    private void handleList(CommandSender sender) {
        List worlds = Bukkit.getWorlds();
        if (worlds.isEmpty()) {
            sender.sendMessage("\u00a77No worlds are currently loaded.");
            return;
        }
        sender.sendMessage("\u00a7aLoaded worlds (" + worlds.size() + "):");
        for (World w : worlds) {
            String line = String.format("\u00a77- \u00a7b%s \u00a77(\u00a7f%s\u00a77, \u00a7fplayers: %d\u00a77)", w.getName(), w.getEnvironment().name(), w.getPlayers().size());
            sender.sendMessage(line);
        }
    }

    private void handleTp(CommandSender sender, String[] args, String label) {
        String worldName;
        Player target;
        if (args.length < 2) {
            sender.sendMessage(this.msg("messages.usage.tp").replace("%label%", label));
            return;
        }
        if (args.length >= 3) {
            if (!sender.hasPermission("worldmanager.tp.others")) {
                sender.sendMessage(this.msg("messages.no_permission"));
                return;
            }
            target = Bukkit.getPlayerExact((String)args[1]);
            if (target == null) {
                sender.sendMessage(this.msg("messages.player_not_found").replace("%player%", args[1]));
                return;
            }
            worldName = args[2];
        } else {
            if (!(sender instanceof Player)) {
                sender.sendMessage(this.msg("messages.only_players"));
                return;
            }
            target = (Player)sender;
            worldName = args[1];
        }
        World world = Bukkit.getWorld((String)worldName);
        if (world == null) {
            sender.sendMessage(this.msg("messages.world_not_found").replace("%world%", worldName));
            return;
        }
        if (!this.plugin.canAccessWorld(target, worldName)) {
            target.sendMessage(this.msg("messages.no_world_access").replace("%world%", worldName));
            if (sender != target) {
                sender.sendMessage(this.msg("messages.no_world_access").replace("%world%", worldName));
            }
            return;
        }
        int warmup = this.plugin.getConfig().getInt("options.tp_warmup_seconds", 0);
        int cooldown = this.plugin.getConfig().getInt("options.tp_cooldown_seconds", 0);
        boolean cancelOnMove = this.plugin.getConfig().getBoolean("options.tp_cancel_on_move", true);
        int maxHist = this.plugin.getConfig().getInt("options.tp_history_max", 10);
        if (cooldown > 0) {
            long remainingMs;
            Long last = this.plugin.getLastTeleportAt().get(target.getUniqueId());
            long now = System.currentTimeMillis();
            if (last != null && (remainingMs = last + (long)cooldown * 1000L - now) > 0L) {
                long remaining = (remainingMs + 999L) / 1000L;
                sender.sendMessage(this.msg("messages.tp_cooldown").replace("%seconds%", Long.toString(remaining)));
                return;
            }
        }
        if (warmup > 0) {
            target.sendMessage(this.msg("messages.tp_warmup").replace("%seconds%", Integer.toString(warmup)));
            Location start = target.getLocation().clone();
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                Location now;
                if (!target.isOnline()) {
                    return;
                }
                if (cancelOnMove && ((now = target.getLocation()).getWorld() != start.getWorld() || now.distanceSquared(start) > 0.01)) {
                    target.sendMessage(this.msg("messages.tp_warmup_cancelled"));
                    return;
                }
                Location to = world.getSpawnLocation();
                WorldTeleportEvent evt = new WorldTeleportEvent(target, target.getLocation(), to, "command");
                Bukkit.getPluginManager().callEvent((Event)evt);
                if (evt.isCancelled()) {
                    target.sendMessage(this.msg("messages.teleport_cancelled"));
                    return;
                }
                this.plugin.getLastLocation().put(target.getUniqueId(), target.getLocation().clone());
                this.plugin.pushHistory(target.getUniqueId(), target.getLocation(), maxHist);
                target.teleportAsync(to);
                this.plugin.getLastTeleportAt().put(target.getUniqueId(), System.currentTimeMillis());
                sender.sendMessage(this.msg("messages.teleported").replace("%world%", world.getName()));
            }, (long)warmup * 20L);
        } else {
            Location to = world.getSpawnLocation();
            WorldTeleportEvent evt = new WorldTeleportEvent(target, target.getLocation(), to, "command");
            Bukkit.getPluginManager().callEvent((Event)evt);
            if (evt.isCancelled()) {
                target.sendMessage(this.msg("messages.teleport_cancelled"));
                return;
            }
            this.plugin.getLastLocation().put(target.getUniqueId(), target.getLocation().clone());
            this.plugin.pushHistory(target.getUniqueId(), target.getLocation(), maxHist);
            target.teleportAsync(to);
            this.plugin.getLastTeleportAt().put(target.getUniqueId(), System.currentTimeMillis());
            sender.sendMessage(this.msg("messages.teleported").replace("%world%", world.getName()));
        }
    }

    private void handleBack(CommandSender sender, String[] args, String label) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.msg("messages.only_players"));
            return;
        }
        Player p = (Player)sender;
        int maxHist = this.plugin.getConfig().getInt("options.tp_history_max", 10);
        Deque<Location> dq = this.plugin.getHistory(p.getUniqueId());
        Location targetLoc = null;
        if (args.length >= 2) {
            try {
                int n = Integer.parseInt(args[1]);
                if (n <= 0) {
                    throw new NumberFormatException();
                }
                int i = 0;
                for (Location l : dq) {
                    if (i++ != n - 1) continue;
                    targetLoc = l;
                    break;
                }
            }
            catch (NumberFormatException n) {
                // empty catch block
            }
        }
        if (targetLoc == null) {
            if (!dq.isEmpty()) {
                targetLoc = dq.peekFirst();
            }
            if (targetLoc == null) {
                targetLoc = this.plugin.getLastLocation().get(p.getUniqueId());
            }
        }
        if (targetLoc == null || targetLoc.getWorld() == null) {
            p.sendMessage(this.msg("messages.back_no_location"));
            return;
        }
        Location current = p.getLocation().clone();
        Location finalTarget = targetLoc.clone();
        WorldTeleportEvent evt = new WorldTeleportEvent(p, p.getLocation(), finalTarget, "back");
        Bukkit.getPluginManager().callEvent((Event)evt);
        if (evt.isCancelled()) {
            p.sendMessage(this.msg("messages.teleport_cancelled"));
            return;
        }
        p.teleportAsync(finalTarget).thenRun(() -> {
            this.plugin.getLastLocation().put(p.getUniqueId(), current);
            this.plugin.pushHistory(p.getUniqueId(), current, maxHist);
            p.sendMessage(this.msg("messages.back_done"));
        });
    }

    private void handleHistory(CommandSender sender, String label) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.msg("messages.only_players"));
            return;
        }
        Player p = (Player)sender;
        Deque<Location> dq = this.plugin.getHistory(p.getUniqueId());
        if (dq.isEmpty()) {
            p.sendMessage(this.msg("messages.history_empty"));
            return;
        }
        p.sendMessage(this.msg("messages.history_header"));
        int i = 1;
        for (Location l : dq) {
            if (l == null || l.getWorld() == null) continue;
            String line = this.msg("messages.history_entry").replace("%index%", Integer.toString(i)).replace("%world%", l.getWorld().getName()).replace("%x%", String.format(Locale.ROOT, "%.1f", l.getX())).replace("%y%", String.format(Locale.ROOT, "%.1f", l.getY())).replace("%z%", String.format(Locale.ROOT, "%.1f", l.getZ()));
            p.sendMessage(line);
            if (++i <= this.plugin.getConfig().getInt("options.tp_history_max", 10)) continue;
            break;
        }
    }

    private void handleGui(CommandSender sender, String label) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.msg("messages.only_players"));
            return;
        }
        Player p = (Player)sender;
        WorldSelectorGUI.open(p, this.plugin);
    }

    private void handleFavorites(CommandSender sender, String[] args, String label) {
        String action;
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.msg("messages.only_players"));
            return;
        }
        Player p = (Player)sender;
        if (args.length < 2) {
            sender.sendMessage(this.msg("messages.usage.fav").replace("%label%", label));
            return;
        }
        switch (action = args[1].toLowerCase(Locale.ROOT)) {
            case "add": {
                boolean exists;
                if (args.length < 3) {
                    sender.sendMessage(this.msg("messages.usage.fav").replace("%label%", label));
                    return;
                }
                String worldName = args[2];
                boolean bl = exists = Bukkit.getWorld((String)worldName) != null || this.plugin.getRegistry().get(worldName) != null;
                if (!exists) {
                    sender.sendMessage(this.msg("messages.world_not_found").replace("%world%", worldName));
                    return;
                }
                this.plugin.getFavorites(p.getUniqueId()).add(worldName);
                sender.sendMessage(this.msg("messages.fav_added").replace("%world%", worldName));
                return;
            }
            case "remove": {
                if (args.length < 3) {
                    sender.sendMessage(this.msg("messages.usage.fav").replace("%label%", label));
                    return;
                }
                String worldName = args[2];
                this.plugin.getFavorites(p.getUniqueId()).remove(worldName);
                sender.sendMessage(this.msg("messages.fav_removed").replace("%world%", worldName));
                return;
            }
            case "list": {
                Set<String> favs = this.plugin.getFavorites(p.getUniqueId());
                if (favs.isEmpty()) {
                    sender.sendMessage(this.msg("messages.fav_empty"));
                    return;
                }
                String list = favs.stream().sorted(String.CASE_INSENSITIVE_ORDER).collect(Collectors.joining(", "));
                sender.sendMessage(this.msg("messages.fav_list").replace("%list%", list));
                return;
            }
        }
        sender.sendMessage(this.msg("messages.usage.fav").replace("%label%", label));
    }

    private void handleCreate(CommandSender sender, String[] args, String label) {
        World world;
        if (args.length < 2) {
            sender.sendMessage(this.msg("messages.usage.create").replace("%label%", label));
            return;
        }
        String name = args[1];
        World.Environment env = World.Environment.NORMAL;
        long seed = 0L;
        boolean hasSeed = false;
        Boolean generateStructures = null;
        String generatorName = null;
        String worldTypeName = null;
        if (args.length >= 3) {
            int idx = 2;
            if (!args[idx].contains(":")) {
                try {
                    env = World.Environment.valueOf((String)args[idx].toUpperCase(Locale.ROOT));
                    ++idx;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            block22: for (int i = idx; i < args.length; ++i) {
                String tok = args[i];
                int p = tok.indexOf(58);
                if (p <= 0) continue;
                String key = tok.substring(0, p).toLowerCase(Locale.ROOT);
                String val = tok.substring(p + 1);
                switch (key) {
                    case "seed": {
                        try {
                            seed = Long.parseLong(val);
                            hasSeed = true;
                            continue block22;
                        }
                        catch (NumberFormatException e) {
                            sender.sendMessage("\u00a7cInvalid seed value. Must be a number.");
                            return;
                        }
                    }
                    case "structures": {
                        generateStructures = Boolean.parseBoolean(val);
                        continue block22;
                    }
                    case "generator": {
                        generatorName = val;
                        continue block22;
                    }
                    case "type": {
                        worldTypeName = val.toUpperCase(Locale.ROOT);
                        continue block22;
                    }
                    default: {
                        sender.sendMessage("\u00a7cUnknown option: " + key + ". Use seed:<num>, structures:<true|false>, generator:<name>, type:<FLAT|AMPLIFIED|...>");
                        return;
                    }
                }
            }
        }
        if (Bukkit.getWorld((String)name) != null) {
            sender.sendMessage(this.msg("messages.world_already_loaded"));
            return;
        }
        WorldCreator creator = new WorldCreator(name).environment(env);
        if (hasSeed) {
            creator = creator.seed(seed);
        }
        if (generateStructures != null) {
            try {
                creator = creator.generateStructures(generateStructures.booleanValue());
            }
            catch (Throwable i) {
                // empty catch block
            }
        }
        if (generatorName != null && !generatorName.isBlank()) {
            creator = creator.generator(generatorName);
        }
        if (worldTypeName != null) {
            try {
                Class<?> wtClass = Class.forName("org.bukkit.WorldType");
                Object wt = Enum.valueOf(wtClass, worldTypeName);
                try {
                    Method m = WorldCreator.class.getMethod("type", wtClass);
                    m.invoke((Object)creator, wt);
                }
                catch (NoSuchMethodException noSuchMethodException) {}
            }
            catch (Throwable wtClass) {
                // empty catch block
            }
        }
        if ((world = Bukkit.createWorld((WorldCreator)creator)) == null) {
            sender.sendMessage(this.msg("messages.world_create_failed"));
            return;
        }
        String details = env.name() + (String)(worldTypeName != null ? ", type=" + worldTypeName : "") + (String)(hasSeed ? ", seed=" + seed : "") + (String)(generatorName != null ? ", gen=" + generatorName : "");
        sender.sendMessage(this.msg("messages.world_created").replace("%world%", world.getName()).replace("%env%", details));
        this.plugin.getRegistry().ensure(world.getName()).applyToWorldIfLoaded();
        this.plugin.getRegistry().save();
    }

    private void handleImport(CommandSender sender, String[] args, String label) {
        int[] tid;
        if (args.length < 2) {
            sender.sendMessage(this.msg("messages.usage.import").replace("%label%", label));
            return;
        }
        String folderName = args[1];
        World.Environment env = World.Environment.NORMAL;
        if (args.length >= 3) {
            try {
                env = World.Environment.valueOf((String)args[2].toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (Bukkit.getWorld((String)folderName) != null) {
            sender.sendMessage(this.msg("messages.world_already_loaded"));
            return;
        }
        if (this.plugin.getRunningImports().containsKey(folderName.toLowerCase(Locale.ROOT))) {
            sender.sendMessage(this.msg("messages.import_already_running").replace("%world%", folderName));
            return;
        }
        sender.sendMessage(this.msg("messages.import_start").replace("%world%", folderName));
        World.Environment finalEnv = env;
        WorldImportTask task = new WorldImportTask(this.plugin, folderName, finalEnv);
        this.plugin.getRunningImports().put(folderName.toLowerCase(Locale.ROOT), task);
        task.start();
        tid = new int[]{Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
            long s;
            if (task.isFinished()) {
                Bukkit.getScheduler().cancelTask(tid[0]);
                this.plugin.getRunningImports().remove(folderName.toLowerCase(Locale.ROOT));
                if (task.getPhase() == WorldImportTask.Phase.DONE && task.getResult().join() != null) {
                    World world = task.getResult().join();
                    sender.sendMessage(this.msg("messages.import_applying").replace("%world%", world.getName()));
                    this.plugin.getRegistry().ensure(world.getName()).applyToWorldIfLoaded();
                    this.plugin.getRegistry().save();
                    sender.sendMessage(this.msg("messages.import_done").replace("%world%", world.getName()).replace("%env%", finalEnv.name()));
                } else {
                    String reason = task.getDetail() == null ? "" : " " + task.getDetail();
                    sender.sendMessage(this.msg("messages.import_failed").replace("%world%", folderName) + reason);
                }
                return;
            }
            double pct = task.getPercent();
            long eta = task.getEtaSeconds();
            long m = eta > 0L ? eta / 60L : -1L;
            long l = s = eta > 0L ? eta % 60L : -1L;
            String etaStr = eta < 0L ? "?" : (m > 0L ? m + "m " + s + "s" : s + "s");
            String phase = task.getPhase().name();
            String msg = this.msg("messages.import_progress").replace("%world%", folderName).replace("%phase%", phase).replace("%percent%", String.format(Locale.ROOT, "%.0f", pct)).replace("%eta%", etaStr);
            sender.sendMessage(msg);
        }, 0L, 40L).getTaskId()};
    }

    private void handleUnload(CommandSender sender, String[] args, String label) {
        World world;
        String v;
        if (args.length < 2) {
            sender.sendMessage(this.msg("messages.usage.unload").replace("%label%", label));
            return;
        }
        String worldName = args[1];
        boolean save = true;
        if (args.length >= 3 && (v = args[2].toLowerCase(Locale.ROOT)).startsWith("save:")) {
            save = Boolean.parseBoolean(v.substring("save:".length()));
        }
        if ((world = Bukkit.getWorld((String)worldName)) == null) {
            sender.sendMessage(this.msg("messages.world_not_found").replace("%world%", worldName));
            return;
        }
        boolean preventPlayers = this.plugin.getConfig().getBoolean("options.prevent_unload_with_players", true);
        if (preventPlayers && !world.getPlayers().isEmpty()) {
            sender.sendMessage(this.msg("messages.unload_failed_players"));
            return;
        }
        boolean ok = Bukkit.unloadWorld((World)world, (boolean)save);
        if (ok) {
            sender.sendMessage(this.msg("messages.unloaded").replace("%world%", worldName));
        } else {
            sender.sendMessage(this.msg("messages.unload_failed"));
        }
    }

    private void handleDelete(CommandSender sender, String[] args, String label) {
        if (args.length < 2) {
            sender.sendMessage(this.msg("messages.usage.delete").replace("%label%", label));
            return;
        }
        String worldName = args[1];
        if (Bukkit.getWorld((String)worldName) != null) {
            sender.sendMessage(this.msg("messages.delete_loaded").replace("%label%", label).replace("%world%", worldName));
            return;
        }
        File container = Bukkit.getWorldContainer();
        File folder = new File(container, worldName);
        if (!folder.exists()) {
            sender.sendMessage(this.msg("messages.delete_missing").replace("%world%", worldName));
            return;
        }
        try {
            this.deleteDirectory(folder.toPath());
            sender.sendMessage(this.msg("messages.delete_done").replace("%world%", worldName));
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Failed deleting world folder '" + folder.getAbsolutePath() + "': " + e.getMessage());
            sender.sendMessage(this.msg("messages.delete_failed"));
        }
    }

    private void handleSetSpawn(CommandSender sender, String[] args, String label) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.msg("messages.only_players"));
            return;
        }
        if (args.length < 2) {
            sender.sendMessage(this.msg("messages.usage.setspawn").replace("%label%", label));
            return;
        }
        String worldName = args[1];
        World world = Bukkit.getWorld((String)worldName);
        if (world == null) {
            sender.sendMessage(this.msg("messages.world_not_found").replace("%world%", worldName));
            return;
        }
        Player p = (Player)sender;
        Location loc = p.getLocation();
        if (loc.getWorld() != world) {
            sender.sendMessage(this.msg("messages.setspawn_wrong_world").replace("%world%", worldName));
            return;
        }
        ManagedWorld mw = this.plugin.getRegistry().ensure(world.getName());
        mw.setSpawn(loc);
        mw.applyToWorldIfLoaded();
        this.plugin.getRegistry().save();
        sender.sendMessage(this.msg("messages.setspawn_done").replace("%world%", world.getName()));
    }

    private void handleConfig(CommandSender sender, String[] args, String label) {
        if (args.length < 4) {
            sender.sendMessage(this.msg("messages.usage.config").replace("%label%", label));
            return;
        }
        String worldName = args[1];
        String key = args[2].toLowerCase(Locale.ROOT);
        ManagedWorld mw = this.plugin.getRegistry().ensure(worldName);
        if ("allowed-mobs".equals(key)) {
            String action;
            if (args.length < 4) {
                sender.sendMessage(this.msg("messages.usage.config_allowed").replace("%label%", label));
                return;
            }
            switch (action = args[3].toLowerCase(Locale.ROOT)) {
                case "add": 
                case "remove": {
                    if (args.length < 5) {
                        sender.sendMessage(this.msg("messages.usage.config_allowed").replace("%label%", label));
                        return;
                    }
                    String mob = args[4].toUpperCase(Locale.ROOT);
                    try {
                        EntityType type = EntityType.valueOf((String)mob);
                        if ("add".equals(action)) {
                            mw.getAllowedMobs().add(type);
                            sender.sendMessage(this.msg("messages.config_allowed_added").replace("%mob%", type.name()));
                        } else {
                            mw.getAllowedMobs().remove(type);
                            sender.sendMessage(this.msg("messages.config_allowed_removed").replace("%mob%", type.name()));
                        }
                        this.plugin.getRegistry().save();
                    }
                    catch (IllegalArgumentException e) {
                        sender.sendMessage(this.msg("messages.config_invalid_value"));
                    }
                    return;
                }
                case "clear": {
                    mw.getAllowedMobs().clear();
                    this.plugin.getRegistry().save();
                    sender.sendMessage(this.msg("messages.config_allowed_cleared"));
                    return;
                }
                case "list": {
                    if (mw.getAllowedMobs().isEmpty()) {
                        sender.sendMessage(this.msg("messages.info_allowed_mobs_empty"));
                    } else {
                        String list = mw.getAllowedMobs().stream().map(Enum::name).sorted().collect(Collectors.joining(", "));
                        sender.sendMessage(this.msg("messages.info_allowed_mobs").replace("%list%", list));
                    }
                    return;
                }
            }
            sender.sendMessage(this.msg("messages.usage.config_allowed").replace("%label%", label));
            return;
        }
        String value = args[3];
        switch (key) {
            case "alias": {
                mw.setAlias(value);
                break;
            }
            case "gamemode": {
                try {
                    mw.setGamemode(GameMode.valueOf((String)value.toUpperCase(Locale.ROOT)));
                    break;
                }
                catch (IllegalArgumentException e) {
                    sender.sendMessage(this.msg("messages.config_invalid_value"));
                    return;
                }
            }
            case "difficulty": {
                try {
                    mw.setDifficulty(Difficulty.valueOf((String)value.toUpperCase(Locale.ROOT)));
                    break;
                }
                catch (IllegalArgumentException e) {
                    sender.sendMessage(this.msg("messages.config_invalid_value"));
                    return;
                }
            }
            case "keep-spawn-loaded": {
                mw.setKeepSpawnLoaded(Boolean.parseBoolean(value));
                break;
            }
            case "pvp": {
                mw.setPvp(Boolean.parseBoolean(value));
                break;
            }
            case "lock-time": {
                mw.setLockTime(Boolean.parseBoolean(value));
                break;
            }
            case "time": {
                try {
                    mw.setTime(Long.parseLong(value));
                    break;
                }
                catch (NumberFormatException ex) {
                    sender.sendMessage(this.msg("messages.config_invalid_value"));
                    return;
                }
            }
            case "lock-weather": {
                mw.setLockWeather(Boolean.parseBoolean(value));
                break;
            }
            case "weather": {
                String w = value.toUpperCase(Locale.ROOT);
                if (!(w.equals("CLEAR") || w.equals("RAIN") || w.equals("THUNDER"))) {
                    sender.sendMessage(this.msg("messages.config_invalid_value"));
                    return;
                }
                mw.setWeather(w);
                break;
            }
            case "mob-griefing": {
                mw.setMobGriefing(Boolean.parseBoolean(value));
                break;
            }
            case "natural-regen": {
                mw.setNaturalRegen(Boolean.parseBoolean(value));
                break;
            }
            case "fire-tick": {
                mw.setFireTick(Boolean.parseBoolean(value));
                break;
            }
            case "keep-inventory": {
                mw.setKeepInventory(Boolean.parseBoolean(value));
                break;
            }
            case "spawn-protection": {
                try {
                    mw.setSpawnRadius(Integer.parseInt(value));
                    break;
                }
                catch (NumberFormatException ex) {
                    sender.sendMessage(this.msg("messages.config_invalid_value"));
                    return;
                }
            }
            case "random-tick": {
                try {
                    mw.setRandomTickSpeed(Integer.parseInt(value));
                    break;
                }
                catch (NumberFormatException ex) {
                    sender.sendMessage(this.msg("messages.config_invalid_value"));
                    return;
                }
            }
            case "max-entity-cramming": {
                try {
                    mw.setMaxEntityCramming(Integer.parseInt(value));
                    break;
                }
                catch (NumberFormatException ex) {
                    sender.sendMessage(this.msg("messages.config_invalid_value"));
                    return;
                }
            }
            default: {
                sender.sendMessage(this.msg("messages.config_invalid_key"));
                return;
            }
        }
        mw.applyToWorldIfLoaded();
        this.plugin.getRegistry().save();
        sender.sendMessage(this.msg("messages.config_updated").replace("%world%", worldName).replace("%key%", key));
    }

    private void handleMigrate(CommandSender sender, String[] args, String label) {
        boolean force = args.length >= 2 && "force".equalsIgnoreCase(args[1]);
        sender.sendMessage(this.msg("messages.migrate_start").replace("%version%", Integer.toString(this.plugin.getRegistry().getLoadedVersion())));
        boolean changed = this.plugin.getRegistry().migrateToLatest(force);
        if (changed) {
            sender.sendMessage(this.msg("messages.migrate_done"));
        } else {
            sender.sendMessage(this.msg("messages.migrate_skipped").replace("%label%", label));
        }
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1) {
            ArrayList<String> subs = new ArrayList<String>();
            if (sender.hasPermission("worldmanager.list")) {
                subs.add("list");
            }
            if (sender.hasPermission("worldmanager.info")) {
                subs.add("info");
            }
            if (sender.hasPermission("worldmanager.tp")) {
                subs.add("tp");
            }
            if (sender.hasPermission("worldmanager.back")) {
                subs.add("back");
            }
            if (sender.hasPermission("worldmanager.history")) {
                subs.add("history");
            }
            if (sender.hasPermission("worldmanager.gui")) {
                subs.add("gui");
            }
            if (sender.hasPermission("worldmanager.favorites")) {
                subs.add("fav");
            }
            if (sender.hasPermission("worldmanager.create")) {
                subs.add("create");
            }
            if (sender.hasPermission("worldmanager.import")) {
                subs.add("import");
            }
            if (sender.hasPermission("worldmanager.unload")) {
                subs.add("unload");
            }
            if (sender.hasPermission("worldmanager.delete")) {
                subs.add("delete");
            }
            if (sender.hasPermission("worldmanager.setspawn")) {
                subs.add("setspawn");
            }
            if (sender.hasPermission("worldmanager.config")) {
                subs.add("config");
            }
            if (sender.hasPermission("worldmanager.migrate")) {
                subs.add("migrate");
            }
            return (List)StringUtil.copyPartialMatches((String)args[0], subs, new ArrayList());
        }
        if (args.length == 2) {
            if ("tp".equalsIgnoreCase(args[0])) {
                if (sender.hasPermission("worldmanager.tp.others")) {
                    List players = Bukkit.getOnlinePlayers().stream().map(Player::getName).collect(Collectors.toList());
                    return (List)StringUtil.copyPartialMatches((String)args[1], players, new ArrayList());
                }
                List names = Bukkit.getWorlds().stream().map(WorldInfo::getName).collect(Collectors.toList());
                return (List)StringUtil.copyPartialMatches((String)args[1], names, new ArrayList());
            }
            if ("back".equalsIgnoreCase(args[0])) {
                if (sender instanceof Player) {
                    Deque<Location> dq = this.plugin.getHistory(((Player)sender).getUniqueId());
                    int size = dq.size();
                    ArrayList<String> nums = new ArrayList<String>();
                    for (int i = 1; i <= size; ++i) {
                        nums.add(Integer.toString(i));
                    }
                    return (List)StringUtil.copyPartialMatches((String)args[1], nums, new ArrayList());
                }
                return Collections.emptyList();
            }
            if ("fav".equalsIgnoreCase(args[0]) || "favorite".equalsIgnoreCase(args[0]) || "favorites".equalsIgnoreCase(args[0])) {
                List<String> actions = List.of("add", "remove", "list");
                return (List)StringUtil.copyPartialMatches((String)args[1], actions, new ArrayList());
            }
            if ("migrate".equalsIgnoreCase(args[0])) {
                return (List)StringUtil.copyPartialMatches((String)args[1], List.of("force"), new ArrayList());
            }
            if ("unload".equalsIgnoreCase(args[0])) {
                List names = Bukkit.getWorlds().stream().map(WorldInfo::getName).collect(Collectors.toList());
                return (List)StringUtil.copyPartialMatches((String)args[1], names, new ArrayList());
            }
            if ("create".equalsIgnoreCase(args[0])) {
                return Collections.emptyList();
            }
            if ("delete".equalsIgnoreCase(args[0])) {
                File container = Bukkit.getWorldContainer();
                String[] dirs = container.list((current, name) -> new File(current, name).isDirectory());
                ArrayList names = new ArrayList();
                if (dirs != null) {
                    Collections.addAll(names, dirs);
                }
                return (List)StringUtil.copyPartialMatches((String)args[1], names, new ArrayList());
            }
            if ("setspawn".equalsIgnoreCase(args[0])) {
                List names = Bukkit.getWorlds().stream().map(WorldInfo::getName).collect(Collectors.toList());
                return (List)StringUtil.copyPartialMatches((String)args[1], names, new ArrayList());
            }
            if ("config".equalsIgnoreCase(args[0])) {
                List names = Bukkit.getWorlds().stream().map(WorldInfo::getName).collect(Collectors.toList());
                return (List)StringUtil.copyPartialMatches((String)args[1], names, new ArrayList());
            }
            if ("info".equalsIgnoreCase(args[0])) {
                List<Object> names = new ArrayList();
                names.addAll(Bukkit.getWorlds().stream().map(WorldInfo::getName).collect(Collectors.toList()));
                WorldRegistry reg = this.plugin.getRegistry();
                if (reg != null) {
                    try {
                        Collection<ManagedWorld> all = reg.all();
                        names.addAll(all.stream().map(ManagedWorld::getName).collect(Collectors.toList()));
                    }
                    catch (Throwable all) {
                        // empty catch block
                    }
                }
                names = names.stream().distinct().collect(Collectors.toList());
                return (List)StringUtil.copyPartialMatches((String)args[1], names, new ArrayList());
            }
            if ("import".equalsIgnoreCase(args[0])) {
                File container = Bukkit.getWorldContainer();
                String[] dirs = container.list((current, name) -> new File(current, name).isDirectory());
                ArrayList names = new ArrayList();
                if (dirs != null) {
                    Collections.addAll(names, dirs);
                }
                return (List)StringUtil.copyPartialMatches((String)args[1], names, new ArrayList());
            }
            if ("create".equalsIgnoreCase(args[0])) {
                return Collections.emptyList();
            }
        }
        if (args.length == 3) {
            if ("import".equalsIgnoreCase(args[0])) {
                List<String> envs = List.of("NORMAL", "NETHER", "THE_END");
                return (List)StringUtil.copyPartialMatches((String)args[2], envs, new ArrayList());
            }
            if ("tp".equalsIgnoreCase(args[0]) && sender.hasPermission("worldmanager.tp.others")) {
                List names = Bukkit.getWorlds().stream().map(WorldInfo::getName).collect(Collectors.toList());
                return (List)StringUtil.copyPartialMatches((String)args[2], names, new ArrayList());
            }
            if ("create".equalsIgnoreCase(args[0])) {
                ArrayList<String> opts = new ArrayList<String>();
                opts.addAll(Arrays.stream(World.Environment.values()).map(Enum::name).collect(Collectors.toList()));
                opts.add("seed:");
                opts.add("structures:");
                opts.add("generator:");
                opts.add("type:");
                return (List)StringUtil.copyPartialMatches((String)args[2], opts, new ArrayList());
            }
            if ("config".equalsIgnoreCase(args[0])) {
                List<String> keys = List.of("alias", "gamemode", "difficulty", "keep-spawn-loaded", "pvp", "lock-time", "time", "lock-weather", "weather", "allowed-mobs", "mob-griefing", "natural-regen", "fire-tick", "keep-inventory", "spawn-protection", "random-tick", "max-entity-cramming");
                return (List)StringUtil.copyPartialMatches((String)args[2], keys, new ArrayList());
            }
        }
        if (args.length >= 4 && "create".equalsIgnoreCase(args[0])) {
            HashSet<String> presentKeys = new HashSet<String>();
            for (int i = 2; i < args.length; ++i) {
                String tok = args[i];
                int p = tok.indexOf(58);
                if (p <= 0) continue;
                presentKeys.add(tok.substring(0, p).toLowerCase(Locale.ROOT));
            }
            ArrayList<String> opts = new ArrayList<String>();
            if (!presentKeys.contains("seed")) {
                opts.add("seed:");
            }
            if (!presentKeys.contains("structures")) {
                opts.add("structures:");
            }
            if (!presentKeys.contains("generator")) {
                opts.add("generator:");
            }
            String last = args[args.length - 1];
            return (List)StringUtil.copyPartialMatches((String)last, opts, new ArrayList());
        }
        if (args.length == 3 && ("fav".equalsIgnoreCase(args[0]) || "favorite".equalsIgnoreCase(args[0]) || "favorites".equalsIgnoreCase(args[0])) && ("add".equalsIgnoreCase(args[1]) || "remove".equalsIgnoreCase(args[1]))) {
            List<Object> names = new ArrayList();
            names.addAll(Bukkit.getWorlds().stream().map(WorldInfo::getName).collect(Collectors.toList()));
            WorldRegistry reg = this.plugin.getRegistry();
            if (reg != null) {
                try {
                    Collection<ManagedWorld> all = reg.all();
                    names.addAll(all.stream().map(ManagedWorld::getName).collect(Collectors.toList()));
                }
                catch (Throwable all) {
                    // empty catch block
                }
            }
            names = names.stream().distinct().collect(Collectors.toList());
            return (List)StringUtil.copyPartialMatches((String)args[2], names, new ArrayList());
        }
        if (args.length >= 4 && "create".equalsIgnoreCase(args[0])) {
            HashSet<String> presentKeys = new HashSet<String>();
            for (int i = 2; i < args.length; ++i) {
                String tok = args[i];
                int p = tok.indexOf(58);
                if (p <= 0) continue;
                presentKeys.add(tok.substring(0, p).toLowerCase(Locale.ROOT));
            }
            ArrayList<String> opts = new ArrayList<String>();
            if (!presentKeys.contains("seed")) {
                opts.add("seed:");
            }
            if (!presentKeys.contains("structures")) {
                opts.add("structures:");
            }
            if (!presentKeys.contains("generator")) {
                opts.add("generator:");
            }
            String last = args[args.length - 1];
            return (List)StringUtil.copyPartialMatches((String)last, opts, new ArrayList());
        }
        if (args.length == 4 && "config".equalsIgnoreCase(args[0])) {
            String key;
            switch (key = args[2].toLowerCase(Locale.ROOT)) {
                case "gamemode": {
                    return (List)StringUtil.copyPartialMatches((String)args[3], (Iterable)Arrays.stream(GameMode.values()).map(Enum::name).collect(Collectors.toList()), new ArrayList());
                }
                case "difficulty": {
                    return (List)StringUtil.copyPartialMatches((String)args[3], (Iterable)Arrays.stream(Difficulty.values()).map(Enum::name).collect(Collectors.toList()), new ArrayList());
                }
                case "keep-spawn-loaded": 
                case "pvp": 
                case "lock-time": 
                case "lock-weather": {
                    return (List)StringUtil.copyPartialMatches((String)args[3], List.of("true", "false"), new ArrayList());
                }
                case "weather": {
                    return (List)StringUtil.copyPartialMatches((String)args[3], List.of("CLEAR", "RAIN", "THUNDER"), new ArrayList());
                }
            }
        }
        if (args.length == 5 && "config".equalsIgnoreCase(args[0]) && "allowed-mobs".equalsIgnoreCase(args[2])) {
            List types = Arrays.stream(EntityType.values()).filter(t -> t != null).filter(t -> {
                try {
                    return t.isSpawnable() && t.isAlive();
                }
                catch (Throwable ignore) {
                    return true;
                }
            }).map(Enum::name).collect(Collectors.toList());
            return (List)StringUtil.copyPartialMatches((String)args[4], types, new ArrayList());
        }
        return Collections.emptyList();
    }

    private boolean checkPerm(CommandSender sender, String perm) {
        if (sender.hasPermission(perm)) {
            return true;
        }
        sender.sendMessage(this.msg("messages.no_permission"));
        return false;
    }

    private String msg(String path) {
        FileConfiguration cfg = this.plugin.getConfig();
        String def = "";
        String s = cfg.getString(path, def);
        return Objects.requireNonNullElse(s, def);
    }

    private void deleteDirectory(Path path) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        Files.walk(path, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).forEach(p -> {
            try {
                Files.deleteIfExists(p);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }
}

