/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.worldManager;

import java.io.File;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.ServicesManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.texboobcat.worldManager.HelpCommand;
import org.texboobcat.worldManager.WorldCommand;
import org.texboobcat.worldManager.api.WorldAPI;
import org.texboobcat.worldManager.integration.WorldManagerExpansion;
import org.texboobcat.worldManager.listener.ChatListener;
import org.texboobcat.worldManager.listener.GuiListener;
import org.texboobcat.worldManager.listener.WorldRulesListener;
import org.texboobcat.worldManager.model.ManagedWorld;
import org.texboobcat.worldManager.service.WorldRegistry;
import org.texboobcat.worldManager.task.WorldImportTask;

public final class WorldManager
extends JavaPlugin
implements WorldAPI {
    private WorldRegistry registry;
    private final Map<UUID, Long> lastTeleportAt = new ConcurrentHashMap<UUID, Long>();
    private final Map<UUID, Location> lastLocation = new ConcurrentHashMap<UUID, Location>();
    private final Map<UUID, Set<String>> favorites = new ConcurrentHashMap<UUID, Set<String>>();
    private final Map<UUID, Deque<Location>> history = new ConcurrentHashMap<UUID, Deque<Location>>();
    private final Map<UUID, Integer> guiPage = new ConcurrentHashMap<UUID, Integer>();
    private final Map<UUID, Boolean> guiFavOnly = new ConcurrentHashMap<UUID, Boolean>();
    private final Map<UUID, GuiMode> guiMode = new ConcurrentHashMap<UUID, GuiMode>();
    private final Map<UUID, PendingCreate> pendingCreate = new ConcurrentHashMap<UUID, PendingCreate>();
    private final Map<String, WorldImportTask> runningImports = new ConcurrentHashMap<String, WorldImportTask>();

    public void onEnable() {
        this.saveDefaultConfig();
        this.registry = new WorldRegistry(this);
        this.registry.load();
        if (this.getConfig().getBoolean("options.autoload_registered_worlds", true)) {
            try {
                for (ManagedWorld mw : this.registry.all()) {
                    File folder;
                    String name = mw.getName();
                    if (name == null || name.isBlank() || Bukkit.getWorld((String)name) != null || !(folder = new File(Bukkit.getWorldContainer(), name)).exists() || !folder.isDirectory()) continue;
                    World.Environment env = World.Environment.NORMAL;
                    if (new File(folder, "DIM-1").isDirectory()) {
                        env = World.Environment.NETHER;
                    } else if (new File(folder, "DIM1").isDirectory()) {
                        env = World.Environment.THE_END;
                    }
                    WorldCreator creator = new WorldCreator(name).environment(env);
                    World w = Bukkit.createWorld((WorldCreator)creator);
                    if (w != null) {
                        mw.applyToWorldIfLoaded();
                        this.getLogger().info("Auto-loaded world '" + name + "' (" + env.name() + ")");
                        continue;
                    }
                    this.getLogger().warning("Failed to auto-load world '" + name + "'");
                }
            }
            catch (Throwable t) {
                this.getLogger().warning("Auto-load of registered worlds encountered an error: " + t.getMessage());
            }
        }
        this.getServer().getPluginManager().registerEvents((Listener)new WorldRulesListener(this, this.registry), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new GuiListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ChatListener(this), (Plugin)this);
        WorldCommand worldCommand = new WorldCommand(this);
        if (this.getCommand("world") != null) {
            this.getCommand("world").setExecutor((CommandExecutor)worldCommand);
            this.getCommand("world").setTabCompleter((TabCompleter)worldCommand);
        } else {
            this.getLogger().severe("Command 'world' is not defined in plugin.yml");
        }
        if (this.getCommand("wm") != null) {
            this.getCommand("wm").setExecutor((CommandExecutor)worldCommand);
            this.getCommand("wm").setTabCompleter((TabCompleter)worldCommand);
        } else {
            this.getLogger().warning("Command alias 'wm' is not defined in plugin.yml (optional)");
        }
        HelpCommand helpCommand = new HelpCommand(this);
        if (this.getCommand("mwhelp") != null) {
            this.getCommand("mwhelp").setExecutor((CommandExecutor)helpCommand);
            this.getCommand("mwhelp").setTabCompleter((TabCompleter)helpCommand);
        } else {
            this.getLogger().warning("Command 'mwhelp' is not defined in plugin.yml (optional)");
        }
        ServicesManager sm = this.getServer().getServicesManager();
        sm.register(WorldAPI.class, (Object)this, (Plugin)this, ServicePriority.Normal);
        if (this.getServer().getPluginManager().getPlugin("PlaceholderAPI") != null) {
            try {
                new WorldManagerExpansion(this).register();
                this.getLogger().info("Registered PlaceholderAPI expansion 'worldmanager'.");
            }
            catch (Throwable t) {
                this.getLogger().warning("Failed to register PlaceholderAPI expansion: " + t.getMessage());
            }
        }
    }

    public void onDisable() {
        if (this.registry != null) {
            this.registry.save();
        }
        Bukkit.getServicesManager().unregister(WorldAPI.class, (Object)this);
    }

    public WorldRegistry getRegistry() {
        return this.registry;
    }

    public Map<UUID, Long> getLastTeleportAt() {
        return this.lastTeleportAt;
    }

    public Map<UUID, Location> getLastLocation() {
        return this.lastLocation;
    }

    public Set<String> getFavorites(UUID uuid) {
        return this.favorites.computeIfAbsent(uuid, k -> new ConcurrentSkipListSet(String.CASE_INSENSITIVE_ORDER));
    }

    public Deque<Location> getHistory(UUID uuid) {
        return this.history.computeIfAbsent(uuid, k -> new ArrayDeque());
    }

    public void pushHistory(UUID uuid, Location loc, int maxSize) {
        if (loc == null) {
            return;
        }
        Deque<Location> dq = this.getHistory(uuid);
        dq.addFirst(loc.clone());
        while (dq.size() > Math.max(1, maxSize)) {
            dq.removeLast();
        }
    }

    public int getGuiPage(UUID uuid) {
        return this.guiPage.getOrDefault(uuid, 0);
    }

    public void setGuiPage(UUID uuid, int page) {
        this.guiPage.put(uuid, Math.max(0, page));
    }

    public boolean isGuiFavOnly(UUID uuid) {
        return this.guiFavOnly.getOrDefault(uuid, false);
    }

    public void setGuiFavOnly(UUID uuid, boolean favOnly) {
        this.guiFavOnly.put(uuid, favOnly);
    }

    public GuiMode getGuiMode(UUID uuid) {
        return this.guiMode.getOrDefault(uuid, GuiMode.LOADED);
    }

    public void setGuiMode(UUID uuid, GuiMode mode) {
        this.guiMode.put(uuid, mode == null ? GuiMode.LOADED : mode);
    }

    public PendingCreate getPendingCreate(UUID uuid) {
        return this.pendingCreate.get(uuid);
    }

    public void setPendingCreate(UUID uuid, PendingCreate pc) {
        if (pc == null) {
            this.pendingCreate.remove(uuid);
        } else {
            this.pendingCreate.put(uuid, pc);
        }
    }

    public Map<String, WorldImportTask> getRunningImports() {
        return this.runningImports;
    }

    public boolean canAccessWorld(Player player, String worldName) {
        boolean useFmt;
        ConfigurationSection rule;
        if (player == null || worldName == null) {
            return true;
        }
        FileConfiguration cfg = this.getConfig();
        ConfigurationSection psec = cfg.getConfigurationSection("permissions");
        if (psec == null) {
            return true;
        }
        String bypass = psec.getString("bypass", "worldmanager.bypass.worldaccess");
        if (bypass != null && !bypass.isBlank() && player.hasPermission(bypass)) {
            return true;
        }
        ConfigurationSection worldsSec = psec.getConfigurationSection("worlds_access");
        if (worldsSec != null && (rule = worldsSec.getConfigurationSection(worldName)) != null) {
            ConfigurationSection presetsSec;
            String preset = rule.getString("preset", null);
            if (preset != null && (presetsSec = psec.getConfigurationSection("presets")) != null && presetsSec.isList(preset)) {
                List reqs = presetsSec.getStringList(preset);
                for (String node : reqs) {
                    if (node == null || node.isBlank() || player.hasPermission(node)) continue;
                    return false;
                }
                return true;
            }
            String require = rule.getString("require", null);
            if (require != null && !require.isBlank()) {
                return player.hasPermission(require);
            }
        }
        if (useFmt = psec.getBoolean("use_node_format", true)) {
            String fmt = psec.getString("node_format", "worldmanager.access.%world%");
            String node = fmt.replace("%world%", worldName);
            return player.hasPermission(node);
        }
        return true;
    }

    @Override
    public ManagedWorld getWorld(String name) {
        return this.registry != null ? this.registry.get(name) : null;
    }

    @Override
    public void teleportPlayer(Player p, String worldName) {
        World world = this.getServer().getWorld(worldName);
        if (world != null) {
            p.teleportAsync(world.getSpawnLocation());
        }
    }

    public static enum GuiMode {
        LOADED,
        LOADABLES,
        CREATE_ENV,
        CREATE_OPTIONS;

    }

    public static class PendingCreate {
        public World.Environment env;
        public Long seed;
        public Boolean structures;
        public String generator;
        public String type;
        public long expiresAt;
        public Stage stage = Stage.NONE;

        public static enum Stage {
            NONE,
            NAME,
            SEED,
            GENERATOR;

        }
    }
}

