/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.worldManager.gui;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.generator.WorldInfo;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.texboobcat.worldManager.WorldManager;

public class WorldSelectorGUI {
    public static final String TITLE = String.valueOf(ChatColor.DARK_AQUA) + "World Selector";

    public static Inventory build(Player viewer, WorldManager plugin) {
        Inventory inv = Bukkit.createInventory(null, (int)54, (String)TITLE);
        int page = plugin.getGuiPage(viewer.getUniqueId());
        int perPage = 45;
        int lastRow = 45;
        WorldManager.GuiMode mode = plugin.getGuiMode(viewer.getUniqueId());
        boolean favOnly = plugin.isGuiFavOnly(viewer.getUniqueId());
        Set<String> favs = plugin.getFavorites(viewer.getUniqueId());
        if (mode == WorldManager.GuiMode.LOADED) {
            List all = Bukkit.getWorlds();
            ArrayList worlds = favOnly ? all.stream().filter(w -> favs.contains(w.getName())).collect(Collectors.toList()) : new ArrayList(all);
            int start = page * perPage;
            int end = Math.min(start + perPage, worlds.size());
            int slot = 0;
            for (int i = start; i < end; ++i) {
                World w2 = (World)worlds.get(i);
                boolean fav = favs.contains(w2.getName());
                boolean can = plugin.canAccessWorld(viewer, w2.getName());
                ItemStack item = new ItemStack(!can ? Material.RED_STAINED_GLASS_PANE : (fav ? Material.NETHER_STAR : Material.GRASS_BLOCK));
                ItemMeta meta = item.getItemMeta();
                if (meta != null) {
                    String prefix = fav ? String.valueOf(ChatColor.GOLD) + "\u2605 " : "";
                    meta.setDisplayName(prefix + String.valueOf(can ? ChatColor.AQUA : ChatColor.DARK_RED) + w2.getName());
                    ArrayList<Object> lore = new ArrayList<Object>();
                    lore.add(String.valueOf(ChatColor.GRAY) + "Environment: " + String.valueOf(ChatColor.WHITE) + w2.getEnvironment().name());
                    lore.add(String.valueOf(ChatColor.GRAY) + "Players: " + String.valueOf(ChatColor.WHITE) + w2.getPlayers().size());
                    lore.add("");
                    if (can) {
                        lore.add(String.valueOf(ChatColor.YELLOW) + "Left-click: " + String.valueOf(ChatColor.WHITE) + "Teleport");
                    } else {
                        lore.add(String.valueOf(ChatColor.RED) + "Access denied");
                    }
                    lore.add(String.valueOf(ChatColor.YELLOW) + "Right-click: " + (fav ? String.valueOf(ChatColor.WHITE) + "Unfavorite" : String.valueOf(ChatColor.WHITE) + "Favorite"));
                    meta.setLore(lore);
                    meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
                    item.setItemMeta(meta);
                }
                inv.setItem(slot++, item);
            }
            boolean hasPrev = page > 0;
            boolean hasNext = (page + 1) * perPage < worlds.size();
            WorldSelectorGUI.set(inv, lastRow, hasPrev ? Material.ARROW : Material.GRAY_STAINED_GLASS_PANE, hasPrev ? String.valueOf(ChatColor.YELLOW) + "Previous Page" : String.valueOf(ChatColor.DARK_GRAY) + "Previous Page");
            WorldSelectorGUI.set(inv, lastRow + 8, hasNext ? Material.ARROW : Material.GRAY_STAINED_GLASS_PANE, hasNext ? String.valueOf(ChatColor.YELLOW) + "Next Page" : String.valueOf(ChatColor.DARK_GRAY) + "Next Page");
            WorldSelectorGUI.set(inv, lastRow + 3, Material.BARRIER, String.valueOf(ChatColor.RED) + "Close");
            ItemStack toggle = new ItemStack(favOnly ? Material.GLOWSTONE_DUST : Material.REDSTONE);
            ItemMeta tMeta = toggle.getItemMeta();
            if (tMeta != null) {
                tMeta.setDisplayName(String.valueOf(ChatColor.AQUA) + "Favorites: " + (favOnly ? String.valueOf(ChatColor.GREEN) + "ON" : String.valueOf(ChatColor.RED) + "OFF"));
                tMeta.setLore(List.of(String.valueOf(ChatColor.GRAY) + "Show only favorited worlds"));
                toggle.setItemMeta(tMeta);
            }
            inv.setItem(lastRow + 4, toggle);
        } else if (mode == WorldManager.GuiMode.LOADABLES) {
            File container = Bukkit.getWorldContainer();
            String[] entries = container.list((dir, name) -> new File(dir, name).isDirectory());
            List loadedNames = Bukkit.getWorlds().stream().map(WorldInfo::getName).collect(Collectors.toList());
            ArrayList<String> folders = new ArrayList<String>();
            if (entries != null) {
                for (String name2 : entries) {
                    if (loadedNames.contains(name2)) continue;
                    folders.add(name2);
                }
            }
            int start = page * perPage;
            int end = Math.min(start + perPage, folders.size());
            int slot = 0;
            for (int i = start; i < end; ++i) {
                String fname = (String)folders.get(i);
                ItemStack item = new ItemStack(Material.CHEST);
                ItemMeta meta = item.getItemMeta();
                if (meta != null) {
                    meta.setDisplayName(String.valueOf(ChatColor.AQUA) + fname);
                    ArrayList<Object> lore = new ArrayList<Object>();
                    lore.add(String.valueOf(ChatColor.GRAY) + "Folder in world container");
                    lore.add("");
                    lore.add(String.valueOf(ChatColor.YELLOW) + "Left-click: " + String.valueOf(ChatColor.WHITE) + "Import & Load (NORMAL)");
                    meta.setLore(lore);
                    item.setItemMeta(meta);
                }
                inv.setItem(slot++, item);
            }
            boolean hasPrev = page > 0;
            boolean hasNext = (page + 1) * perPage < folders.size();
            WorldSelectorGUI.set(inv, lastRow, hasPrev ? Material.ARROW : Material.GRAY_STAINED_GLASS_PANE, hasPrev ? String.valueOf(ChatColor.YELLOW) + "Previous Page" : String.valueOf(ChatColor.DARK_GRAY) + "Previous Page");
            WorldSelectorGUI.set(inv, lastRow + 8, hasNext ? Material.ARROW : Material.GRAY_STAINED_GLASS_PANE, hasNext ? String.valueOf(ChatColor.YELLOW) + "Next Page" : String.valueOf(ChatColor.DARK_GRAY) + "Next Page");
            WorldSelectorGUI.set(inv, lastRow + 3, Material.BARRIER, String.valueOf(ChatColor.RED) + "Close");
        } else if (mode == WorldManager.GuiMode.CREATE_ENV) {
            WorldSelectorGUI.setDetailed(inv, 20, Material.GRASS_BLOCK, String.valueOf(ChatColor.GREEN) + "Normal", List.of(String.valueOf(ChatColor.GRAY) + "Create NORMAL world"));
            WorldSelectorGUI.setDetailed(inv, 22, Material.NETHERRACK, String.valueOf(ChatColor.RED) + "Nether", List.of(String.valueOf(ChatColor.GRAY) + "Create NETHER world"));
            WorldSelectorGUI.setDetailed(inv, 24, Material.END_STONE, String.valueOf(ChatColor.LIGHT_PURPLE) + "The End", List.of(String.valueOf(ChatColor.GRAY) + "Create THE_END world"));
            WorldSelectorGUI.setDetailed(inv, lastRow + 3, Material.BARRIER, String.valueOf(ChatColor.RED) + "Close", List.of());
            WorldSelectorGUI.setDetailed(inv, lastRow + 4, Material.OAK_SIGN, String.valueOf(ChatColor.AQUA) + "After selecting env, configure options", List.of(String.valueOf(ChatColor.GRAY) + "Then you'll enter the world name"));
        } else if (mode == WorldManager.GuiMode.CREATE_OPTIONS) {
            WorldManager.PendingCreate pc = plugin.getPendingCreate(viewer.getUniqueId());
            String envName = pc != null && pc.env != null ? pc.env.name() : "NORMAL";
            WorldSelectorGUI.setDetailed(inv, 10, Material.GLOBE_BANNER_PATTERN, String.valueOf(ChatColor.YELLOW) + "Environment: " + String.valueOf(ChatColor.WHITE) + envName, List.of(String.valueOf(ChatColor.GRAY) + "Selected environment"));
            String structuresLabel = pc != null && pc.structures != null ? (pc.structures != false ? String.valueOf(ChatColor.GREEN) + "Enabled" : String.valueOf(ChatColor.RED) + "Disabled") : String.valueOf(ChatColor.GRAY) + "Default";
            WorldSelectorGUI.setDetailed(inv, 20, Material.LEVER, String.valueOf(ChatColor.AQUA) + "Structures: " + structuresLabel, List.of(String.valueOf(ChatColor.GRAY) + "Left-click: toggle", String.valueOf(ChatColor.GRAY) + "Shift-click: set Default"));
            String typeLabel = pc != null && pc.type != null ? pc.type : "Default";
            WorldSelectorGUI.setDetailed(inv, 22, Material.MAP, String.valueOf(ChatColor.AQUA) + "Type: " + String.valueOf(ChatColor.WHITE) + typeLabel, List.of(String.valueOf(ChatColor.GRAY) + "Left-click: cycle", String.valueOf(ChatColor.GRAY) + "Shift-click: clear"));
            String genLabel = pc != null && pc.generator != null && !pc.generator.isBlank() ? pc.generator : "<none>";
            WorldSelectorGUI.setDetailed(inv, 24, Material.BEACON, String.valueOf(ChatColor.AQUA) + "Generator: " + String.valueOf(ChatColor.WHITE) + genLabel, List.of(String.valueOf(ChatColor.GRAY) + "Click to enter generator id in chat", String.valueOf(ChatColor.GRAY) + "(blank to clear)"));
            String seedLabel = pc != null && pc.seed != null ? Long.toString(pc.seed) : "<none>";
            WorldSelectorGUI.setDetailed(inv, 30, Material.OAK_SIGN, String.valueOf(ChatColor.AQUA) + "Seed: " + String.valueOf(ChatColor.WHITE) + seedLabel, List.of(String.valueOf(ChatColor.GRAY) + "Click to enter numeric seed in chat", String.valueOf(ChatColor.GRAY) + "(blank to clear)"));
            WorldSelectorGUI.setDetailed(inv, 32, Material.ANVIL, String.valueOf(ChatColor.GREEN) + "Enter World Name", List.of(String.valueOf(ChatColor.GRAY) + "Click to type name in chat"));
            WorldSelectorGUI.setDetailed(inv, lastRow + 2, Material.ARROW, String.valueOf(ChatColor.YELLOW) + "Back to Environment", List.of());
            WorldSelectorGUI.setDetailed(inv, lastRow + 3, Material.BARRIER, String.valueOf(ChatColor.RED) + "Close", List.of());
        }
        WorldSelectorGUI.set(inv, lastRow + 1, Material.COMPASS, String.valueOf(ChatColor.YELLOW) + "Loaded Worlds");
        WorldSelectorGUI.set(inv, lastRow + 5, Material.CHEST, String.valueOf(ChatColor.YELLOW) + "Load from Folders");
        WorldSelectorGUI.set(inv, lastRow + 6, Material.ANVIL, String.valueOf(ChatColor.YELLOW) + "Create World");
        return inv;
    }

    public static void open(Player player, WorldManager plugin) {
        player.openInventory(WorldSelectorGUI.build(player, plugin));
    }

    private static void set(Inventory inv, int slot, Material mat, String name) {
        ItemStack it = new ItemStack(mat);
        ItemMeta m = it.getItemMeta();
        if (m != null) {
            m.setDisplayName(name);
            it.setItemMeta(m);
        }
        inv.setItem(slot, it);
    }

    private static void setDetailed(Inventory inv, int slot, Material mat, String name, List<String> lore) {
        ItemStack it = new ItemStack(mat);
        ItemMeta m = it.getItemMeta();
        if (m != null) {
            m.setDisplayName(name);
            if (lore != null) {
                m.setLore(lore);
            }
            it.setItemMeta(m);
        }
        inv.setItem(slot, it);
    }
}

