/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.worldManager.listener;

import io.papermc.paper.event.player.AsyncChatEvent;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.texboobcat.worldManager.WorldManager;
import org.texboobcat.worldManager.gui.WorldSelectorGUI;

public class ChatListener
implements Listener {
    private final WorldManager plugin;

    public ChatListener(WorldManager plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onChat(AsyncChatEvent event) {
        Player player = event.getPlayer();
        WorldManager.PendingCreate pc = this.plugin.getPendingCreate(player.getUniqueId());
        if (pc == null) {
            return;
        }
        if (pc.expiresAt > 0L && System.currentTimeMillis() > pc.expiresAt) {
            this.plugin.setPendingCreate(player.getUniqueId(), null);
            return;
        }
        String msg = PlainTextComponentSerializer.plainText().serialize(event.message()).trim();
        event.setCancelled(true);
        switch (pc.stage) {
            case SEED: {
                if (msg.isEmpty()) {
                    pc.seed = null;
                    player.sendMessage("\u00a77Seed cleared.");
                } else {
                    try {
                        pc.seed = Long.parseLong(msg);
                        player.sendMessage("\u00a77Seed set to \u00a7f" + pc.seed);
                    }
                    catch (NumberFormatException ex) {
                        player.sendMessage("\u00a7cInvalid seed. Please enter a number.");
                        return;
                    }
                }
                pc.stage = WorldManager.PendingCreate.Stage.NONE;
                this.plugin.setPendingCreate(player.getUniqueId(), pc);
                this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> player.openInventory(WorldSelectorGUI.build(player, this.plugin)));
                return;
            }
            case GENERATOR: {
                if (msg.isEmpty()) {
                    pc.generator = null;
                    player.sendMessage("\u00a77Generator cleared.");
                } else {
                    pc.generator = msg;
                    player.sendMessage("\u00a77Generator set to \u00a7f" + pc.generator);
                }
                pc.stage = WorldManager.PendingCreate.Stage.NONE;
                this.plugin.setPendingCreate(player.getUniqueId(), pc);
                this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> player.openInventory(WorldSelectorGUI.build(player, this.plugin)));
                return;
            }
        }
        String name = msg;
        if (name.isEmpty()) {
            this.plugin.setPendingCreate(player.getUniqueId(), null);
            return;
        }
        if (!name.matches("[A-Za-z0-9_-]{1,32}")) {
            player.sendMessage("\u00a7cInvalid world name. Use only letters, numbers, underscore or dash (max 32).");
            this.plugin.setPendingCreate(player.getUniqueId(), null);
            return;
        }
        StringBuilder cmd = new StringBuilder("world create ").append(name);
        if (pc.env != null) {
            cmd.append(' ').append(pc.env.name());
        }
        if (pc.seed != null) {
            cmd.append(' ').append("seed:").append(pc.seed);
        }
        if (pc.structures != null) {
            cmd.append(' ').append("structures:").append(pc.structures);
        }
        if (pc.generator != null && !pc.generator.isBlank()) {
            cmd.append(' ').append("generator:").append(pc.generator);
        }
        if (pc.type != null && !pc.type.isBlank()) {
            cmd.append(' ').append("type:").append(pc.type);
        }
        this.plugin.setPendingCreate(player.getUniqueId(), null);
        this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> player.performCommand(cmd.toString()));
        player.sendMessage("\u00a77Creating world '" + name + "'...");
    }
}

