/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.worldManager.task;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.plugin.Plugin;
import org.texboobcat.worldManager.WorldManager;

public class WorldImportTask {
    private final WorldManager plugin;
    private final String folderName;
    private final World.Environment environment;
    private final File folder;
    private volatile Phase phase = Phase.SCANNING;
    private volatile String detail = "";
    private final AtomicLong totalBytes = new AtomicLong(0L);
    private final AtomicLong processedBytes = new AtomicLong(0L);
    private final AtomicLong totalFiles = new AtomicLong(0L);
    private final AtomicLong processedFiles = new AtomicLong(0L);
    private volatile double percent = 0.0;
    private volatile long etaSeconds = -1L;
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final AtomicBoolean finished = new AtomicBoolean(false);
    private volatile CompletableFuture<World> result = new CompletableFuture();

    public WorldImportTask(WorldManager plugin, String folderName, World.Environment environment) {
        this.plugin = plugin;
        this.folderName = folderName;
        this.environment = environment;
        this.folder = new File(Bukkit.getWorldContainer(), folderName);
    }

    public void start() {
        if (!this.started.compareAndSet(false, true)) {
            return;
        }
        if (!this.folder.exists() || !this.folder.isDirectory()) {
            this.phase = Phase.FAILED;
            this.detail = "Missing folder";
            this.result.complete(null);
            this.finished.set(true);
            return;
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try {
                this.phase = Phase.SCANNING;
                this.detail = "Counting files";
                Path root = this.folder.toPath();
                Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        if (attrs.isRegularFile()) {
                            WorldImportTask.this.totalFiles.incrementAndGet();
                            WorldImportTask.this.totalBytes.addAndGet(attrs.size());
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
                final long total = Math.max(1L, this.totalBytes.get());
                final Instant start = Instant.now();
                this.phase = Phase.VALIDATING;
                this.detail = "Validating region and level files";
                Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        if (attrs.isRegularFile()) {
                            WorldImportTask.this.processedFiles.incrementAndGet();
                            long size = attrs.size();
                            WorldImportTask.this.processedBytes.addAndGet(size);
                            WorldImportTask.this.percent = Math.min(80.0, (double)WorldImportTask.this.processedBytes.get() * 80.0 / (double)total);
                            long done = WorldImportTask.this.processedBytes.get();
                            Duration elapsed = Duration.between(start, Instant.now());
                            long secs = Math.max(1L, elapsed.getSeconds());
                            long bytesPerSec = Math.max(1L, done / secs);
                            long remain = Math.max(0L, total - done);
                            WorldImportTask.this.etaSeconds = remain / bytesPerSec;
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
                boolean hasLevel = new File(this.folder, "level.dat").exists();
                boolean hasRegion = new File(this.folder, "region").isDirectory();
                if (!hasLevel && !hasRegion) {
                    throw new IOException("Not a valid world folder: missing level.dat and region/");
                }
                this.phase = Phase.LOADING;
                this.percent = 90.0;
                this.detail = "Loading world";
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                    try {
                        WorldCreator creator = new WorldCreator(this.folderName).environment(this.environment);
                        World world = Bukkit.createWorld((WorldCreator)creator);
                        if (world == null) {
                            throw new IllegalStateException("Bukkit returned null world");
                        }
                        this.percent = 100.0;
                        this.etaSeconds = 0L;
                        this.phase = Phase.DONE;
                        this.finished.set(true);
                        this.result.complete(world);
                    }
                    catch (Throwable t) {
                        this.phase = Phase.FAILED;
                        this.detail = t.getMessage();
                        this.finished.set(true);
                        this.result.complete(null);
                    }
                });
            }
            catch (Throwable t) {
                this.phase = Phase.FAILED;
                this.detail = t.getMessage();
                this.finished.set(true);
                this.result.complete(null);
            }
        });
    }

    public boolean isFinished() {
        return this.finished.get();
    }

    public Phase getPhase() {
        return this.phase;
    }

    public double getPercent() {
        return this.percent;
    }

    public long getEtaSeconds() {
        return this.etaSeconds;
    }

    public String getDetail() {
        return this.detail;
    }

    public String getFolderName() {
        return this.folderName;
    }

    public World.Environment getEnvironment() {
        return this.environment;
    }

    public CompletableFuture<World> getResult() {
        return this.result;
    }

    public static enum Phase {
        SCANNING,
        VALIDATING,
        LOADING,
        DONE,
        FAILED;

    }
}

