/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.worldManager;

import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.generator.WorldInfo;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.ServicesManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.texboobcat.worldManager.HelpCommand;
import org.texboobcat.worldManager.WorldCommand;
import org.texboobcat.worldManager.api.AddonManager;
import org.texboobcat.worldManager.api.PortalService;
import org.texboobcat.worldManager.api.TeleportationService;
import org.texboobcat.worldManager.api.WorldAPI;
import org.texboobcat.worldManager.api.WorldOperationService;
import org.texboobcat.worldManager.command.PortalCommand;
import org.texboobcat.worldManager.generator.VoidChunkGenerator;
import org.texboobcat.worldManager.integration.WorldManagerExpansion;
import org.texboobcat.worldManager.listener.ChatListener;
import org.texboobcat.worldManager.listener.GuiListener;
import org.texboobcat.worldManager.listener.PortalListener;
import org.texboobcat.worldManager.listener.PortalWandListener;
import org.texboobcat.worldManager.listener.WorldRulesListener;
import org.texboobcat.worldManager.model.ManagedWorld;
import org.texboobcat.worldManager.service.WorldManagerAddonManager;
import org.texboobcat.worldManager.service.WorldManagerOperationService;
import org.texboobcat.worldManager.service.WorldManagerPortalService;
import org.texboobcat.worldManager.service.WorldManagerTeleportationService;
import org.texboobcat.worldManager.service.WorldRegistry;
import org.texboobcat.worldManager.task.WorldImportTask;

public final class WorldManager
extends JavaPlugin
implements WorldAPI {
    private WorldRegistry registry;
    private WorldManagerAddonManager addonManager;
    private WorldManagerTeleportationService teleportationService;
    private WorldManagerOperationService operationService;
    private WorldManagerPortalService portalService;
    private final Map<UUID, Long> lastTeleportAt = new ConcurrentHashMap<UUID, Long>();
    private final Map<UUID, Location> lastLocation = new ConcurrentHashMap<UUID, Location>();
    private final Map<UUID, Set<String>> favorites = new ConcurrentHashMap<UUID, Set<String>>();
    private final Map<UUID, Deque<Location>> history = new ConcurrentHashMap<UUID, Deque<Location>>();
    private final Map<UUID, Integer> guiPage = new ConcurrentHashMap<UUID, Integer>();
    private final Map<UUID, Boolean> guiFavOnly = new ConcurrentHashMap<UUID, Boolean>();
    private final Map<UUID, GuiMode> guiMode = new ConcurrentHashMap<UUID, GuiMode>();
    private final Map<UUID, PendingCreate> pendingCreate = new ConcurrentHashMap<UUID, PendingCreate>();
    private final Map<String, WorldImportTask> runningImports = new ConcurrentHashMap<String, WorldImportTask>();

    public void onEnable() {
        this.saveDefaultConfig();
        try {
            MergeInfo info = this.mergeConfigWithBackup();
            if (info.changed) {
                this.getLogger().info("Config merged: version " + info.fromVersion + " -> " + info.toVersion + ", added " + info.addedKeys + " keys.");
            } else {
                this.getLogger().info("Config up-to-date (version " + info.toVersion + ")");
            }
        }
        catch (Exception e) {
            this.getLogger().warning("Failed to update/merge config.yml: " + e.getMessage());
        }
        this.registry = new WorldRegistry(this);
        this.registry.load();
        this.addonManager = new WorldManagerAddonManager();
        this.teleportationService = new WorldManagerTeleportationService(this);
        this.operationService = new WorldManagerOperationService(this);
        this.portalService = new WorldManagerPortalService(this);
        try {
            boolean autoCleanup;
            ConfigurationSection qsec = this.getConfig().getConfigurationSection("options.delete_trash");
            boolean bl = autoCleanup = qsec != null && qsec.getBoolean("auto_cleanup_on_start", true);
            if (autoCleanup) {
                File[] files;
                int minutes = Math.max(1, qsec.getInt("retention_minutes", 120));
                long now = System.currentTimeMillis();
                long ttlMs = (long)minutes * 60L * 1000L;
                File trashDir = new File(Bukkit.getWorldContainer(), "trash");
                if (trashDir.isDirectory() && (files = trashDir.listFiles((d, n) -> n != null && n.toLowerCase(Locale.ROOT).endsWith(".zip"))) != null) {
                    for (File f : files) {
                        long age = now - f.lastModified();
                        if (age <= ttlMs) continue;
                        try {
                            Files.deleteIfExists(f.toPath());
                            this.getLogger().info("Purged expired trash zip: " + f.getName());
                        }
                        catch (Exception e) {
                            this.getLogger().warning("Failed to purge trash zip '" + f.getName() + "': " + e.getMessage());
                        }
                    }
                }
            }
        }
        catch (Throwable t) {
            this.getLogger().warning("Trash zip auto-cleanup encountered an error: " + t.getMessage());
        }
        if (this.getConfig().getBoolean("options.autoload_registered_worlds", true)) {
            Bukkit.getScheduler().runTask((Plugin)this, () -> {
                try {
                    for (ManagedWorld mw : this.registry.all()) {
                        WorldCreator creator;
                        World w;
                        File folder;
                        String name = mw.getName();
                        if (name == null || name.isBlank() || Bukkit.getWorld((String)name) != null || !(folder = new File(Bukkit.getWorldContainer(), name)).exists() || !folder.isDirectory()) continue;
                        World.Environment env = mw.getEnvironment();
                        if (env == null) {
                            env = World.Environment.NORMAL;
                            if (new File(folder, "DIM-1").isDirectory()) {
                                env = World.Environment.NETHER;
                            } else if (new File(folder, "DIM1").isDirectory()) {
                                env = World.Environment.THE_END;
                            }
                            mw.setEnvironment(env);
                            this.registry.save();
                        }
                        if ((w = Bukkit.createWorld((WorldCreator)(creator = new WorldCreator(name).environment(env)))) != null) {
                            mw.applyToWorldIfLoaded();
                            this.getLogger().info("Auto-loaded world '" + name + "' (" + env.name() + ")");
                            continue;
                        }
                        this.getLogger().warning("Failed to auto-load world '" + name + "'");
                    }
                }
                catch (Throwable t) {
                    this.getLogger().warning("Auto-load of registered worlds encountered an error: " + t.getMessage());
                }
            });
        }
        this.getServer().getPluginManager().registerEvents((Listener)new WorldRulesListener(this, this.registry), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new GuiListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ChatListener(this), (Plugin)this);
        PortalWandListener portalWandListener = new PortalWandListener(this);
        this.getServer().getPluginManager().registerEvents((Listener)new PortalListener(this, this.portalService), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)portalWandListener, (Plugin)this);
        WorldCommand worldCommand = new WorldCommand(this);
        if (this.getCommand("world") != null) {
            this.getCommand("world").setExecutor((CommandExecutor)worldCommand);
            this.getCommand("world").setTabCompleter((TabCompleter)worldCommand);
        } else {
            this.getLogger().severe("Command 'world' is not defined in plugin.yml");
        }
        if (this.getCommand("wm") != null) {
            this.getCommand("wm").setExecutor((CommandExecutor)worldCommand);
            this.getCommand("wm").setTabCompleter((TabCompleter)worldCommand);
        } else {
            this.getLogger().warning("Command alias 'wm' is not defined in plugin.yml (optional)");
        }
        HelpCommand helpCommand = new HelpCommand(this);
        if (this.getCommand("mwhelp") != null) {
            this.getCommand("mwhelp").setExecutor((CommandExecutor)helpCommand);
            this.getCommand("mwhelp").setTabCompleter((TabCompleter)helpCommand);
        } else {
            this.getLogger().warning("Command 'mwhelp' is not defined in plugin.yml (optional)");
        }
        PortalCommand portalCommand = new PortalCommand(this, this.portalService, portalWandListener);
        if (this.getCommand("portal") != null) {
            this.getCommand("portal").setExecutor((CommandExecutor)portalCommand);
            this.getCommand("portal").setTabCompleter((TabCompleter)portalCommand);
        } else {
            this.getLogger().warning("Command 'portal' is not defined in plugin.yml");
        }
        ServicesManager sm = this.getServer().getServicesManager();
        sm.register(WorldAPI.class, (Object)this, (Plugin)this, ServicePriority.Normal);
        if (this.getServer().getPluginManager().getPlugin("PlaceholderAPI") != null) {
            try {
                new WorldManagerExpansion(this).register();
                this.getLogger().info("Registered PlaceholderAPI expansion 'worldmanager'.");
            }
            catch (Throwable t) {
                this.getLogger().warning("Failed to register PlaceholderAPI expansion: " + t.getMessage());
            }
        }
    }

    public void onDisable() {
        if (this.registry != null) {
            this.registry.save();
        }
        if (this.portalService != null) {
            this.portalService.savePortals();
        }
        Bukkit.getServicesManager().unregister(WorldAPI.class, (Object)this);
    }

    public WorldRegistry getRegistry() {
        return this.registry;
    }

    public Map<UUID, Long> getLastTeleportAt() {
        return this.lastTeleportAt;
    }

    public Map<UUID, Location> getLastLocation() {
        return this.lastLocation;
    }

    public Set<String> getFavorites(UUID uuid) {
        return this.favorites.computeIfAbsent(uuid, k -> new ConcurrentSkipListSet(String.CASE_INSENSITIVE_ORDER));
    }

    public Deque<Location> getHistory(UUID uuid) {
        return this.history.computeIfAbsent(uuid, k -> new ArrayDeque());
    }

    public void pushHistory(UUID uuid, Location loc, int maxSize) {
        if (loc == null) {
            return;
        }
        Deque<Location> dq = this.getHistory(uuid);
        dq.addFirst(loc.clone());
        while (dq.size() > Math.max(1, maxSize)) {
            dq.removeLast();
        }
    }

    public int getGuiPage(UUID uuid) {
        return this.guiPage.getOrDefault(uuid, 0);
    }

    public void setGuiPage(UUID uuid, int page) {
        this.guiPage.put(uuid, Math.max(0, page));
    }

    public boolean isGuiFavOnly(UUID uuid) {
        return this.guiFavOnly.getOrDefault(uuid, false);
    }

    public void setGuiFavOnly(UUID uuid, boolean favOnly) {
        this.guiFavOnly.put(uuid, favOnly);
    }

    public GuiMode getGuiMode(UUID uuid) {
        return this.guiMode.getOrDefault(uuid, GuiMode.LOADED);
    }

    public void setGuiMode(UUID uuid, GuiMode mode) {
        this.guiMode.put(uuid, mode == null ? GuiMode.LOADED : mode);
    }

    public PendingCreate getPendingCreate(UUID uuid) {
        return this.pendingCreate.get(uuid);
    }

    public void setPendingCreate(UUID uuid, PendingCreate pc) {
        if (pc == null) {
            this.pendingCreate.remove(uuid);
        } else {
            this.pendingCreate.put(uuid, pc);
        }
    }

    public Map<String, WorldImportTask> getRunningImports() {
        return this.runningImports;
    }

    @Override
    public boolean canAccessWorld(Player player, String worldName) {
        boolean useFmt;
        ConfigurationSection rule;
        if (player == null || worldName == null) {
            return true;
        }
        FileConfiguration cfg = this.getConfig();
        ConfigurationSection psec = cfg.getConfigurationSection("permissions");
        if (psec == null) {
            return true;
        }
        String bypass = psec.getString("bypass", "worldmanager.bypass.worldaccess");
        if (bypass != null && !bypass.isBlank() && player.hasPermission(bypass)) {
            return true;
        }
        ConfigurationSection worldsSec = psec.getConfigurationSection("worlds_access");
        if (worldsSec != null && (rule = worldsSec.getConfigurationSection(worldName)) != null) {
            ConfigurationSection presetsSec;
            String preset = rule.getString("preset", null);
            if (preset != null && (presetsSec = psec.getConfigurationSection("presets")) != null && presetsSec.isList(preset)) {
                List reqs = presetsSec.getStringList(preset);
                for (String node : reqs) {
                    if (node == null || node.isBlank() || player.hasPermission(node)) continue;
                    return false;
                }
                return true;
            }
            String require = rule.getString("require", null);
            if (require != null && !require.isBlank()) {
                return player.hasPermission(require);
            }
        }
        if (useFmt = psec.getBoolean("use_node_format", true)) {
            String fmt = psec.getString("node_format", "worldmanager.access.%world%");
            String node = fmt.replace("%world%", worldName);
            return player.hasPermission(node);
        }
        return true;
    }

    @Override
    @Nullable
    public ManagedWorld getWorld(@NotNull String name) {
        return this.registry != null ? this.registry.get(name) : null;
    }

    @Override
    @NotNull
    public Collection<ManagedWorld> getAllWorlds() {
        return this.registry != null ? this.registry.all() : Collections.emptyList();
    }

    @Override
    @NotNull
    public ManagedWorld registerWorld(@NotNull String worldName) {
        return this.registry.ensure(worldName);
    }

    @Override
    public boolean unregisterWorld(@NotNull String worldName) {
        if (this.registry.get(worldName) != null) {
            this.registry.unregister(worldName);
            this.registry.save();
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public CompletableFuture<World> createWorld(@NotNull String worldName, @NotNull World.Environment environment, @Nullable Long seed, @Nullable String generator) {
        WorldOperationService.WorldCreationOptions options = new WorldOperationService.WorldCreationOptions(worldName, environment).autoRegister(true).autoLoad(true);
        if (seed != null) {
            options.seed(seed);
        }
        if (generator != null) {
            options.generator(generator);
        }
        return this.operationService.createWorld(options);
    }

    @Override
    @NotNull
    public CompletableFuture<World> loadWorld(@NotNull String worldName, @NotNull World.Environment environment) {
        return this.operationService.loadWorld(worldName, environment, true);
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> unloadWorld(@NotNull String worldName, boolean save) {
        return this.operationService.unloadWorld(worldName, save, true, null);
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> deleteWorld(@NotNull String worldName, boolean moveToTrash) {
        return this.operationService.deleteWorld(worldName, true, moveToTrash, false);
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> importWorld(@NotNull File sourceFile, @NotNull String targetName, boolean deleteSource) {
        return this.operationService.importWorld(sourceFile, targetName, deleteSource, false);
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> cloneWorld(@NotNull String sourceWorld, @NotNull String targetWorld) {
        return this.operationService.cloneWorld(sourceWorld, targetWorld, false);
    }

    @Override
    public void teleportPlayer(@NotNull Player player, @NotNull String worldName) {
        World world = this.getServer().getWorld(worldName);
        if (world != null) {
            player.teleportAsync(world.getSpawnLocation());
        }
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> teleportPlayer(@NotNull Player player, @NotNull Location location) {
        return this.teleportationService.teleport(player, location, "api", false, false);
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> teleportBack(@NotNull Player player) {
        Location last = this.teleportationService.getLastLocation(player.getUniqueId());
        if (last == null || last.getWorld() == null) {
            return CompletableFuture.completedFuture(false);
        }
        return this.teleportationService.teleport(player, last, "back", false, false);
    }

    @Override
    @Nullable
    public Location getLastLocation(@NotNull UUID playerUUID) {
        return this.teleportationService.getLastLocation(playerUUID);
    }

    @Override
    @NotNull
    public Collection<Location> getTeleportHistory(@NotNull UUID playerUUID) {
        return this.teleportationService.getHistory(playerUUID);
    }

    @Override
    @NotNull
    public Set<String> getFavoriteWorlds(@NotNull UUID playerUUID) {
        return this.getFavorites(playerUUID);
    }

    @Override
    public boolean addFavoriteWorld(@NotNull UUID playerUUID, @NotNull String worldName) {
        return this.getFavorites(playerUUID).add(worldName);
    }

    @Override
    public boolean removeFavoriteWorld(@NotNull UUID playerUUID, @NotNull String worldName) {
        return this.getFavorites(playerUUID).remove(worldName);
    }

    @Override
    public boolean isFavorite(@NotNull UUID playerUUID, @NotNull String worldName) {
        return this.getFavorites(playerUUID).contains(worldName);
    }

    @Override
    @NotNull
    public Collection<String> getAccessibleWorlds(@NotNull Player player) {
        return Bukkit.getWorlds().stream().map(WorldInfo::getName).filter(name -> this.canAccessWorld(player, (String)name)).collect(Collectors.toList());
    }

    @Override
    public boolean applyWorldConfiguration(@NotNull String worldName) {
        ManagedWorld mw = this.registry.get(worldName);
        if (mw == null) {
            return false;
        }
        World world = Bukkit.getWorld((String)worldName);
        if (world == null) {
            return false;
        }
        mw.applyToWorldIfLoaded();
        return true;
    }

    @Override
    public void saveWorldConfigurations() {
        if (this.registry != null) {
            this.registry.save();
        }
    }

    @Override
    public void reloadWorldConfigurations() {
        if (this.registry != null) {
            this.registry.load();
        }
    }

    @Override
    @NotNull
    public TeleportationService getTeleportationService() {
        return this.teleportationService;
    }

    @Override
    @NotNull
    public WorldOperationService getWorldOperationService() {
        return this.operationService;
    }

    @Override
    @NotNull
    public AddonManager getAddonManager() {
        return this.addonManager;
    }

    @Override
    @NotNull
    public PortalService getPortalService() {
        return this.portalService;
    }

    public MergeInfo mergeConfigWithBackup() throws Exception {
        boolean changed;
        boolean versionChanged;
        File configFile = new File(this.getDataFolder(), "config.yml");
        YamlConfiguration current = YamlConfiguration.loadConfiguration((File)configFile);
        InputStream in = this.getResource("config.yml");
        if (in == null) {
            return new MergeInfo(0, 0, 0, false);
        }
        YamlConfiguration defaults = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(in, StandardCharsets.UTF_8));
        int currentVer = current.getInt("config_version", 0);
        int defaultVer = defaults.getInt("config_version", 1);
        int[] added = new int[1];
        this.mergeSectionsCountAdds((FileConfiguration)current, (ConfigurationSection)defaults, null, added);
        boolean bl = versionChanged = currentVer != defaultVer;
        if (versionChanged) {
            current.set("config_version", (Object)defaultVer);
        }
        boolean bl2 = changed = added[0] > 0 || versionChanged;
        if (!changed) {
            return new MergeInfo(currentVer, defaultVer, 0, false);
        }
        File backupDir = new File(this.getDataFolder(), "config-backups");
        if (!backupDir.isDirectory() && !backupDir.mkdirs()) {
            this.getLogger().warning("Could not create backup directory: " + backupDir.getAbsolutePath());
        }
        String ts = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMdd-HHmmss"));
        Path backup = new File(backupDir, "config-" + ts + ".yml").toPath();
        try {
            Files.copy(configFile.toPath(), backup, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception e) {
            this.getLogger().warning("Failed to backup config.yml: " + e.getMessage());
        }
        current.save(configFile);
        this.reloadConfig();
        return new MergeInfo(currentVer, defaultVer, added[0], true);
    }

    private void mergeSectionsCountAdds(FileConfiguration target, ConfigurationSection defaults, String path, int[] addedCounter) {
        for (String key : defaults.getKeys(false)) {
            String full = path == null || path.isEmpty() ? key : path + "." + key;
            Object defVal = defaults.get(key);
            if (defVal instanceof ConfigurationSection) {
                ConfigurationSection defSec = defaults.getConfigurationSection(key);
                if (!target.isConfigurationSection(full)) {
                    target.createSection(full);
                }
                if (defSec == null) continue;
                this.mergeSectionsCountAdds(target, defSec, full, addedCounter);
                continue;
            }
            if (target.contains(full)) continue;
            target.set(full, defVal);
            addedCounter[0] = addedCounter[0] + 1;
        }
    }

    public ChunkGenerator getDefaultWorldGenerator(String worldName, String id) {
        if (id == null) {
            return null;
        }
        String key = id.toLowerCase(Locale.ROOT).trim();
        if ("void".equals(key) || "worldmanager:void".equals(key) || "wm:void".equals(key)) {
            return new VoidChunkGenerator();
        }
        return null;
    }

    public static class MergeInfo {
        public final int fromVersion;
        public final int toVersion;
        public final int addedKeys;
        public final boolean changed;

        public MergeInfo(int fromVersion, int toVersion, int addedKeys, boolean changed) {
            this.fromVersion = fromVersion;
            this.toVersion = toVersion;
            this.addedKeys = addedKeys;
            this.changed = changed;
        }
    }

    public static enum GuiMode {
        LOADED,
        LOADABLES,
        CREATE_ENV,
        CREATE_OPTIONS;

    }

    public static class PendingCreate {
        public World.Environment env;
        public Long seed;
        public Boolean structures;
        public String generator;
        public String type;
        public long expiresAt;
        public Stage stage = Stage.NONE;

        public static enum Stage {
            NONE,
            NAME,
            SEED,
            GENERATOR;

        }
    }
}

