/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.worldManager.api;

import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.texboobcat.worldManager.model.Portal;

public interface PortalService {
    @Nullable
    public Portal createPortal(@NotNull String var1);

    public boolean deletePortal(@NotNull String var1);

    @Nullable
    public Portal getPortal(@NotNull String var1);

    @NotNull
    public Collection<Portal> getAllPortals();

    @NotNull
    public Collection<Portal> getPortalsInWorld(@NotNull String var1);

    @Nullable
    public Portal getPortalAt(@NotNull Location var1);

    public boolean isNameAvailable(@NotNull String var1);

    public void savePortals();

    default public void scheduleSave() {
        this.savePortals();
    }

    public void reloadPortals();

    @NotNull
    public CompletableFuture<Boolean> teleportThroughPortal(@NotNull Player var1, @NotNull Portal var2);

    public boolean canUsePortal(@NotNull Player var1, @NotNull Portal var2);

    public long getRemainingCooldown(@NotNull Player var1, @NotNull Portal var2);

    public void spawnPortalEffects(@NotNull Portal var1);
}

