/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.worldManager.api;

import java.io.File;
import java.util.Collection;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.texboobcat.worldManager.api.AddonManager;
import org.texboobcat.worldManager.api.PortalService;
import org.texboobcat.worldManager.api.TeleportationService;
import org.texboobcat.worldManager.api.WorldOperationService;
import org.texboobcat.worldManager.model.ManagedWorld;

public interface WorldAPI {
    @Nullable
    public ManagedWorld getWorld(@NotNull String var1);

    @NotNull
    public Collection<ManagedWorld> getAllWorlds();

    @NotNull
    public ManagedWorld registerWorld(@NotNull String var1);

    public boolean unregisterWorld(@NotNull String var1);

    @NotNull
    public CompletableFuture<World> createWorld(@NotNull String var1, @NotNull World.Environment var2, @Nullable Long var3, @Nullable String var4);

    @NotNull
    public CompletableFuture<World> loadWorld(@NotNull String var1, @NotNull World.Environment var2);

    @NotNull
    public CompletableFuture<Boolean> unloadWorld(@NotNull String var1, boolean var2);

    @NotNull
    public CompletableFuture<Boolean> deleteWorld(@NotNull String var1, boolean var2);

    @NotNull
    public CompletableFuture<Boolean> importWorld(@NotNull File var1, @NotNull String var2, boolean var3);

    @NotNull
    public CompletableFuture<Boolean> cloneWorld(@NotNull String var1, @NotNull String var2);

    public void teleportPlayer(@NotNull Player var1, @NotNull String var2);

    @NotNull
    public CompletableFuture<Boolean> teleportPlayer(@NotNull Player var1, @NotNull Location var2);

    @NotNull
    public CompletableFuture<Boolean> teleportBack(@NotNull Player var1);

    @Nullable
    public Location getLastLocation(@NotNull UUID var1);

    @NotNull
    public Collection<Location> getTeleportHistory(@NotNull UUID var1);

    @NotNull
    public Set<String> getFavoriteWorlds(@NotNull UUID var1);

    public boolean addFavoriteWorld(@NotNull UUID var1, @NotNull String var2);

    public boolean removeFavoriteWorld(@NotNull UUID var1, @NotNull String var2);

    public boolean isFavorite(@NotNull UUID var1, @NotNull String var2);

    public boolean canAccessWorld(@NotNull Player var1, @NotNull String var2);

    @NotNull
    public Collection<String> getAccessibleWorlds(@NotNull Player var1);

    public boolean applyWorldConfiguration(@NotNull String var1);

    public void saveWorldConfigurations();

    public void reloadWorldConfigurations();

    @NotNull
    public TeleportationService getTeleportationService();

    @NotNull
    public WorldOperationService getWorldOperationService();

    @NotNull
    public AddonManager getAddonManager();

    @NotNull
    public PortalService getPortalService();
}

