/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.worldManager.api;

import java.io.File;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import org.bukkit.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface WorldOperationService {
    @NotNull
    public CompletableFuture<World> createWorld(@NotNull WorldCreationOptions var1);

    @NotNull
    public CompletableFuture<World> loadWorld(@NotNull String var1, @NotNull World.Environment var2, boolean var3);

    @NotNull
    public CompletableFuture<Boolean> unloadWorld(@NotNull String var1, boolean var2, boolean var3, @Nullable String var4);

    @NotNull
    public CompletableFuture<Boolean> deleteWorld(@NotNull String var1, boolean var2, boolean var3, boolean var4);

    @NotNull
    public CompletableFuture<Boolean> cloneWorld(@NotNull String var1, @NotNull String var2, boolean var3);

    @NotNull
    public CompletableFuture<Boolean> importWorld(@NotNull File var1, @NotNull String var2, boolean var3, boolean var4);

    @NotNull
    public CompletableFuture<Boolean> exportWorld(@NotNull String var1, @NotNull File var2, boolean var3);

    @NotNull
    public Collection<String> getLoadableWorlds();

    public boolean worldExists(@NotNull String var1);

    public boolean isWorldLoaded(@NotNull String var1);

    @NotNull
    public CompletableFuture<Boolean> saveWorld(@NotNull String var1);

    @NotNull
    public CompletableFuture<Integer> regenerateChunks(@NotNull String var1, int var2, int var3, int var4);

    public static class WorldCreationOptions {
        private final String name;
        private final World.Environment environment;
        private Long seed;
        private String generator;
        private String generatorSettings;
        private Boolean structures;
        private boolean autoRegister = true;
        private boolean autoLoad = true;

        public WorldCreationOptions(@NotNull String name, @NotNull World.Environment environment) {
            this.name = name;
            this.environment = environment;
        }

        public String getName() {
            return this.name;
        }

        public World.Environment getEnvironment() {
            return this.environment;
        }

        public Long getSeed() {
            return this.seed;
        }

        public String getGenerator() {
            return this.generator;
        }

        public String getGeneratorSettings() {
            return this.generatorSettings;
        }

        public Boolean getStructures() {
            return this.structures;
        }

        public boolean isAutoRegister() {
            return this.autoRegister;
        }

        public boolean isAutoLoad() {
            return this.autoLoad;
        }

        public WorldCreationOptions seed(long seed) {
            this.seed = seed;
            return this;
        }

        public WorldCreationOptions generator(String generator) {
            this.generator = generator;
            return this;
        }

        public WorldCreationOptions generatorSettings(String settings) {
            this.generatorSettings = settings;
            return this;
        }

        public WorldCreationOptions structures(boolean structures) {
            this.structures = structures;
            return this;
        }

        public WorldCreationOptions autoRegister(boolean autoRegister) {
            this.autoRegister = autoRegister;
            return this;
        }

        public WorldCreationOptions autoLoad(boolean autoLoad) {
            this.autoLoad = autoLoad;
            return this;
        }
    }
}

