/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.worldManager.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.texboobcat.worldManager.WorldManager;
import org.texboobcat.worldManager.listener.PortalWandListener;
import org.texboobcat.worldManager.model.Portal;
import org.texboobcat.worldManager.model.PortalDestination;
import org.texboobcat.worldManager.model.PortalRegion;
import org.texboobcat.worldManager.service.WorldManagerPortalService;

public class PortalCommand
implements CommandExecutor,
TabCompleter {
    private final WorldManager plugin;
    private final WorldManagerPortalService portalService;
    private final PortalWandListener wandListener;

    public PortalCommand(WorldManager plugin, WorldManagerPortalService portalService, PortalWandListener wandListener) {
        this.plugin = plugin;
        this.portalService = portalService;
        this.wandListener = wandListener;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        String subCommand;
        if (args.length == 0) {
            this.sendHelp(sender);
            return true;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "create": {
                return this.handleCreate(sender, args);
            }
            case "delete": 
            case "remove": {
                return this.handleDelete(sender, args);
            }
            case "list": {
                return this.handleList(sender, args);
            }
            case "info": {
                return this.handleInfo(sender, args);
            }
            case "setregion": {
                return this.handleSetRegion(sender, args);
            }
            case "setdest": 
            case "destination": {
                return this.handleSetDestination(sender, args);
            }
            case "pos1": {
                return this.handlePos1(sender);
            }
            case "pos2": {
                return this.handlePos2(sender);
            }
            case "wand": {
                return this.handleWand(sender);
            }
            case "nearby": {
                return this.handleNearby(sender, args);
            }
            case "deletehere": {
                return this.handleDeleteHere(sender, args);
            }
            case "appearance": {
                return this.handleAppearance(sender, args);
            }
            case "appearanceplane": {
                return this.handleAppearancePlane(sender, args);
            }
            case "particles": {
                return this.handleParticles(sender, args);
            }
            case "enable": {
                return this.handleEnable(sender, args);
            }
            case "disable": {
                return this.handleDisable(sender, args);
            }
            case "permission": {
                return this.handlePermission(sender, args);
            }
            case "warmup": {
                return this.handleWarmup(sender, args);
            }
            case "cooldown": {
                return this.handleCooldown(sender, args);
            }
            case "effects": {
                return this.handleEffects(sender, args);
            }
            case "tp": 
            case "teleport": {
                return this.handleTeleport(sender, args);
            }
            case "reload": {
                return this.handleReload(sender);
            }
            case "help": {
                this.sendDetailedHelp(sender);
                return true;
            }
        }
        sender.sendMessage("\u00a7cUnknown subcommand. Use /portal help");
        return true;
    }

    private boolean handleCreate(CommandSender sender, String[] args) {
        if (!sender.hasPermission("worldmanager.portal.create")) {
            sender.sendMessage("\u00a7cYou don't have permission to create portals.");
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage("\u00a7cUsage: /portal create <name>");
            return true;
        }
        String name = args[1];
        if (!this.portalService.isNameAvailable(name)) {
            sender.sendMessage("\u00a7cA portal with that name already exists.");
            return true;
        }
        Portal portal = this.portalService.createPortal(name);
        if (portal != null) {
            if (sender instanceof Player) {
                portal.setCreator(sender.getName());
                this.portalService.scheduleSave();
            }
            sender.sendMessage("\u00a7aCreated portal: \u00a7b" + name);
            sender.sendMessage("\u00a77Next steps:");
            sender.sendMessage("\u00a77 1. Select region with /portal pos1 and /portal pos2");
            sender.sendMessage("\u00a77 2. Set region with /portal setregion " + name);
            sender.sendMessage("\u00a77 3. Set destination with /portal setdest " + name + " <world|coords>");
            sender.sendMessage("\u00a77 4. Set appearance with /portal appearance " + name + " <nether|end|particles>");
        } else {
            sender.sendMessage("\u00a7cFailed to create portal.");
        }
        return true;
    }

    private boolean handleDelete(CommandSender sender, String[] args) {
        if (!sender.hasPermission("worldmanager.portal.delete")) {
            sender.sendMessage("\u00a7cYou don't have permission to delete portals.");
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage("\u00a7cUsage: /portal delete <name>");
            return true;
        }
        String name = args[1];
        boolean deleted = this.portalService.deletePortal(name);
        if (deleted) {
            sender.sendMessage("\u00a7aDeleted portal: \u00a7b" + name);
        } else {
            sender.sendMessage("\u00a7cPortal not found: " + name);
        }
        return true;
    }

    private boolean handleList(CommandSender sender, String[] args) {
        if (!sender.hasPermission("worldmanager.portal.list")) {
            sender.sendMessage("\u00a7cYou don't have permission to list portals.");
            return true;
        }
        Collection<Portal> portals = this.portalService.getAllPortals();
        if (portals.isEmpty()) {
            sender.sendMessage("\u00a77No portals exist. Create one with /portal create <name>");
            return true;
        }
        sender.sendMessage("\u00a7a\u00a7l=== Portals (" + portals.size() + ") ===");
        for (Portal portal : portals) {
            String status = portal.isComplete() ? "\u00a7a\u2713" : "\u00a7c\u2717";
            String enabled = portal.isEnabled() ? "\u00a7aEnabled" : "\u00a7cDisabled";
            sender.sendMessage(status + " \u00a7b" + portal.getName() + " \u00a77- " + enabled);
            if (portal.getRegion() != null) {
                sender.sendMessage("   \u00a77Region: " + portal.getRegion().getWorldName());
            }
            if (portal.getDestination() == null) continue;
            sender.sendMessage("   \u00a77Dest: " + String.valueOf(portal.getDestination()));
        }
        return true;
    }

    private boolean handleInfo(CommandSender sender, String[] args) {
        if (!sender.hasPermission("worldmanager.portal.info")) {
            sender.sendMessage("\u00a7cYou don't have permission to view portal info.");
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage("\u00a7cUsage: /portal info <name>");
            return true;
        }
        String name = args[1];
        Portal portal = this.portalService.getPortal(name);
        if (portal == null) {
            sender.sendMessage("\u00a7cPortal not found: " + name);
            return true;
        }
        sender.sendMessage("\u00a7a\u00a7l=== Portal: " + portal.getName() + " ===");
        sender.sendMessage("\u00a77Status: " + (portal.isEnabled() ? "\u00a7aEnabled" : "\u00a7cDisabled"));
        sender.sendMessage("\u00a77Complete: " + (portal.isComplete() ? "\u00a7aYes" : "\u00a7cNo"));
        if (portal.getCreator() != null) {
            sender.sendMessage("\u00a77Creator: " + portal.getCreator());
        }
        if (portal.getRegion() != null) {
            PortalRegion region = portal.getRegion();
            sender.sendMessage("\u00a77Region: " + region.getWorldName() + " (" + region.getMinX() + "," + region.getMinY() + "," + region.getMinZ() + ") to (" + region.getMaxX() + "," + region.getMaxY() + "," + region.getMaxZ() + ")");
            sender.sendMessage("\u00a77Volume: " + region.getVolume() + " blocks");
        } else {
            sender.sendMessage("\u00a77Region: \u00a7cNot set");
        }
        if (portal.getDestination() != null) {
            sender.sendMessage("\u00a77Destination: " + String.valueOf(portal.getDestination()));
        } else {
            sender.sendMessage("\u00a77Destination: \u00a7cNot set");
        }
        sender.sendMessage("\u00a77Permission: " + (portal.getPermission() != null ? portal.getPermission() : "\u00a77None"));
        sender.sendMessage("\u00a77Warmup: " + portal.getWarmupSeconds() + "s");
        sender.sendMessage("\u00a77Cooldown: " + portal.getCooldownSeconds() + "s");
        sender.sendMessage("\u00a77Uses: " + portal.getUseCount());
        return true;
    }

    private boolean handlePos1(CommandSender sender) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("\u00a7cOnly players can use this command.");
            return true;
        }
        if (!sender.hasPermission("worldmanager.portal.create")) {
            sender.sendMessage("\u00a7cYou don't have permission.");
            return true;
        }
        Player player = (Player)sender;
        Location loc = player.getLocation();
        this.wandListener.setFirstPosition(player, loc);
        return true;
    }

    private boolean handlePos2(CommandSender sender) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("\u00a7cOnly players can use this command.");
            return true;
        }
        if (!sender.hasPermission("worldmanager.portal.create")) {
            sender.sendMessage("\u00a7cYou don't have permission.");
            return true;
        }
        Player player = (Player)sender;
        Location loc = player.getLocation();
        this.wandListener.setSecondPosition(player, loc);
        return true;
    }

    private boolean handleWand(CommandSender sender) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("\u00a7cOnly players can use this command.");
            return true;
        }
        if (!sender.hasPermission("worldmanager.portal.create")) {
            sender.sendMessage("\u00a7cYou don't have permission.");
            return true;
        }
        Player player = (Player)sender;
        player.getInventory().addItem(new ItemStack[]{PortalWandListener.createWand()});
        player.sendMessage("\u00a7a\u00a7l[Portal] \u00a7aYou received the Portal Wand!");
        player.sendMessage("\u00a77Left Click: Set first position");
        player.sendMessage("\u00a77Right Click: Set second position");
        return true;
    }

    private boolean handleSetRegion(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("\u00a7cOnly players can use this command.");
            return true;
        }
        if (!sender.hasPermission("worldmanager.portal.create")) {
            sender.sendMessage("\u00a7cYou don't have permission.");
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage("\u00a7cUsage: /portal setregion <name>");
            return true;
        }
        Player player = (Player)sender;
        UUID uuid = player.getUniqueId();
        Location pos1 = this.wandListener.getFirstPosition(uuid);
        Location pos2 = this.wandListener.getSecondPosition(uuid);
        if (pos1 == null || pos2 == null) {
            sender.sendMessage("\u00a7cYou must set both positions first!");
            sender.sendMessage("\u00a77Get a wand with \u00a7a/portal wand \u00a77or use \u00a7a/portal pos1\u00a77/\u00a7apos2");
            return true;
        }
        if (!pos1.getWorld().equals((Object)pos2.getWorld())) {
            sender.sendMessage("\u00a7cBoth positions must be in the same world!");
            return true;
        }
        String name = args[1];
        Portal portal = this.portalService.getPortal(name);
        if (portal == null) {
            sender.sendMessage("\u00a7cPortal not found: " + name);
            return true;
        }
        PortalRegion region = new PortalRegion(pos1, pos2);
        List overlaps = this.portalService.getPortalsInWorld(region.getWorldName()).stream().filter(p -> p.getRegion() != null && !p.getName().equalsIgnoreCase(portal.getName())).filter(p -> p.getRegion().overlaps(region)).map(Portal::getName).collect(Collectors.toList());
        if (!overlaps.isEmpty()) {
            sender.sendMessage("\u00a7cRegion overlaps with existing portal(s): \u00a7e" + String.join((CharSequence)", ", overlaps));
            sender.sendMessage("\u00a77Adjust your selection or delete the conflicting portal(s).");
            return true;
        }
        portal.setRegion(region);
        this.portalService.scheduleSave();
        if (sender instanceof Player) {
            this.autoOrientIfNeeded((Player)sender, portal);
        }
        this.portalService.applyAppearance(portal);
        sender.sendMessage("\u00a7aSet region for portal: \u00a7b" + name);
        sender.sendMessage("\u00a77Volume: " + region.getVolume() + " blocks");
        return true;
    }

    private boolean handleSetDestination(CommandSender sender, String[] args) {
        if (!sender.hasPermission("worldmanager.portal.create")) {
            sender.sendMessage("\u00a7cYou don't have permission.");
            return true;
        }
        if (args.length < 3) {
            sender.sendMessage("\u00a7cUsage: /portal setdest <portal> <world|x y z world|portal:name>");
            return true;
        }
        String portalName = args[1];
        Portal portal = this.portalService.getPortal(portalName);
        if (portal == null) {
            sender.sendMessage("\u00a7cPortal not found: " + portalName);
            return true;
        }
        if (args[2].startsWith("portal:")) {
            String linkedPortalName = args[2].substring(7);
            Portal linkedPortal = this.portalService.getPortal(linkedPortalName);
            if (linkedPortal == null) {
                sender.sendMessage("\u00a7cLinked portal not found: " + linkedPortalName);
                return true;
            }
            if (linkedPortalName.equalsIgnoreCase(portal.getName())) {
                sender.sendMessage("\u00a7cCannot link a portal to itself.");
                return true;
            }
            String current = linkedPortal.getName();
            HashSet<String> visited = new HashSet<String>();
            int depth = 0;
            while (current != null && depth++ < 32) {
                if (!visited.add(current.toLowerCase())) {
                    sender.sendMessage("\u00a7cCircular link detected in existing chain involving: \u00a7e" + current);
                    return true;
                }
                if (current.equalsIgnoreCase(portal.getName())) {
                    sender.sendMessage("\u00a7cThis link would create a circular chain.");
                    return true;
                }
                Portal cp = this.portalService.getPortal(current);
                if (cp == null || cp.getDestination() == null || cp.getDestination().getType() != PortalDestination.Type.PORTAL) break;
                current = cp.getDestination().getLinkedPortalName();
            }
            portal.setDestination(PortalDestination.portal(linkedPortalName));
            sender.sendMessage("\u00a7aSet destination to portal: \u00a7b" + linkedPortalName);
        } else if (args.length == 3) {
            String worldName = args[2];
            World world = Bukkit.getWorld((String)worldName);
            if (world == null) {
                sender.sendMessage("\u00a7cWorld not found: " + worldName);
                return true;
            }
            portal.setDestination(PortalDestination.worldSpawn(worldName));
            sender.sendMessage("\u00a7aSet destination to world spawn: \u00a7b" + worldName);
        } else if (args.length >= 5) {
            try {
                double x = Double.parseDouble(args[2]);
                double y = Double.parseDouble(args[3]);
                double z = Double.parseDouble(args[4]);
                String worldName = args[5];
                World world = Bukkit.getWorld((String)worldName);
                if (world == null) {
                    sender.sendMessage("\u00a7cWorld not found: " + worldName);
                    return true;
                }
                float yaw = args.length > 6 ? Float.parseFloat(args[6]) : 0.0f;
                float pitch = args.length > 7 ? Float.parseFloat(args[7]) : 0.0f;
                Location loc = new Location(world, x, y, z, yaw, pitch);
                portal.setDestination(PortalDestination.location(loc));
                sender.sendMessage("\u00a7aSet destination to coordinates in " + worldName);
            }
            catch (NumberFormatException e) {
                sender.sendMessage("\u00a7cInvalid coordinates!");
                return true;
            }
        } else {
            sender.sendMessage("\u00a7cUsage: /portal setdest <portal> <world|x y z world|portal:name>");
            return true;
        }
        this.portalService.scheduleSave();
        return true;
    }

    private boolean handleAppearance(CommandSender sender, String[] args) {
        if (!sender.hasPermission("worldmanager.portal.manage")) {
            sender.sendMessage("\u00a7cYou don't have permission.");
            return true;
        }
        if (args.length < 3) {
            sender.sendMessage("\u00a7cUsage: /portal appearance <portal> <none|particles|end|nether>");
            return true;
        }
        Portal portal = this.portalService.getPortal(args[1]);
        if (portal == null) {
            sender.sendMessage("\u00a7cPortal not found: " + args[1]);
            return true;
        }
        String type = args[2].toUpperCase();
        List<String> allowed = Arrays.asList("NONE", "PARTICLES", "END", "NETHER");
        if (!allowed.contains(type)) {
            sender.sendMessage("\u00a7cInvalid appearance type. Use: none, particles, end, nether");
            return true;
        }
        if ((type.equals("NONE") || type.equals("PARTICLES")) && portal.getRegion() != null) {
            this.portalService.clearPortalBlocks(portal.getRegion());
        }
        portal.setAppearanceType(type);
        if (type.equals("PARTICLES") && args.length >= 4) {
            try {
                Particle particle = Particle.valueOf((String)args[3].toUpperCase());
                portal.setAppearanceParticle(particle);
                if (args.length > 4) {
                    portal.setAppearanceParticleCount(Integer.parseInt(args[4]));
                }
                if (args.length > 5) {
                    portal.setAppearanceParticleSpreadX(Double.parseDouble(args[5]));
                }
                if (args.length > 6) {
                    portal.setAppearanceParticleSpreadY(Double.parseDouble(args[6]));
                }
                if (args.length > 7) {
                    portal.setAppearanceParticleSpreadZ(Double.parseDouble(args[7]));
                }
                if (args.length > 8) {
                    portal.setAppearanceParticleSpeed(Double.parseDouble(args[8]));
                }
                if (args.length > 9) {
                    portal.setAppearanceParticlePeriod(Integer.parseInt(args[9]));
                }
            }
            catch (IllegalArgumentException e) {
                sender.sendMessage("\u00a7eTip: /portal appearance <portal> particles <PARTICLE> [count] [spreadX] [spreadY] [spreadZ] [speed] [periodIntervals]");
                sender.sendMessage("\u00a77Period is in 2-second intervals (1=every 2s, 2=every 4s, etc.)");
            }
        }
        if (sender instanceof Player) {
            this.autoOrientIfNeeded((Player)sender, portal);
        }
        this.portalService.applyAppearance(portal);
        this.portalService.scheduleSave();
        sender.sendMessage("\u00a7aSet appearance for \u00a7b" + portal.getName() + " \u00a7ato \u00a7e" + type);
        if (type.equals("PARTICLES")) {
            sender.sendMessage("\u00a77Particles will periodically appear across the region.");
        }
        return true;
    }

    private void autoOrientIfNeeded(Player player, Portal portal) {
        if (portal.getRegion() == null) {
            return;
        }
        String plane = portal.getAppearancePlane();
        if (!"AUTO".equalsIgnoreCase(plane)) {
            return;
        }
        float yaw = player.getLocation().getYaw();
        double y = (yaw % 360.0f + 360.0f) % 360.0f;
        boolean alongZ = y < 45.0 || y >= 315.0 || y >= 135.0 && y < 225.0;
        portal.setAppearancePlane(alongZ ? "Z" : "X");
    }

    private boolean handleAppearancePlane(CommandSender sender, String[] args) {
        if (!sender.hasPermission("worldmanager.portal.manage")) {
            sender.sendMessage("\u00a7cYou don't have permission.");
            return true;
        }
        if (args.length < 3) {
            sender.sendMessage("\u00a7cUsage: /portal appearanceplane <portal> <auto|x|z|horizontal>");
            return true;
        }
        Portal portal = this.portalService.getPortal(args[1]);
        if (portal == null) {
            sender.sendMessage("\u00a7cPortal not found: " + args[1]);
            return true;
        }
        String plane = args[2].toUpperCase();
        List<String> planes = Arrays.asList("AUTO", "X", "Z", "HORIZONTAL");
        if (!planes.contains(plane)) {
            sender.sendMessage("\u00a7cInvalid plane. Use: auto, x, z, horizontal");
            return true;
        }
        if (portal.getAppearanceType().equalsIgnoreCase("NETHER") && plane.equals("HORIZONTAL")) {
            sender.sendMessage("\u00a7eNote: Nether portal cannot be horizontal. Using X/Z plane.");
        }
        portal.setAppearancePlane(plane);
        if ("AUTO".equalsIgnoreCase(plane) && sender instanceof Player) {
            this.autoOrientIfNeeded((Player)sender, portal);
        }
        if (portal.getAppearanceType().equalsIgnoreCase("NETHER") || portal.getAppearanceType().equalsIgnoreCase("END")) {
            this.portalService.applyAppearance(portal);
        }
        this.portalService.scheduleSave();
        sender.sendMessage("\u00a7aSet appearance plane for \u00a7b" + portal.getName() + " \u00a7ato \u00a7e" + plane);
        return true;
    }

    private boolean handleParticles(CommandSender sender, String[] args) {
        if (!sender.hasPermission("worldmanager.portal.manage")) {
            sender.sendMessage("\u00a7cYou don't have permission.");
            return true;
        }
        if (args.length < 3) {
            sender.sendMessage("\u00a7cUsage: /portal particles <portal> <PARTICLE> [count] [spreadX] [spreadY] [spreadZ] [speed] [periodIntervals]");
            sender.sendMessage("\u00a77Period is in 2-second intervals (1=every 2s, 2=every 4s, etc.)");
            return true;
        }
        Portal portal = this.portalService.getPortal(args[1]);
        if (portal == null) {
            sender.sendMessage("\u00a7cPortal not found: " + args[1]);
            return true;
        }
        try {
            Particle particle = Particle.valueOf((String)args[2].toUpperCase());
            portal.setAppearanceParticle(particle);
            if (args.length > 3) {
                portal.setAppearanceParticleCount(Integer.parseInt(args[3]));
            }
            if (args.length > 4) {
                portal.setAppearanceParticleSpreadX(Double.parseDouble(args[4]));
            }
            if (args.length > 5) {
                portal.setAppearanceParticleSpreadY(Double.parseDouble(args[5]));
            }
            if (args.length > 6) {
                portal.setAppearanceParticleSpreadZ(Double.parseDouble(args[6]));
            }
            if (args.length > 7) {
                portal.setAppearanceParticleSpeed(Double.parseDouble(args[7]));
            }
            if (args.length > 8) {
                portal.setAppearanceParticlePeriod(Integer.parseInt(args[8]));
            }
            this.portalService.scheduleSave();
            sender.sendMessage("\u00a7aUpdated particles for \u00a7b" + portal.getName() + "\u00a77: \u00a7e" + particle.name());
            sender.sendMessage("\u00a77Period: " + portal.getAppearanceParticlePeriod() + " intervals (" + portal.getAppearanceParticlePeriod() * 2 + " seconds)");
            sender.sendMessage("\u00a77Tip: set appearance to 'particles' with \u00a7a/portal appearance " + portal.getName() + " particles");
        }
        catch (IllegalArgumentException e) {
            sender.sendMessage("\u00a7cInvalid particle or numbers. Example: /portal particles <portal> END_ROD 50 1 2 1 0.05 20");
        }
        return true;
    }

    private boolean handleEnable(CommandSender sender, String[] args) {
        if (!sender.hasPermission("worldmanager.portal.manage")) {
            sender.sendMessage("\u00a7cYou don't have permission.");
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage("\u00a7cUsage: /portal enable <name>");
            return true;
        }
        Portal portal = this.portalService.getPortal(args[1]);
        if (portal == null) {
            sender.sendMessage("\u00a7cPortal not found: " + args[1]);
            return true;
        }
        portal.setEnabled(true);
        this.portalService.scheduleSave();
        sender.sendMessage("\u00a7aEnabled portal: \u00a7b" + portal.getName());
        return true;
    }

    private boolean handleDisable(CommandSender sender, String[] args) {
        if (!sender.hasPermission("worldmanager.portal.manage")) {
            sender.sendMessage("\u00a7cYou don't have permission.");
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage("\u00a7cUsage: /portal disable <name>");
            return true;
        }
        Portal portal = this.portalService.getPortal(args[1]);
        if (portal == null) {
            sender.sendMessage("\u00a7cPortal not found: " + args[1]);
            return true;
        }
        portal.setEnabled(false);
        this.portalService.scheduleSave();
        sender.sendMessage("\u00a7cDisabled portal: \u00a7b" + portal.getName());
        return true;
    }

    private boolean handlePermission(CommandSender sender, String[] args) {
        if (!sender.hasPermission("worldmanager.portal.manage")) {
            sender.sendMessage("\u00a7cYou don't have permission.");
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage("\u00a7cUsage: /portal permission <portal> [permission|none]");
            return true;
        }
        Portal portal = this.portalService.getPortal(args[1]);
        if (portal == null) {
            sender.sendMessage("\u00a7cPortal not found: " + args[1]);
            return true;
        }
        if (args.length == 2) {
            String perm = portal.getPermission();
            sender.sendMessage("\u00a77Permission for " + portal.getName() + ": " + (perm != null ? perm : "\u00a77None"));
            return true;
        }
        String permission = args[2].equalsIgnoreCase("none") ? null : args[2];
        portal.setPermission(permission);
        this.portalService.scheduleSave();
        if (permission != null) {
            sender.sendMessage("\u00a7aSet permission for portal: \u00a7b" + permission);
        } else {
            sender.sendMessage("\u00a7aRemoved permission requirement for portal");
        }
        return true;
    }

    private boolean handleWarmup(CommandSender sender, String[] args) {
        return this.handleTimeSetting(sender, args, "warmup", Portal::setWarmupSeconds);
    }

    private boolean handleCooldown(CommandSender sender, String[] args) {
        return this.handleTimeSetting(sender, args, "cooldown", Portal::setCooldownSeconds);
    }

    private boolean handleTimeSetting(CommandSender sender, String[] args, String settingName, BiConsumer<Portal, Integer> setter) {
        if (!sender.hasPermission("worldmanager.portal.manage")) {
            sender.sendMessage("\u00a7cYou don't have permission.");
            return true;
        }
        if (args.length < 3) {
            sender.sendMessage("\u00a7cUsage: /portal " + settingName + " <portal> <seconds>");
            return true;
        }
        Portal portal = this.portalService.getPortal(args[1]);
        if (portal == null) {
            sender.sendMessage("\u00a7cPortal not found: " + args[1]);
            return true;
        }
        try {
            int seconds = Integer.parseInt(args[2]);
            setter.accept(portal, seconds);
            this.portalService.scheduleSave();
            sender.sendMessage("\u00a7aSet " + settingName + " to " + seconds + "s for portal: \u00a7b" + portal.getName());
        }
        catch (NumberFormatException e) {
            sender.sendMessage("\u00a7cInvalid number: " + args[2]);
        }
        return true;
    }

    private boolean handleEffects(CommandSender sender, String[] args) {
        if (!sender.hasPermission("worldmanager.portal.manage")) {
            sender.sendMessage("\u00a7cYou don't have permission.");
            return true;
        }
        if (args.length < 4) {
            sender.sendMessage("\u00a7cUsage: /portal effects <portal> <particle|sound> <type|on|off>");
            return true;
        }
        Portal portal = this.portalService.getPortal(args[1]);
        if (portal == null) {
            sender.sendMessage("\u00a7cPortal not found: " + args[1]);
            return true;
        }
        String effectType = args[2].toLowerCase();
        String value = args[3];
        if (effectType.equals("particle")) {
            if (value.equalsIgnoreCase("on")) {
                portal.setShowParticles(true);
                sender.sendMessage("\u00a7aEnabled particles for portal");
            } else if (value.equalsIgnoreCase("off")) {
                portal.setShowParticles(false);
                sender.sendMessage("\u00a7cDisabled particles for portal");
            } else {
                try {
                    Particle particle = Particle.valueOf((String)value.toUpperCase());
                    portal.setParticle(particle);
                    sender.sendMessage("\u00a7aSet particle effect to: " + particle.name());
                }
                catch (IllegalArgumentException e) {
                    sender.sendMessage("\u00a7cInvalid particle type: " + value);
                    return true;
                }
            }
        } else if (effectType.equals("sound")) {
            if (value.equalsIgnoreCase("on")) {
                portal.setPlaySound(true);
                sender.sendMessage("\u00a7aEnabled sound for portal");
            } else if (value.equalsIgnoreCase("off")) {
                portal.setPlaySound(false);
                sender.sendMessage("\u00a7cDisabled sound for portal");
            } else {
                try {
                    Sound sound = Sound.valueOf((String)value.toUpperCase());
                    portal.setSound(sound);
                    sender.sendMessage("\u00a7aSet sound effect to: " + sound.name());
                }
                catch (IllegalArgumentException e) {
                    sender.sendMessage("\u00a7cInvalid sound type: " + value);
                    return true;
                }
            }
        } else {
            sender.sendMessage("\u00a7cUnknown effect type. Use 'particle' or 'sound'");
            return true;
        }
        this.portalService.scheduleSave();
        return true;
    }

    private boolean handleNearby(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("\u00a7cOnly players can use this command.");
            return true;
        }
        if (!sender.hasPermission("worldmanager.portal.list")) {
            sender.sendMessage("\u00a7cYou don't have permission.");
            return true;
        }
        Player player = (Player)sender;
        Location loc = player.getLocation();
        double radius = 15.0;
        if (args.length >= 2) {
            try {
                radius = Double.parseDouble(args[1]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        double searchRadius = radius;
        List nearby = this.portalService.getAllPortals().stream().filter(p -> p.getRegion() != null && p.getRegion().getWorldName().equalsIgnoreCase(loc.getWorld().getName())).filter(p -> {
            PortalRegion r = p.getRegion();
            if (r.contains(loc)) {
                return true;
            }
            Location c = r.getCenter();
            return c != null && c.distance(loc) <= searchRadius;
        }).sorted(Comparator.comparingDouble(p -> {
            Location c = p.getRegion().getCenter();
            return c != null ? c.distance(loc) : Double.MAX_VALUE;
        })).collect(Collectors.toList());
        if (nearby.isEmpty()) {
            sender.sendMessage("\u00a77No nearby portals within \u00a7e" + (int)radius + "\u00a77 blocks.");
            return true;
        }
        sender.sendMessage("\u00a7a\u00a7lNearby Portals (<= " + (int)radius + "):");
        for (Portal p2 : nearby) {
            Location c = p2.getRegion().getCenter();
            double d = c != null ? c.distance(loc) : 0.0;
            String enabled = p2.isEnabled() ? "\u00a7aEnabled" : "\u00a7cDisabled";
            sender.sendMessage("\u00a7b" + p2.getName() + " \u00a77- " + enabled + " \u00a77(\u00a7e" + String.format("%.1f", d) + "m\u00a77)");
        }
        sender.sendMessage("\u00a77Use \u00a7a/portal delete <name> \u00a77or \u00a7a/portal deletehere <name>\u00a77 to remove.");
        return true;
    }

    private boolean handleDeleteHere(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("\u00a7cOnly players can use this command.");
            return true;
        }
        if (!sender.hasPermission("worldmanager.portal.delete")) {
            sender.sendMessage("\u00a7cYou don't have permission.");
            return true;
        }
        Player player = (Player)sender;
        Location loc = player.getLocation();
        if (args.length >= 2 && !args[1].matches("^-?\\d+(\\.\\d+)?$")) {
            String name = args[1];
            return this.handleDelete(sender, new String[]{"delete", name});
        }
        double radius = 10.0;
        if (args.length >= 2) {
            try {
                radius = Double.parseDouble(args[1]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        double deleteRadius = radius;
        List containing = this.portalService.getAllPortals().stream().filter(p -> p.getRegion() != null && p.getRegion().getWorldName().equalsIgnoreCase(loc.getWorld().getName())).filter(p -> p.getRegion().contains(loc)).collect(Collectors.toList());
        if (containing.size() == 1) {
            String name = ((Portal)containing.get(0)).getName();
            boolean deleted = this.portalService.deletePortal(name);
            sender.sendMessage(deleted ? "\u00a7aDeleted portal: \u00a7b" + name : "\u00a7cFailed to delete portal: " + name);
            return true;
        }
        if (containing.size() > 1) {
            sender.sendMessage("\u00a7cYou are inside multiple portals. Specify a name:");
            for (Portal p2 : containing) {
                sender.sendMessage("\u00a77 - \u00a7b" + p2.getName());
            }
            return true;
        }
        List nearby = this.portalService.getAllPortals().stream().filter(p -> p.getRegion() != null && p.getRegion().getWorldName().equalsIgnoreCase(loc.getWorld().getName())).filter(p -> {
            Location c = p.getRegion().getCenter();
            return c != null && c.distance(loc) <= deleteRadius;
        }).sorted(Comparator.comparingDouble(p -> p.getRegion().getCenter().distance(loc))).collect(Collectors.toList());
        if (nearby.isEmpty()) {
            sender.sendMessage("\u00a77No portals found within \u00a7e" + (int)radius + "\u00a77 blocks.");
            return true;
        }
        if (nearby.size() == 1) {
            String name = ((Portal)nearby.get(0)).getName();
            boolean deleted = this.portalService.deletePortal(name);
            sender.sendMessage(deleted ? "\u00a7aDeleted portal: \u00a7b" + name : "\u00a7cFailed to delete portal: " + name);
            return true;
        }
        sender.sendMessage("\u00a7cMultiple nearby portals. Specify one:");
        for (Portal p3 : nearby) {
            sender.sendMessage("\u00a77 - \u00a7b" + p3.getName());
        }
        return true;
    }

    private boolean handleTeleport(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("\u00a7cOnly players can use this command.");
            return true;
        }
        if (!sender.hasPermission("worldmanager.portal.tp")) {
            sender.sendMessage("\u00a7cYou don't have permission.");
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage("\u00a7cUsage: /portal tp <name>");
            return true;
        }
        Player player = (Player)sender;
        Portal portal = this.portalService.getPortal(args[1]);
        if (portal == null) {
            sender.sendMessage("\u00a7cPortal not found: " + args[1]);
            return true;
        }
        this.portalService.teleportThroughPortal(player, portal);
        return true;
    }

    private boolean handleReload(CommandSender sender) {
        if (!sender.hasPermission("worldmanager.portal.reload")) {
            sender.sendMessage("\u00a7cYou don't have permission.");
            return true;
        }
        this.portalService.reloadPortals();
        sender.sendMessage("\u00a7aReloaded portals configuration.");
        return true;
    }

    private void sendHelp(CommandSender sender) {
        sender.sendMessage("\u00a7a\u00a7l=== WorldManager Portals ===");
        sender.sendMessage("\u00a7b/portal create <name> \u00a77- Create a new portal");
        sender.sendMessage("\u00a7b/portal delete <name> \u00a77- Delete a portal");
        sender.sendMessage("\u00a7b/portal list \u00a77- List all portals");
        sender.sendMessage("\u00a7b/portal info <name> \u00a77- View portal details");
        sender.sendMessage("\u00a7b/portal wand \u00a77- Get the portal selection wand");
        sender.sendMessage("\u00a7b/portal pos1 \u00a77- Set first position (your location)");
        sender.sendMessage("\u00a7b/portal pos2 \u00a77- Set second position (your location)");
        sender.sendMessage("\u00a7b/portal nearby [radius] \u00a77- List nearby portals");
        sender.sendMessage("\u00a7b/portal deletehere [name|radius] \u00a77- Delete portal at your feet or nearest");
        sender.sendMessage("\u00a7b/portal appearance <name> <type> \u00a77- Visualize region with blocks/particles");
        sender.sendMessage("   \u00a77For particles: \u00a7a/portal appearance <name> particles <PARTICLE> [count] [spreadX] [spreadY] [spreadZ] [speed] [period]");
        sender.sendMessage("   \u00a77Period is in 2-second intervals (1=every 2s, 2=every 4s)");
        sender.sendMessage("\u00a7b/portal appearanceplane <name> <auto|x|z|horizontal> \u00a77- Orientation for END/NETHER visuals");
        sender.sendMessage("\u00a7b/portal particles <name> <type> [args] \u00a77- Configure particle type and parameters");
        sender.sendMessage("\u00a7b/portal setregion <name> \u00a77- Set portal region");
        sender.sendMessage("\u00a7b/portal setdest <name> <dest> \u00a77- Set destination");
        sender.sendMessage("\u00a7b/portal enable/disable <name> \u00a77- Toggle portal");
        sender.sendMessage("\u00a7b/portal tp <name> \u00a77- Teleport through portal");
        sender.sendMessage("\u00a7b/portal reload \u00a77- Reload portal configuration");
        sender.sendMessage("\u00a77");
        sender.sendMessage("\u00a77Type \u00a7a/portal help \u00a77for detailed guide");
    }

    private void sendDetailedHelp(CommandSender sender) {
        sender.sendMessage("\u00a7a\u00a7l\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
        sender.sendMessage("\u00a7a\u00a7l    WorldManager Portal System");
        sender.sendMessage("\u00a7a\u00a7l\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
        sender.sendMessage("");
        sender.sendMessage("\u00a76\u00a7l\u258c \u00a7e\u00a7lQuick Start Guide");
        sender.sendMessage("\u00a771. \u00a7a/portal wand \u00a77- Get the selection wand");
        sender.sendMessage("\u00a772. \u00a77Left-click & right-click blocks to select region");
        sender.sendMessage("\u00a773. \u00a7a/portal create MyPortal \u00a77- Create portal");
        sender.sendMessage("\u00a774. \u00a7a/portal setregion MyPortal \u00a77- Apply your region");
        sender.sendMessage("\u00a775. \u00a7a/portal setdest MyPortal world_nether \u00a77- Set destination");
        sender.sendMessage("\u00a776. \u00a77Walk through your portal to teleport!");
        sender.sendMessage("");
        sender.sendMessage("\u00a76\u00a7l\u258c \u00a7e\u00a7lPortal Selection Methods");
        sender.sendMessage("\u00a7a\u00a7lMethod 1: Using the Wand (Recommended)");
        sender.sendMessage("  \u00a7a/portal wand \u00a77- Get a Portal Wand (Blaze Rod)");
        sender.sendMessage("  \u00a77\u2022 \u00a7eLeft Click \u00a77a block = Set first position");
        sender.sendMessage("  \u00a77\u2022 \u00a7bRight Click \u00a77a block = Set second position");
        sender.sendMessage("  \u00a77\u2022 Shows \u00a7eparticles \u00a77and \u00a7evolume info \u00a77automatically!");
        sender.sendMessage("");
        sender.sendMessage("\u00a7a\u00a7lMethod 2: Using Commands");
        sender.sendMessage("  \u00a7a/portal pos1 \u00a77- Set first position (your current location)");
        sender.sendMessage("  \u00a7a/portal pos2 \u00a77- Set second position (your current location)");
        sender.sendMessage("");
        sender.sendMessage("\u00a76\u00a7l\u258c \u00a7e\u00a7lBasic Commands");
        sender.sendMessage("  \u00a7a/portal create <name>");
        sender.sendMessage("    \u00a77Creates a new portal with the given name");
        sender.sendMessage("  \u00a7a/portal delete <name>");
        sender.sendMessage("    \u00a77Permanently removes a portal");
        sender.sendMessage("  \u00a7a/portal list");
        sender.sendMessage("    \u00a77Shows all portals with their status");
        sender.sendMessage("  \u00a7a/portal nearby [radius]");
        sender.sendMessage("    \u00a77Shows portals near your current position");
        sender.sendMessage("  \u00a7a/portal deletehere [name|radius]");
        sender.sendMessage("    \u00a77Deletes the portal you are in or nearest within radius");
        sender.sendMessage("  \u00a7a/portal appearance <name> <none|particles|end|nether>");
        sender.sendMessage("    \u00a77Visualize the portal region with blocks or particles");
        sender.sendMessage("  \u00a7a/portal info <name>");
        sender.sendMessage("    \u00a77Displays detailed portal information");
        sender.sendMessage("");
        sender.sendMessage("\u00a76\u00a7l\u258c \u00a7e\u00a7lSetting Destinations");
        sender.sendMessage("\u00a77Portals can teleport to 3 types of destinations:");
        sender.sendMessage("");
        sender.sendMessage("  \u00a7b1. World Spawn:");
        sender.sendMessage("    \u00a7a/portal setdest <portal> <world>");
        sender.sendMessage("    \u00a77Example: \u00a7e/portal setdest Hub world_nether");
        sender.sendMessage("");
        sender.sendMessage("  \u00a7b2. Specific Coordinates:");
        sender.sendMessage("    \u00a7a/portal setdest <portal> <x> <y> <z> <world>");
        sender.sendMessage("    \u00a77Example: \u00a7e/portal setdest Hub 100 64 -200 world");
        sender.sendMessage("    \u00a77Optional: Add yaw/pitch for view direction");
        sender.sendMessage("");
        sender.sendMessage("  \u00a7b3. Linked Portal:");
        sender.sendMessage("    \u00a7a/portal setdest <portal> portal:<name>");
        sender.sendMessage("    \u00a77Example: \u00a7e/portal setdest Hub portal:NetherSide");
        sender.sendMessage("    \u00a77Creates two-way portal connections!");
        sender.sendMessage("");
        sender.sendMessage("\u00a76\u00a7l\u258c \u00a7e\u00a7lPortal Settings");
        sender.sendMessage("  \u00a7a/portal enable <name> \u00a77/ \u00a7a/portal disable <name>");
        sender.sendMessage("    \u00a77Toggle portal on/off without deleting it");
        sender.sendMessage("  \u00a7a/portal permission <name> [permission|none]");
        sender.sendMessage("    \u00a77Require a permission to use the portal");
        sender.sendMessage("  \u00a7a/portal warmup <name> <seconds>");
        sender.sendMessage("    \u00a77Delay before teleport (player must stand still)");
        sender.sendMessage("  \u00a7a/portal cooldown <name> <seconds>");
        sender.sendMessage("    \u00a77Wait time between portal uses");
        sender.sendMessage("");
        sender.sendMessage("\u00a76\u00a7l\u258c \u00a7e\u00a7lVisual Effects");
        sender.sendMessage("  \u00a7a/portal effects <name> particle <type|on|off>");
        sender.sendMessage("    \u00a77Types: \u00a7ePORTAL, END_ROD, FLAME, ENCHANTMENT_TABLE");
        sender.sendMessage("  \u00a7a/portal effects <name> sound <type|on|off>");
        sender.sendMessage("    \u00a77Types: \u00a7eENTITY_ENDERMAN_TELEPORT, BLOCK_PORTAL_TRAVEL");
        sender.sendMessage("");
        sender.sendMessage("\u00a76\u00a7l\u258c \u00a7e\u00a7lUtility Commands");
        sender.sendMessage("  \u00a7a/portal tp <name>");
        sender.sendMessage("    \u00a77Teleport through a portal without walking into it");
        sender.sendMessage("  \u00a7a/portal reload");
        sender.sendMessage("    \u00a77Reload all portals from configuration");
        sender.sendMessage("");
        sender.sendMessage("\u00a76\u00a7l\u258c \u00a7e\u00a7lTips & Tricks");
        sender.sendMessage("  \u00a77\u2022 Make portals at least \u00a7e3x3x3 \u00a77blocks for easy entry");
        sender.sendMessage("  \u00a77\u2022 Use descriptive names: \u00a7eSpawnToNether \u00a77not \u00a7eportal1");
        sender.sendMessage("  \u00a77\u2022 The wand shows \u00a7eparticles \u00a77and \u00a7evolume info \u00a77in real-time");
        sender.sendMessage("  \u00a77\u2022 Players only teleport \u00a7eonce per entry \u00a77(no spam)");
        sender.sendMessage("  \u00a77\u2022 Movement cancels warmup - players must stand still");
        sender.sendMessage("  \u00a77\u2022 Link portals together for two-way connections");
        sender.sendMessage("  \u00a77\u2022 Use cooldowns (30-60s) to prevent spam");
        sender.sendMessage("  \u00a77\u2022 Set permissions for VIP/restricted portals");
        sender.sendMessage("");
        sender.sendMessage("\u00a76\u00a7l\u258c \u00a7e\u00a7lExample Workflow");
        sender.sendMessage("  \u00a771. \u00a7a/portal wand");
        sender.sendMessage("  \u00a772. \u00a77Left-click one corner, right-click opposite corner");
        sender.sendMessage("  \u00a773. \u00a7a/portal create NetherGate");
        sender.sendMessage("  \u00a774. \u00a7a/portal setregion NetherGate");
        sender.sendMessage("  \u00a775. \u00a7a/portal setdest NetherGate world_nether");
        sender.sendMessage("  \u00a776. \u00a7a/portal warmup NetherGate 3");
        sender.sendMessage("  \u00a777. \u00a7a/portal cooldown NetherGate 30");
        sender.sendMessage("  \u00a778. \u00a77Done! Walk through to test");
        sender.sendMessage("");
        sender.sendMessage("\u00a7a\u00a7l\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
        sender.sendMessage("\u00a77For more help, visit: \u00a7b/portal \u00a77or check the wiki");
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        String input;
        ArrayList<String> completions = new ArrayList<String>();
        String string = input = args.length > 0 ? args[args.length - 1].toLowerCase() : "";
        if (args.length == 1) {
            List<String> subcommands = Arrays.asList("create", "delete", "list", "info", "setregion", "setdest", "pos1", "pos2", "wand", "nearby", "deletehere", "appearance", "appearanceplane", "particles", "enable", "disable", "permission", "warmup", "cooldown", "effects", "tp", "reload", "help");
            for (String s2 : subcommands) {
                if (!s2.startsWith(input)) continue;
                completions.add(s2);
            }
            return completions;
        }
        String subCmd = args[0].toLowerCase();
        if (args.length == 2) {
            if (Arrays.asList("delete", "remove", "info", "setregion", "setdest", "destination", "enable", "disable", "permission", "warmup", "cooldown", "effects", "tp", "teleport", "deletehere", "appearance", "appearanceplane", "particles").contains(subCmd)) {
                return this.portalService.getAllPortals().stream().map(Portal::getName).filter(name -> name.toLowerCase().startsWith(input)).collect(Collectors.toList());
            }
            if (subCmd.equals("nearby") || subCmd.equals("deletehere")) {
                return Arrays.asList("5", "10", "15", "25", "50").stream().filter(s -> s.startsWith(input)).collect(Collectors.toList());
            }
        }
        if (args.length == 3) {
            if (subCmd.equals("setdest") || subCmd.equals("destination")) {
                ArrayList<String> out = new ArrayList<String>();
                out.add("portal:");
                for (World w : Bukkit.getWorlds()) {
                    String wn = w.getName();
                    if (!wn.toLowerCase().startsWith(input)) continue;
                    out.add(wn);
                }
                return out;
            }
            if (subCmd.equals("appearance")) {
                return Arrays.asList("none", "particles", "end", "nether").stream().filter(s -> s.startsWith(input)).collect(Collectors.toList());
            }
            if (subCmd.equals("appearanceplane")) {
                return Arrays.asList("auto", "x", "z", "horizontal").stream().filter(s -> s.startsWith(input)).collect(Collectors.toList());
            }
            if (subCmd.equals("particles")) {
                return Arrays.asList("PORTAL", "END_ROD", "FLAME", "ENCHANTMENT_TABLE", "CRIT", "CAMPFIRE_SIGNAL_SMOKE").stream().filter(s -> s.toLowerCase().startsWith(input)).collect(Collectors.toList());
            }
            if (subCmd.equals("effects")) {
                return Arrays.asList("particle", "sound").stream().filter(s -> s.startsWith(input)).collect(Collectors.toList());
            }
        }
        if (args.length == 4) {
            if (subCmd.equals("appearance") && args.length >= 3 && "particles".equalsIgnoreCase(args[2])) {
                return Arrays.asList("PORTAL", "END_ROD", "FLAME", "ENCHANTMENT_TABLE", "CRIT", "CAMPFIRE_SIGNAL_SMOKE", "SOUL_FIRE_FLAME", "DRAGON_BREATH", "SPELL_WITCH").stream().filter(s -> s.toLowerCase().startsWith(input)).collect(Collectors.toList());
            }
            if (subCmd.equals("effects")) {
                String type = args[2].toLowerCase();
                if ("particle".equals(type)) {
                    return Arrays.asList("PORTAL", "END_ROD", "FLAME", "ENCHANTMENT_TABLE", "on", "off").stream().filter(s -> s.toLowerCase().startsWith(input)).collect(Collectors.toList());
                }
                if ("sound".equals(type)) {
                    return Arrays.asList("ENTITY_ENDERMAN_TELEPORT", "BLOCK_PORTAL_TRAVEL", "ENTITY_PLAYER_LEVELUP", "on", "off").stream().filter(s -> s.toLowerCase().startsWith(input)).collect(Collectors.toList());
                }
            }
        }
        if (args.length >= 5 && args.length <= 10 && subCmd.equals("appearance") && args.length >= 3 && "particles".equalsIgnoreCase(args[2])) {
            if (args.length == 5) {
                return Arrays.asList("20", "50", "80", "100");
            }
            if (args.length == 6) {
                return Arrays.asList("1.0", "1.5", "2.0");
            }
            if (args.length == 7) {
                return Arrays.asList("1.0", "1.5", "2.0");
            }
            if (args.length == 8) {
                return Arrays.asList("1.0", "1.5", "2.0");
            }
            if (args.length == 9) {
                return Arrays.asList("0.05", "0.1", "0.2");
            }
            if (args.length == 10) {
                return Arrays.asList("1", "2", "3", "5");
            }
        }
        return completions;
    }
}

