/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.worldManager.integration;

import java.util.Objects;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.texboobcat.worldManager.WorldManager;
import org.texboobcat.worldManager.model.ManagedWorld;

public class WorldManagerExpansion
extends PlaceholderExpansion {
    private final WorldManager plugin;

    public WorldManagerExpansion(WorldManager plugin) {
        this.plugin = plugin;
    }

    public boolean persist() {
        return true;
    }

    public boolean canRegister() {
        return true;
    }

    public String getIdentifier() {
        return "worldmanager";
    }

    public String getAuthor() {
        return String.join((CharSequence)", ", this.plugin.getDescription().getAuthors());
    }

    public String getVersion() {
        return this.plugin.getDescription().getVersion();
    }

    public String onRequest(OfflinePlayer offlinePlayer, String params) {
        String[] parts;
        if (params == null) {
            return "";
        }
        Player p = offlinePlayer != null ? offlinePlayer.getPlayer() : null;
        switch (params.toLowerCase()) {
            case "current_world": {
                if (p == null) {
                    return "";
                }
                return p.getWorld().getName();
            }
            case "current_world_alias": {
                if (p == null) {
                    return "";
                }
                ManagedWorld mw = this.plugin.getRegistry().get(p.getWorld().getName());
                return mw != null && mw.getAlias() != null ? mw.getAlias() : p.getWorld().getName();
            }
            case "current_world_players": {
                if (p == null) {
                    return "0";
                }
                return Integer.toString(p.getWorld().getPlayers().size());
            }
            case "current_world_environment": {
                if (p == null) {
                    return "";
                }
                return p.getWorld().getEnvironment().name();
            }
            case "current_world_is_favorite": {
                if (p == null) {
                    return "false";
                }
                return Boolean.toString(this.plugin.getFavorites(p.getUniqueId()).contains(p.getWorld().getName()));
            }
            case "current_world_pvp": {
                if (p == null) {
                    return "";
                }
                ManagedWorld mw = this.plugin.getRegistry().get(p.getWorld().getName());
                return mw != null && mw.getPvp() != null ? String.valueOf(mw.getPvp()) : "";
            }
            case "current_world_difficulty": {
                if (p == null) {
                    return "";
                }
                ManagedWorld mw = this.plugin.getRegistry().get(p.getWorld().getName());
                return mw != null && mw.getDifficulty() != null ? mw.getDifficulty().name() : "";
            }
            case "current_world_lock_time": {
                if (p == null) {
                    return "";
                }
                ManagedWorld mw = this.plugin.getRegistry().get(p.getWorld().getName());
                return mw != null && mw.getLockTime() != null ? String.valueOf(mw.getLockTime()) : "";
            }
            case "current_world_lock_weather": {
                if (p == null) {
                    return "";
                }
                ManagedWorld mw = this.plugin.getRegistry().get(p.getWorld().getName());
                return mw != null && mw.getLockWeather() != null ? String.valueOf(mw.getLockWeather()) : "";
            }
            case "player_last_world": {
                if (p == null) {
                    return "";
                }
                Location loc = this.plugin.getLastLocation().get(p.getUniqueId());
                World w = loc != null ? loc.getWorld() : null;
                return w != null ? w.getName() : "";
            }
            case "player_cooldown_seconds": {
                if (p == null) {
                    return "0";
                }
                long now = System.currentTimeMillis();
                Long last = this.plugin.getLastTeleportAt().get(p.getUniqueId());
                int cooldown = this.plugin.getConfig().getInt("options.tp_cooldown_seconds", 0);
                if (last == null || cooldown <= 0) {
                    return "0";
                }
                long remaining = (last + (long)cooldown * 1000L - now + 999L) / 1000L;
                return String.valueOf(Math.max(0L, remaining));
            }
            case "tp_warmup_seconds": {
                int warm = this.plugin.getConfig().getInt("options.tp_warmup_seconds", 0);
                return String.valueOf(Math.max(0, warm));
            }
        }
        if (params.startsWith("world_") && (parts = params.split("_", 3)).length == 3) {
            World w;
            String worldName = parts[1];
            String field = parts[2];
            ManagedWorld mw = this.plugin.getRegistry().get(worldName);
            if (mw == null && (w = Bukkit.getWorld((String)worldName)) != null) {
                mw = this.plugin.getRegistry().ensure(w.getName());
            }
            World bw = Bukkit.getWorld((String)worldName);
            if (mw == null && bw == null) {
                return "";
            }
            switch (field.toLowerCase()) {
                case "alias": {
                    return Objects.toString(mw.getAlias(), "");
                }
                case "pvp": {
                    return mw.getPvp() == null ? "" : String.valueOf(mw.getPvp());
                }
                case "difficulty": {
                    return mw.getDifficulty() == null ? "" : mw.getDifficulty().name();
                }
                case "lock_time": {
                    return mw.getLockTime() == null ? "" : String.valueOf(mw.getLockTime());
                }
                case "time": {
                    return mw.getTime() == null ? "" : String.valueOf(mw.getTime());
                }
                case "lock_weather": {
                    return mw.getLockWeather() == null ? "" : String.valueOf(mw.getLockWeather());
                }
                case "weather": {
                    return mw.getWeather() == null ? "" : mw.getWeather();
                }
                case "players": {
                    return bw == null ? "0" : Integer.toString(bw.getPlayers().size());
                }
                case "environment": {
                    return bw == null ? "" : bw.getEnvironment().name();
                }
                case "is_favorite": {
                    if (p == null) {
                        return "false";
                    }
                    return Boolean.toString(this.plugin.getFavorites(p.getUniqueId()).contains(worldName));
                }
            }
        }
        return "";
    }
}

