/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.worldManager.listener;

import java.io.File;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.generator.WorldInfo;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.texboobcat.worldManager.WorldManager;
import org.texboobcat.worldManager.gui.WorldSelectorGUI;

public class GuiListener
implements Listener {
    private final WorldManager plugin;

    public GuiListener(WorldManager plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (event.getView() == null) {
            return;
        }
        String title = event.getView().getTitle();
        if (!WorldSelectorGUI.TITLE.equals(title)) {
            return;
        }
        event.setCancelled(true);
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        ItemStack item = event.getCurrentItem();
        int raw = event.getRawSlot();
        if (raw < 0) {
            return;
        }
        if (raw >= 45 && raw < 54) {
            if (raw == 46) {
                this.plugin.setGuiMode(player.getUniqueId(), WorldManager.GuiMode.LOADED);
                this.plugin.setGuiPage(player.getUniqueId(), 0);
                player.openInventory(WorldSelectorGUI.build(player, this.plugin));
                return;
            }
            if (raw == 50) {
                this.plugin.setGuiMode(player.getUniqueId(), WorldManager.GuiMode.LOADABLES);
                this.plugin.setGuiPage(player.getUniqueId(), 0);
                player.openInventory(WorldSelectorGUI.build(player, this.plugin));
                return;
            }
            if (raw == 51) {
                this.plugin.setGuiMode(player.getUniqueId(), WorldManager.GuiMode.CREATE_ENV);
                this.plugin.setGuiPage(player.getUniqueId(), 0);
                player.openInventory(WorldSelectorGUI.build(player, this.plugin));
                return;
            }
            switch (raw) {
                case 45: {
                    if (this.plugin.getGuiPage(player.getUniqueId()) > 0) {
                        this.plugin.setGuiPage(player.getUniqueId(), this.plugin.getGuiPage(player.getUniqueId()) - 1);
                        player.openInventory(WorldSelectorGUI.build(player, this.plugin));
                    }
                    return;
                }
                case 48: {
                    player.closeInventory();
                    return;
                }
                case 49: {
                    if (this.plugin.getGuiMode(player.getUniqueId()) == WorldManager.GuiMode.LOADED) {
                        boolean favOnly = this.plugin.isGuiFavOnly(player.getUniqueId());
                        this.plugin.setGuiFavOnly(player.getUniqueId(), !favOnly);
                        this.plugin.setGuiPage(player.getUniqueId(), 0);
                        player.openInventory(WorldSelectorGUI.build(player, this.plugin));
                    }
                    return;
                }
                case 53: {
                    boolean hasNext;
                    int total;
                    WorldManager.GuiMode mode = this.plugin.getGuiMode(player.getUniqueId());
                    if (mode == WorldManager.GuiMode.LOADED) {
                        boolean favOnlyNow = this.plugin.isGuiFavOnly(player.getUniqueId());
                        Set<String> favs = this.plugin.getFavorites(player.getUniqueId());
                        List all = Bukkit.getWorlds();
                        total = favOnlyNow ? (int)all.stream().filter(w -> favs.contains(w.getName())).count() : all.size();
                    } else if (mode == WorldManager.GuiMode.LOADABLES) {
                        File container = Bukkit.getWorldContainer();
                        String[] entries = container.list((dir, name) -> new File(dir, name).isDirectory());
                        List<String> loadedNames = Bukkit.getWorlds().stream().map(WorldInfo::getName).toList();
                        int cnt = 0;
                        if (entries != null) {
                            for (String name2 : entries) {
                                if (loadedNames.contains(name2)) continue;
                                ++cnt;
                            }
                        }
                        total = cnt;
                    } else {
                        total = 3;
                    }
                    int perPage = 45;
                    int current = this.plugin.getGuiPage(player.getUniqueId());
                    boolean bl = hasNext = (current + 1) * perPage < total;
                    if (hasNext) {
                        this.plugin.setGuiPage(player.getUniqueId(), current + 1);
                        player.openInventory(WorldSelectorGUI.build(player, this.plugin));
                    }
                    return;
                }
            }
            return;
        }
        if (item == null) {
            return;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null || !meta.hasDisplayName()) {
            return;
        }
        String display = ChatColor.stripColor((String)meta.getDisplayName());
        WorldManager.GuiMode mode = this.plugin.getGuiMode(player.getUniqueId());
        if (mode == WorldManager.GuiMode.LOADED) {
            String name3 = display.startsWith("\u2605 ") ? display.substring(2).trim() : display;
            World world = Bukkit.getWorld((String)name3);
            if (world == null) {
                return;
            }
            if (event.getClick() != null && event.getClick().isRightClick()) {
                Set<String> favs = this.plugin.getFavorites(player.getUniqueId());
                if (favs.contains(name3)) {
                    favs.remove(name3);
                    player.sendMessage(this.plugin.getConfig().getString("messages.fav_removed", "Removed %world% from favorites").replace("%world%", name3));
                } else {
                    favs.add(name3);
                    player.sendMessage(this.plugin.getConfig().getString("messages.fav_added", "Added %world% to favorites").replace("%world%", name3));
                }
                player.openInventory(WorldSelectorGUI.build(player, this.plugin));
                return;
            }
            boolean can = this.plugin.canAccessWorld(player, name3);
            if (!can) {
                player.sendMessage(this.plugin.getConfig().getString("messages.no_world_access", "You don't have access to this world.").replace("%world%", name3));
                return;
            }
            player.closeInventory();
            player.performCommand("world tp " + name3);
        } else if (mode == WorldManager.GuiMode.LOADABLES) {
            String folder = display;
            player.closeInventory();
            player.performCommand("world import " + folder + " NORMAL");
        } else if (mode == WorldManager.GuiMode.CREATE_ENV) {
            World.Environment env = null;
            String d = display.toLowerCase(Locale.ROOT);
            if (d.contains("normal")) {
                env = World.Environment.NORMAL;
            } else if (d.contains("nether")) {
                env = World.Environment.NETHER;
            } else if (d.contains("end")) {
                env = World.Environment.THE_END;
            }
            if (env == null) {
                return;
            }
            WorldManager.PendingCreate pc = new WorldManager.PendingCreate();
            pc.env = env;
            pc.seed = null;
            pc.structures = null;
            pc.generator = null;
            pc.type = null;
            pc.expiresAt = System.currentTimeMillis() + 60000L;
            pc.stage = WorldManager.PendingCreate.Stage.NONE;
            this.plugin.setPendingCreate(player.getUniqueId(), pc);
            this.plugin.setGuiMode(player.getUniqueId(), WorldManager.GuiMode.CREATE_OPTIONS);
            player.openInventory(WorldSelectorGUI.build(player, this.plugin));
        } else if (mode == WorldManager.GuiMode.CREATE_OPTIONS) {
            WorldManager.PendingCreate pc = this.plugin.getPendingCreate(player.getUniqueId());
            if (pc == null) {
                return;
            }
            String name4 = ChatColor.stripColor((String)meta.getDisplayName());
            String lowered = name4.toLowerCase(Locale.ROOT);
            if (lowered.contains("back to environment")) {
                this.plugin.setGuiMode(player.getUniqueId(), WorldManager.GuiMode.CREATE_ENV);
                player.openInventory(WorldSelectorGUI.build(player, this.plugin));
                return;
            }
            if (lowered.startsWith("structures:")) {
                pc.structures = event.getClick() != null && event.getClick().isShiftClick() ? null : Boolean.valueOf(pc.structures == null ? Boolean.TRUE : pc.structures == false);
                this.plugin.setPendingCreate(player.getUniqueId(), pc);
                player.openInventory(WorldSelectorGUI.build(player, this.plugin));
                return;
            }
            if (lowered.startsWith("type:")) {
                if (event.getClick() != null && event.getClick().isShiftClick()) {
                    pc.type = null;
                } else {
                    String[] types = new String[]{"FLAT", "AMPLIFIED", "LARGE_BIOMES"};
                    String cur = pc.type;
                    int idx = -1;
                    if (cur != null) {
                        for (int i = 0; i < types.length; ++i) {
                            if (!types[i].equalsIgnoreCase(cur)) continue;
                            idx = i;
                            break;
                        }
                    }
                    pc.type = types[(idx + 1) % types.length];
                }
                this.plugin.setPendingCreate(player.getUniqueId(), pc);
                player.openInventory(WorldSelectorGUI.build(player, this.plugin));
                return;
            }
            if (lowered.startsWith("generator:")) {
                pc.stage = WorldManager.PendingCreate.Stage.GENERATOR;
                this.plugin.setPendingCreate(player.getUniqueId(), pc);
                player.closeInventory();
                player.sendMessage("\u00a77Type generator name in chat (blank to clear), within 60 seconds...");
                return;
            }
            if (lowered.startsWith("seed:")) {
                pc.stage = WorldManager.PendingCreate.Stage.SEED;
                this.plugin.setPendingCreate(player.getUniqueId(), pc);
                player.closeInventory();
                player.sendMessage("\u00a77Type numeric seed in chat (blank to clear), within 60 seconds...");
                return;
            }
            if (lowered.contains("enter world name")) {
                pc.stage = WorldManager.PendingCreate.Stage.NAME;
                this.plugin.setPendingCreate(player.getUniqueId(), pc);
                player.closeInventory();
                player.sendMessage("\u00a77Type the world name in chat within 60 seconds...");
                return;
            }
        }
    }
}

