/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.worldManager.listener;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.texboobcat.worldManager.WorldManager;
import org.texboobcat.worldManager.model.Portal;
import org.texboobcat.worldManager.service.WorldManagerPortalService;

public class PortalListener
implements Listener {
    private final WorldManager plugin;
    private final WorldManagerPortalService portalService;
    private final Map<UUID, String> playersInPortals = new ConcurrentHashMap<UUID, String>();

    public PortalListener(WorldManager plugin, WorldManagerPortalService portalService) {
        this.plugin = plugin;
        this.portalService = portalService;
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerMove(PlayerMoveEvent event) {
        Portal portal;
        if (event.getFrom().getBlockX() == event.getTo().getBlockX() && event.getFrom().getBlockY() == event.getTo().getBlockY() && event.getFrom().getBlockZ() == event.getTo().getBlockZ()) {
            return;
        }
        Player player = event.getPlayer();
        UUID playerUUID = player.getUniqueId();
        if (this.portalService.hasPendingTeleport(playerUUID)) {
            this.portalService.cancelPendingTeleport(playerUUID);
        }
        if ((portal = this.portalService.getPortalAt(event.getTo())) != null) {
            String currentPortal = this.playersInPortals.get(playerUUID);
            if (currentPortal == null || !currentPortal.equals(portal.getName())) {
                this.playersInPortals.put(playerUUID, portal.getName());
                this.portalService.teleportThroughPortal(player, portal).thenAccept(success -> {
                    if (!success.booleanValue()) {
                        this.playersInPortals.remove(playerUUID, portal.getName());
                    }
                });
            }
        } else {
            this.playersInPortals.remove(playerUUID);
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        UUID playerUUID = event.getPlayer().getUniqueId();
        this.playersInPortals.remove(playerUUID);
        this.portalService.cancelPendingTeleport(playerUUID);
    }
}

