/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.worldManager.listener;

import java.util.Arrays;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.texboobcat.worldManager.WorldManager;

public class PortalWandListener
implements Listener {
    private final WorldManager plugin;
    private final Map<UUID, Location> firstPositions = new ConcurrentHashMap<UUID, Location>();
    private final Map<UUID, Location> secondPositions = new ConcurrentHashMap<UUID, Location>();

    public PortalWandListener(WorldManager plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        ItemStack item = event.getItem();
        if (!PortalWandListener.isPortalWand(item)) {
            return;
        }
        if (!player.hasPermission("worldmanager.portal.create")) {
            return;
        }
        Action action = event.getAction();
        if (action == Action.LEFT_CLICK_BLOCK) {
            event.setCancelled(true);
            Location loc = event.getClickedBlock().getLocation();
            this.setFirstPosition(player, loc);
        } else if (action == Action.RIGHT_CLICK_BLOCK) {
            event.setCancelled(true);
            Location loc = event.getClickedBlock().getLocation();
            this.setSecondPosition(player, loc);
        }
    }

    public void setFirstPosition(Player player, Location location) {
        this.firstPositions.put(player.getUniqueId(), location.clone());
        player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_PLING, 1.0f, 2.0f);
        this.spawnSelectionParticles(location, Particle.HAPPY_VILLAGER);
        player.sendMessage("\u00a7a\u00a7l[Portal] \u00a7aFirst position set: \u00a77" + location.getBlockX() + ", " + location.getBlockY() + ", " + location.getBlockZ());
        Location secondPos = this.secondPositions.get(player.getUniqueId());
        if (secondPos != null && secondPos.getWorld().equals((Object)location.getWorld())) {
            this.showVolumeInfo(player, location, secondPos);
        }
    }

    public void setSecondPosition(Player player, Location location) {
        this.secondPositions.put(player.getUniqueId(), location.clone());
        player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_PLING, 1.0f, 1.5f);
        this.spawnSelectionParticles(location, Particle.HAPPY_VILLAGER);
        player.sendMessage("\u00a7b\u00a7l[Portal] \u00a7bSecond position set: \u00a77" + location.getBlockX() + ", " + location.getBlockY() + ", " + location.getBlockZ());
        Location firstPos = this.firstPositions.get(player.getUniqueId());
        if (firstPos != null && firstPos.getWorld().equals((Object)location.getWorld())) {
            this.showVolumeInfo(player, firstPos, location);
        }
    }

    public Location getFirstPosition(UUID playerUUID) {
        return this.firstPositions.get(playerUUID);
    }

    public Location getSecondPosition(UUID playerUUID) {
        return this.secondPositions.get(playerUUID);
    }

    public void clearPositions(UUID playerUUID) {
        this.firstPositions.remove(playerUUID);
        this.secondPositions.remove(playerUUID);
    }

    public boolean hasBothPositions(UUID playerUUID) {
        return this.firstPositions.containsKey(playerUUID) && this.secondPositions.containsKey(playerUUID);
    }

    private void spawnSelectionParticles(Location location, Particle particle) {
        Location center = location.clone().add(0.5, 0.5, 0.5);
        center.getWorld().spawnParticle(particle, center, 20, 0.3, 0.3, 0.3, 0.1);
    }

    private void showVolumeInfo(Player player, Location pos1, Location pos2) {
        int minX = Math.min(pos1.getBlockX(), pos2.getBlockX());
        int minY = Math.min(pos1.getBlockY(), pos2.getBlockY());
        int minZ = Math.min(pos1.getBlockZ(), pos2.getBlockZ());
        int maxX = Math.max(pos1.getBlockX(), pos2.getBlockX());
        int maxY = Math.max(pos1.getBlockY(), pos2.getBlockY());
        int maxZ = Math.max(pos1.getBlockZ(), pos2.getBlockZ());
        int volume = (maxX - minX + 1) * (maxY - minY + 1) * (maxZ - minZ + 1);
        int width = maxX - minX + 1;
        int height = maxY - minY + 1;
        int length = maxZ - minZ + 1;
        player.sendMessage("\u00a77\u00a7l[Portal] \u00a77Region: \u00a7e" + width + "x" + height + "x" + length + " \u00a77(\u00a7e" + volume + " blocks\u00a77)");
        player.sendMessage("\u00a77Use \u00a7a/portal setregion <name> \u00a77to apply this region to a portal");
    }

    public static boolean isPortalWand(ItemStack item) {
        if (item == null || item.getType() != Material.BLAZE_ROD) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null || !meta.hasDisplayName()) {
            return false;
        }
        return meta.getDisplayName().equals("\u00a76\u00a7lPortal Wand");
    }

    public static ItemStack createWand() {
        ItemStack wand = new ItemStack(Material.BLAZE_ROD);
        ItemMeta meta = wand.getItemMeta();
        if (meta != null) {
            meta.setDisplayName("\u00a76\u00a7lPortal Wand");
            meta.setLore(Arrays.asList("\u00a77Left Click: \u00a7aSet first position", "\u00a77Right Click: \u00a7bSet second position", "\u00a77", "\u00a77Use this wand to select portal regions", "\u00a77similar to WorldEdit's selection tool"));
            wand.setItemMeta(meta);
        }
        return wand;
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        UUID uuid = event.getPlayer().getUniqueId();
        this.firstPositions.remove(uuid);
        this.secondPositions.remove(uuid);
    }
}

