/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.worldManager.model;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Difficulty;
import org.bukkit.GameMode;
import org.bukkit.GameRule;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.WorldBorder;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.EntityType;

public class ManagedWorld {
    private final String name;
    private String alias;
    private GameMode gamemode;
    private Location spawn;
    private boolean keepSpawnLoaded;
    private final Set<EntityType> allowedMobs = new HashSet<EntityType>();
    private World.Environment environment;
    private Difficulty difficulty;
    private Boolean pvp;
    private Boolean lockTime;
    private Long time;
    private Boolean lockWeather;
    private String weather;
    private Boolean mobGriefing;
    private Boolean naturalRegen;
    private Boolean fireTick;
    private Boolean keepInventory;
    private Integer spawnRadius;
    private Integer randomTickSpeed;
    private Integer maxEntityCramming;
    private Double borderSize;
    private Location borderCenter;
    private String resourcePackUrl;
    private String resourcePackHash;
    private Boolean resourcePackRequired;

    public ManagedWorld(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public GameMode getGamemode() {
        return this.gamemode;
    }

    public void setGamemode(GameMode gamemode) {
        this.gamemode = gamemode;
    }

    public Difficulty getDifficulty() {
        return this.difficulty;
    }

    public void setDifficulty(Difficulty difficulty) {
        this.difficulty = difficulty;
    }

    public Boolean getPvp() {
        return this.pvp;
    }

    public void setPvp(Boolean pvp) {
        this.pvp = pvp;
    }

    public Boolean getLockTime() {
        return this.lockTime;
    }

    public void setLockTime(Boolean lockTime) {
        this.lockTime = lockTime;
    }

    public Long getTime() {
        return this.time;
    }

    public void setTime(Long time) {
        this.time = time;
    }

    public Boolean getLockWeather() {
        return this.lockWeather;
    }

    public void setLockWeather(Boolean lockWeather) {
        this.lockWeather = lockWeather;
    }

    public String getWeather() {
        return this.weather;
    }

    public void setWeather(String weather) {
        this.weather = weather;
    }

    public Boolean getMobGriefing() {
        return this.mobGriefing;
    }

    public void setMobGriefing(Boolean mobGriefing) {
        this.mobGriefing = mobGriefing;
    }

    public Boolean getNaturalRegen() {
        return this.naturalRegen;
    }

    public void setNaturalRegen(Boolean naturalRegen) {
        this.naturalRegen = naturalRegen;
    }

    public Boolean getFireTick() {
        return this.fireTick;
    }

    public void setFireTick(Boolean fireTick) {
        this.fireTick = fireTick;
    }

    public Boolean getKeepInventory() {
        return this.keepInventory;
    }

    public void setKeepInventory(Boolean keepInventory) {
        this.keepInventory = keepInventory;
    }

    public Integer getSpawnRadius() {
        return this.spawnRadius;
    }

    public void setSpawnRadius(Integer spawnRadius) {
        this.spawnRadius = spawnRadius;
    }

    public Integer getRandomTickSpeed() {
        return this.randomTickSpeed;
    }

    public void setRandomTickSpeed(Integer randomTickSpeed) {
        this.randomTickSpeed = randomTickSpeed;
    }

    public Integer getMaxEntityCramming() {
        return this.maxEntityCramming;
    }

    public void setMaxEntityCramming(Integer maxEntityCramming) {
        this.maxEntityCramming = maxEntityCramming;
    }

    public Location getSpawn() {
        return this.spawn;
    }

    public void setSpawn(Location spawn) {
        this.spawn = spawn;
    }

    public boolean isKeepSpawnLoaded() {
        return this.keepSpawnLoaded;
    }

    public void setKeepSpawnLoaded(boolean keepSpawnLoaded) {
        this.keepSpawnLoaded = keepSpawnLoaded;
    }

    public Set<EntityType> getAllowedMobs() {
        return this.allowedMobs;
    }

    public World.Environment getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(World.Environment environment) {
        this.environment = environment;
    }

    public Double getBorderSize() {
        return this.borderSize;
    }

    public void setBorderSize(Double borderSize) {
        this.borderSize = borderSize;
    }

    public Location getBorderCenter() {
        return this.borderCenter;
    }

    public void setBorderCenter(Location borderCenter) {
        this.borderCenter = borderCenter;
    }

    public String getResourcePackUrl() {
        return this.resourcePackUrl;
    }

    public void setResourcePackUrl(String resourcePackUrl) {
        this.resourcePackUrl = resourcePackUrl;
    }

    public String getResourcePackHash() {
        return this.resourcePackHash;
    }

    public void setResourcePackHash(String resourcePackHash) {
        this.resourcePackHash = resourcePackHash;
    }

    public Boolean isResourcePackRequired() {
        return this.resourcePackRequired;
    }

    public void setResourcePackRequired(Boolean resourcePackRequired) {
        this.resourcePackRequired = resourcePackRequired;
    }

    public void applyToWorldIfLoaded() {
        World world = Bukkit.getWorld((String)this.name);
        if (world == null) {
            return;
        }
        world.setKeepSpawnInMemory(this.keepSpawnLoaded);
        if (this.difficulty != null) {
            world.setDifficulty(this.difficulty);
        }
        if (this.pvp != null) {
            world.setPVP(this.pvp.booleanValue());
        }
        if (this.spawn != null) {
            if (this.spawn.getWorld() == null) {
                this.spawn.setWorld(world);
            }
            world.setSpawnLocation(this.spawn);
        }
        if (this.borderSize != null || this.borderCenter != null) {
            WorldBorder wb = world.getWorldBorder();
            if (this.borderSize != null) {
                wb.setSize(Math.max(1.0, this.borderSize));
            }
            if (this.borderCenter != null) {
                double cx = this.borderCenter.getX();
                double cz = this.borderCenter.getZ();
                wb.setCenter(cx, cz);
            }
        }
        if (this.lockTime != null) {
            world.setGameRule(GameRule.DO_DAYLIGHT_CYCLE, (Object)(this.lockTime == false ? 1 : 0));
        }
        if (this.time != null) {
            world.setFullTime(this.time.longValue());
        }
        if (this.lockWeather != null) {
            world.setGameRule(GameRule.DO_WEATHER_CYCLE, (Object)(this.lockWeather == false ? 1 : 0));
        }
        if (this.weather != null) {
            boolean storm = "RAIN".equalsIgnoreCase(this.weather) || "THUNDER".equalsIgnoreCase(this.weather);
            boolean thunder = "THUNDER".equalsIgnoreCase(this.weather);
            world.setStorm(storm);
            world.setThundering(thunder);
        }
        if (this.mobGriefing != null) {
            world.setGameRule(GameRule.MOB_GRIEFING, (Object)this.mobGriefing);
        }
        if (this.naturalRegen != null) {
            world.setGameRule(GameRule.NATURAL_REGENERATION, (Object)this.naturalRegen);
        }
        if (this.fireTick != null) {
            world.setGameRule(GameRule.DO_FIRE_TICK, (Object)this.fireTick);
        }
        if (this.keepInventory != null) {
            world.setGameRule(GameRule.KEEP_INVENTORY, (Object)this.keepInventory);
        }
        if (this.spawn != null && this.spawnRadius != null) {
            world.setGameRule(GameRule.SPAWN_RADIUS, (Object)Math.max(0, this.spawnRadius));
        }
        if (this.randomTickSpeed != null) {
            world.setGameRule(GameRule.RANDOM_TICK_SPEED, (Object)Math.max(0, this.randomTickSpeed));
        }
        if (this.maxEntityCramming != null) {
            world.setGameRule(GameRule.MAX_ENTITY_CRAMMING, (Object)Math.max(0, this.maxEntityCramming));
        }
    }

    public void save(ConfigurationSection sec) {
        sec.set("alias", (Object)this.alias);
        sec.set("gamemode", this.gamemode != null ? this.gamemode.name() : null);
        sec.set("environment", this.environment != null ? this.environment.name() : null);
        if (this.spawn != null) {
            sec.set("spawn.world", (Object)this.name);
            sec.set("spawn.x", (Object)this.spawn.getX());
            sec.set("spawn.y", (Object)this.spawn.getY());
            sec.set("spawn.z", (Object)this.spawn.getZ());
            sec.set("spawn.yaw", (Object)Float.valueOf(this.spawn.getYaw()));
            sec.set("spawn.pitch", (Object)Float.valueOf(this.spawn.getPitch()));
        } else {
            sec.set("spawn", null);
        }
        sec.set("keep-spawn-loaded", (Object)this.keepSpawnLoaded);
        sec.set("allowed-mobs", this.allowedMobs.stream().map(Enum::name).collect(Collectors.toList()));
        sec.set("difficulty", this.difficulty != null ? this.difficulty.name() : null);
        sec.set("pvp", (Object)this.pvp);
        sec.set("lock-time", (Object)this.lockTime);
        sec.set("time", (Object)this.time);
        sec.set("lock-weather", (Object)this.lockWeather);
        sec.set("weather", (Object)this.weather);
        sec.set("mob-griefing", (Object)this.mobGriefing);
        sec.set("natural-regen", (Object)this.naturalRegen);
        sec.set("fire-tick", (Object)this.fireTick);
        sec.set("keep-inventory", (Object)this.keepInventory);
        sec.set("spawn-protection", (Object)this.spawnRadius);
        sec.set("random-tick", (Object)this.randomTickSpeed);
        sec.set("max-entity-cramming", (Object)this.maxEntityCramming);
        sec.set("border.size", (Object)this.borderSize);
        if (this.borderCenter != null) {
            sec.set("border.center.world", (Object)this.name);
            sec.set("border.center.x", (Object)this.borderCenter.getX());
            sec.set("border.center.z", (Object)this.borderCenter.getZ());
        } else {
            sec.set("border.center", null);
        }
        sec.set("resource-pack.url", (Object)this.resourcePackUrl);
        sec.set("resource-pack.hash", (Object)this.resourcePackHash);
        sec.set("resource-pack.required", (Object)this.resourcePackRequired);
    }

    public static ManagedWorld load(String name, ConfigurationSection sec) {
        ConfigurationSection rp;
        ConfigurationSection b;
        String diff;
        String env;
        ManagedWorld mw = new ManagedWorld(name);
        mw.alias = sec.getString("alias", null);
        String gm = sec.getString("gamemode", null);
        if (gm != null) {
            try {
                mw.gamemode = GameMode.valueOf((String)gm);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if ((env = sec.getString("environment", null)) != null) {
            try {
                mw.environment = World.Environment.valueOf((String)env);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (sec.isConfigurationSection("spawn")) {
            String wName = Objects.requireNonNullElse(sec.getString("spawn.world"), name);
            World w = Bukkit.getWorld((String)wName);
            double x = sec.getDouble("spawn.x");
            double y = sec.getDouble("spawn.y");
            double z = sec.getDouble("spawn.z");
            float yaw = (float)sec.getDouble("spawn.yaw");
            float pitch = (float)sec.getDouble("spawn.pitch");
            mw.spawn = new Location(w, x, y, z, yaw, pitch);
        }
        mw.keepSpawnLoaded = sec.getBoolean("keep-spawn-loaded", true);
        if (sec.isList("allowed-mobs")) {
            for (String s : sec.getStringList("allowed-mobs")) {
                try {
                    mw.allowedMobs.add(EntityType.valueOf((String)s));
                }
                catch (IllegalArgumentException x) {}
            }
        }
        if ((diff = sec.getString("difficulty", null)) != null) {
            try {
                mw.difficulty = Difficulty.valueOf((String)diff);
            }
            catch (IllegalArgumentException s) {
                // empty catch block
            }
        }
        if (sec.contains("pvp")) {
            mw.pvp = sec.getBoolean("pvp");
        }
        if (sec.contains("lock-time")) {
            mw.lockTime = sec.getBoolean("lock-time");
        }
        if (sec.contains("time")) {
            mw.time = sec.getLong("time");
        }
        if (sec.contains("lock-weather")) {
            mw.lockWeather = sec.getBoolean("lock-weather");
        }
        mw.weather = sec.getString("weather", mw.weather);
        if (sec.contains("mob-griefing")) {
            mw.mobGriefing = sec.getBoolean("mob-griefing");
        }
        if (sec.contains("natural-regen")) {
            mw.naturalRegen = sec.getBoolean("natural-regen");
        }
        if (sec.contains("fire-tick")) {
            mw.fireTick = sec.getBoolean("fire-tick");
        }
        if (sec.contains("keep-inventory")) {
            mw.keepInventory = sec.getBoolean("keep-inventory");
        }
        if (sec.contains("spawn-protection")) {
            mw.spawnRadius = sec.getInt("spawn-protection");
        }
        if (sec.contains("random-tick")) {
            mw.randomTickSpeed = sec.getInt("random-tick");
        }
        if (sec.contains("max-entity-cramming")) {
            mw.maxEntityCramming = sec.getInt("max-entity-cramming");
        }
        if (sec.isConfigurationSection("border") && (b = sec.getConfigurationSection("border")) != null) {
            if (b.contains("size")) {
                mw.borderSize = b.getDouble("size");
            }
            if (b.isConfigurationSection("center")) {
                double cx = b.getDouble("center.x");
                double cz = b.getDouble("center.z");
                mw.borderCenter = new Location(Bukkit.getWorld((String)name), cx, 0.0, cz);
            }
        }
        if (sec.isConfigurationSection("resource-pack") && (rp = sec.getConfigurationSection("resource-pack")) != null) {
            mw.resourcePackUrl = rp.getString("url", null);
            mw.resourcePackHash = rp.getString("hash", null);
            if (rp.contains("required")) {
                mw.resourcePackRequired = rp.getBoolean("required");
            }
        }
        return mw;
    }
}

