/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.worldManager.model;

import java.util.Objects;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.texboobcat.worldManager.model.PortalDestination;
import org.texboobcat.worldManager.model.PortalRegion;

public class Portal {
    private final String name;
    private PortalRegion region;
    private PortalDestination destination;
    private boolean enabled = true;
    private String permission;
    private int warmupSeconds = 0;
    private int cooldownSeconds = 0;
    private Particle particle = Particle.PORTAL;
    private Sound sound = Sound.ENTITY_ENDERMAN_TELEPORT;
    private boolean showParticles = true;
    private boolean playSound = true;
    private String creator;
    private long createdAt;
    private long lastUsed;
    private volatile int useCount;
    private String appearanceType = "NONE";
    private String appearancePlane = "AUTO";
    private Particle appearanceParticle = Particle.PORTAL;
    private int appearanceParticleCount = 20;
    private double appearanceParticleSpreadX = 1.0;
    private double appearanceParticleSpreadY = 1.0;
    private double appearanceParticleSpreadZ = 1.0;
    private double appearanceParticleSpeed = 0.1;
    private int appearanceParticlePeriod = 1;

    public Portal(@NotNull String name) {
        this.name = name;
        this.createdAt = System.currentTimeMillis();
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @Nullable
    public PortalRegion getRegion() {
        return this.region;
    }

    public void setRegion(@Nullable PortalRegion region) {
        this.region = region;
    }

    @Nullable
    public PortalDestination getDestination() {
        return this.destination;
    }

    public void setDestination(@Nullable PortalDestination destination) {
        this.destination = destination;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Nullable
    public String getPermission() {
        return this.permission;
    }

    public void setPermission(@Nullable String permission) {
        this.permission = permission;
    }

    public int getWarmupSeconds() {
        return this.warmupSeconds;
    }

    public void setWarmupSeconds(int warmupSeconds) {
        this.warmupSeconds = Math.max(0, warmupSeconds);
    }

    public int getCooldownSeconds() {
        return this.cooldownSeconds;
    }

    public void setCooldownSeconds(int cooldownSeconds) {
        this.cooldownSeconds = Math.max(0, cooldownSeconds);
    }

    public Particle getParticle() {
        return this.particle;
    }

    public void setParticle(@Nullable Particle particle) {
        this.particle = particle != null ? particle : Particle.PORTAL;
    }

    public Sound getSound() {
        return this.sound;
    }

    public void setSound(@Nullable Sound sound) {
        this.sound = sound != null ? sound : Sound.ENTITY_ENDERMAN_TELEPORT;
    }

    public boolean isShowParticles() {
        return this.showParticles;
    }

    public void setShowParticles(boolean showParticles) {
        this.showParticles = showParticles;
    }

    public boolean isPlaySound() {
        return this.playSound;
    }

    public void setPlaySound(boolean playSound) {
        this.playSound = playSound;
    }

    @NotNull
    public String getAppearanceType() {
        return this.appearanceType;
    }

    public void setAppearanceType(@NotNull String appearanceType) {
        this.appearanceType = appearanceType.toUpperCase();
    }

    @NotNull
    public String getAppearancePlane() {
        return this.appearancePlane;
    }

    public void setAppearancePlane(@NotNull String plane) {
        this.appearancePlane = plane.toUpperCase();
    }

    @NotNull
    public Particle getAppearanceParticle() {
        return this.appearanceParticle;
    }

    public void setAppearanceParticle(@NotNull Particle p) {
        this.appearanceParticle = p;
    }

    public int getAppearanceParticleCount() {
        return this.appearanceParticleCount;
    }

    public void setAppearanceParticleCount(int c) {
        this.appearanceParticleCount = Math.max(1, c);
    }

    public double getAppearanceParticleSpreadX() {
        return this.appearanceParticleSpreadX;
    }

    public void setAppearanceParticleSpreadX(double v) {
        this.appearanceParticleSpreadX = Math.max(0.0, v);
    }

    public double getAppearanceParticleSpreadY() {
        return this.appearanceParticleSpreadY;
    }

    public void setAppearanceParticleSpreadY(double v) {
        this.appearanceParticleSpreadY = Math.max(0.0, v);
    }

    public double getAppearanceParticleSpreadZ() {
        return this.appearanceParticleSpreadZ;
    }

    public void setAppearanceParticleSpreadZ(double v) {
        this.appearanceParticleSpreadZ = Math.max(0.0, v);
    }

    public double getAppearanceParticleSpeed() {
        return this.appearanceParticleSpeed;
    }

    public void setAppearanceParticleSpeed(double v) {
        this.appearanceParticleSpeed = Math.max(0.0, v);
    }

    public int getAppearanceParticlePeriod() {
        return this.appearanceParticlePeriod;
    }

    public void setAppearanceParticlePeriod(int t) {
        this.appearanceParticlePeriod = Math.max(1, t);
    }

    @Nullable
    public String getCreator() {
        return this.creator;
    }

    public void setCreator(@Nullable String creator) {
        this.creator = creator;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public long getLastUsed() {
        return this.lastUsed;
    }

    public void setLastUsed(long lastUsed) {
        this.lastUsed = lastUsed;
    }

    public int getUseCount() {
        return this.useCount;
    }

    public synchronized void incrementUseCount() {
        ++this.useCount;
        this.lastUsed = System.currentTimeMillis();
    }

    public boolean isComplete() {
        return this.region != null && this.destination != null && this.enabled;
    }

    public boolean contains(@NotNull Location location) {
        if (this.region == null) {
            return false;
        }
        return this.region.contains(location);
    }

    public void save(@NotNull ConfigurationSection section) {
        section.set("enabled", (Object)this.enabled);
        section.set("creator", (Object)this.creator);
        section.set("created_at", (Object)this.createdAt);
        section.set("last_used", (Object)this.lastUsed);
        section.set("use_count", (Object)this.useCount);
        section.set("settings.permission", (Object)this.permission);
        section.set("settings.warmup_seconds", (Object)this.warmupSeconds);
        section.set("settings.cooldown_seconds", (Object)this.cooldownSeconds);
        section.set("settings.show_particles", (Object)this.showParticles);
        section.set("settings.play_sound", (Object)this.playSound);
        section.set("settings.appearance_type", (Object)this.appearanceType);
        section.set("settings.appearance_plane", (Object)this.appearancePlane);
        section.set("settings.appearance_particle", (Object)this.appearanceParticle.name());
        section.set("settings.appearance_particle_count", (Object)this.appearanceParticleCount);
        section.set("settings.appearance_particle_spread_x", (Object)this.appearanceParticleSpreadX);
        section.set("settings.appearance_particle_spread_y", (Object)this.appearanceParticleSpreadY);
        section.set("settings.appearance_particle_spread_z", (Object)this.appearanceParticleSpreadZ);
        section.set("settings.appearance_particle_speed", (Object)this.appearanceParticleSpeed);
        section.set("settings.appearance_particle_period", (Object)this.appearanceParticlePeriod);
        if (this.particle != null) {
            section.set("settings.particle", (Object)this.particle.name());
        }
        if (this.sound != null) {
            section.set("settings.sound", (Object)this.sound.name());
        }
        if (this.region != null) {
            ConfigurationSection regionSection = section.createSection("region");
            this.region.save(regionSection);
        }
        if (this.destination != null) {
            ConfigurationSection destSection = section.createSection("destination");
            this.destination.save(destSection);
        }
    }

    @NotNull
    public static Portal load(@NotNull String name, @NotNull ConfigurationSection section) {
        ConfigurationSection destSection;
        ConfigurationSection regionSection;
        String soundName;
        Portal portal = new Portal(name);
        portal.enabled = section.getBoolean("enabled", true);
        portal.creator = section.getString("creator");
        portal.createdAt = section.getLong("created_at", System.currentTimeMillis());
        portal.lastUsed = section.getLong("last_used", 0L);
        portal.useCount = section.getInt("use_count", 0);
        portal.permission = section.getString("settings.permission");
        portal.warmupSeconds = section.getInt("settings.warmup_seconds", 0);
        portal.cooldownSeconds = section.getInt("settings.cooldown_seconds", 0);
        portal.showParticles = section.getBoolean("settings.show_particles", true);
        portal.playSound = section.getBoolean("settings.play_sound", true);
        portal.appearanceType = section.getString("settings.appearance_type", "NONE").toUpperCase();
        portal.appearancePlane = section.getString("settings.appearance_plane", "AUTO").toUpperCase();
        String ap = section.getString("settings.appearance_particle");
        if (ap != null) {
            try {
                portal.appearanceParticle = Particle.valueOf((String)ap);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        portal.appearanceParticleCount = section.getInt("settings.appearance_particle_count", 20);
        portal.appearanceParticleSpreadX = section.getDouble("settings.appearance_particle_spread_x", 1.0);
        portal.appearanceParticleSpreadY = section.getDouble("settings.appearance_particle_spread_y", 1.0);
        portal.appearanceParticleSpreadZ = section.getDouble("settings.appearance_particle_spread_z", 1.0);
        portal.appearanceParticleSpeed = section.getDouble("settings.appearance_particle_speed", 0.1);
        portal.appearanceParticlePeriod = section.getInt("settings.appearance_particle_period", 1);
        String particleName = section.getString("settings.particle");
        if (particleName != null) {
            try {
                portal.particle = Particle.valueOf((String)particleName);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if ((soundName = section.getString("settings.sound")) != null) {
            try {
                portal.sound = Sound.valueOf((String)soundName);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (section.contains("region") && (regionSection = section.getConfigurationSection("region")) != null) {
            portal.region = PortalRegion.load(regionSection);
        }
        if (section.contains("destination") && (destSection = section.getConfigurationSection("destination")) != null) {
            portal.destination = PortalDestination.load(destSection);
        }
        return portal;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Portal portal = (Portal)o;
        return this.name.equals(portal.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public String toString() {
        return "Portal{name='" + this.name + "', enabled=" + this.enabled + ", complete=" + this.isComplete() + "}";
    }
}

