/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.worldManager.model;

import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PortalDestination {
    private final Type type;
    private final String worldName;
    private Double x;
    private Double y;
    private Double z;
    private Float yaw;
    private Float pitch;
    private String linkedPortalName;

    private PortalDestination(Type type, String worldName) {
        this.type = type;
        this.worldName = worldName;
    }

    @NotNull
    public static PortalDestination location(@NotNull Location location) {
        World world = location.getWorld();
        if (world == null) {
            throw new IllegalArgumentException("Location must have a valid world");
        }
        PortalDestination dest = new PortalDestination(Type.LOCATION, world.getName());
        dest.x = location.getX();
        dest.y = location.getY();
        dest.z = location.getZ();
        dest.yaw = Float.valueOf(location.getYaw());
        dest.pitch = Float.valueOf(location.getPitch());
        return dest;
    }

    @NotNull
    public static PortalDestination worldSpawn(@NotNull String worldName) {
        return new PortalDestination(Type.WORLD_SPAWN, worldName);
    }

    @NotNull
    public static PortalDestination portal(@NotNull String portalName) {
        PortalDestination dest = new PortalDestination(Type.PORTAL, null);
        dest.linkedPortalName = portalName;
        return dest;
    }

    @NotNull
    public Type getType() {
        return this.type;
    }

    @Nullable
    public String getWorldName() {
        return this.worldName;
    }

    @Nullable
    public String getLinkedPortalName() {
        return this.linkedPortalName;
    }

    @Nullable
    public Location getLocation() {
        if (this.type == Type.PORTAL) {
            return null;
        }
        World world = Bukkit.getWorld((String)this.worldName);
        if (world == null) {
            return null;
        }
        if (this.type == Type.WORLD_SPAWN) {
            return world.getSpawnLocation();
        }
        if (this.type == Type.LOCATION && this.x != null && this.y != null && this.z != null) {
            Location loc = new Location(world, this.x.doubleValue(), this.y.doubleValue(), this.z.doubleValue());
            if (this.yaw != null) {
                loc.setYaw(this.yaw.floatValue());
            }
            if (this.pitch != null) {
                loc.setPitch(this.pitch.floatValue());
            }
            return loc;
        }
        return null;
    }

    public boolean isValid() {
        if (this.type == Type.PORTAL) {
            return this.linkedPortalName != null;
        }
        return this.worldName != null && Bukkit.getWorld((String)this.worldName) != null;
    }

    public void save(@NotNull ConfigurationSection section) {
        section.set("type", (Object)this.type.name());
        if (this.type == Type.PORTAL) {
            section.set("portal", (Object)this.linkedPortalName);
        } else {
            section.set("world", (Object)this.worldName);
            if (this.type == Type.LOCATION) {
                section.set("x", (Object)this.x);
                section.set("y", (Object)this.y);
                section.set("z", (Object)this.z);
                section.set("yaw", (Object)this.yaw);
                section.set("pitch", (Object)this.pitch);
            }
        }
    }

    @Nullable
    public static PortalDestination load(@NotNull ConfigurationSection section) {
        String typeName = section.getString("type");
        if (typeName == null) {
            return null;
        }
        try {
            Type type = Type.valueOf(typeName);
            if (type == Type.PORTAL) {
                String portalName = section.getString("portal");
                if (portalName == null) {
                    return null;
                }
                return PortalDestination.portal(portalName);
            }
            String worldName = section.getString("world");
            if (worldName == null) {
                return null;
            }
            if (type == Type.WORLD_SPAWN) {
                return PortalDestination.worldSpawn(worldName);
            }
            if (type == Type.LOCATION) {
                if (!(section.contains("x") && section.contains("y") && section.contains("z"))) {
                    return null;
                }
                World world = Bukkit.getWorld((String)worldName);
                if (world == null) {
                    return null;
                }
                double x = section.getDouble("x");
                double y = section.getDouble("y");
                double z = section.getDouble("z");
                float yaw = (float)section.getDouble("yaw", 0.0);
                float pitch = (float)section.getDouble("pitch", 0.0);
                Location loc = new Location(world, x, y, z, yaw, pitch);
                return PortalDestination.location(loc);
            }
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        return null;
    }

    public String toString() {
        switch (this.type.ordinal()) {
            case 0: {
                return String.format("Location{world=%s, x=%.1f, y=%.1f, z=%.1f}", this.worldName, this.x, this.y, this.z);
            }
            case 1: {
                return String.format("WorldSpawn{world=%s}", this.worldName);
            }
            case 2: {
                return String.format("Portal{name=%s}", this.linkedPortalName);
            }
        }
        return "Unknown";
    }

    public static enum Type {
        LOCATION,
        WORLD_SPAWN,
        PORTAL;

    }
}

