/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.worldManager.model;

import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PortalRegion {
    private final String worldName;
    private final int minX;
    private final int minY;
    private final int minZ;
    private final int maxX;
    private final int maxY;
    private final int maxZ;

    public PortalRegion(@NotNull Location loc1, @NotNull Location loc2) {
        if (!loc1.getWorld().equals((Object)loc2.getWorld())) {
            throw new IllegalArgumentException("Both locations must be in the same world");
        }
        this.worldName = loc1.getWorld().getName();
        this.minX = Math.min(loc1.getBlockX(), loc2.getBlockX());
        this.minY = Math.min(loc1.getBlockY(), loc2.getBlockY());
        this.minZ = Math.min(loc1.getBlockZ(), loc2.getBlockZ());
        this.maxX = Math.max(loc1.getBlockX(), loc2.getBlockX());
        this.maxY = Math.max(loc1.getBlockY(), loc2.getBlockY());
        this.maxZ = Math.max(loc1.getBlockZ(), loc2.getBlockZ());
    }

    private PortalRegion(String worldName, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this.worldName = worldName;
        this.minX = minX;
        this.minY = minY;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxY = maxY;
        this.maxZ = maxZ;
    }

    @NotNull
    public String getWorldName() {
        return this.worldName;
    }

    @Nullable
    public World getWorld() {
        return Bukkit.getWorld((String)this.worldName);
    }

    public int getMinX() {
        return this.minX;
    }

    public int getMinY() {
        return this.minY;
    }

    public int getMinZ() {
        return this.minZ;
    }

    public int getMaxX() {
        return this.maxX;
    }

    public int getMaxY() {
        return this.maxY;
    }

    public int getMaxZ() {
        return this.maxZ;
    }

    @Nullable
    public Location getCenter() {
        World world = this.getWorld();
        if (world == null) {
            return null;
        }
        double centerX = (double)(this.minX + this.maxX) / 2.0;
        double centerY = (double)(this.minY + this.maxY) / 2.0;
        double centerZ = (double)(this.minZ + this.maxZ) / 2.0;
        return new Location(world, centerX, centerY, centerZ);
    }

    public int getVolume() {
        return (this.maxX - this.minX + 1) * (this.maxY - this.minY + 1) * (this.maxZ - this.minZ + 1);
    }

    public boolean contains(@NotNull Location location) {
        World world = location.getWorld();
        if (world == null || !this.worldName.equals(world.getName())) {
            return false;
        }
        int x = location.getBlockX();
        int y = location.getBlockY();
        int z = location.getBlockZ();
        return x >= this.minX && x <= this.maxX && y >= this.minY && y <= this.maxY && z >= this.minZ && z <= this.maxZ;
    }

    public boolean overlaps(@NotNull PortalRegion other) {
        if (!this.worldName.equals(other.worldName)) {
            return false;
        }
        return this.minX <= other.maxX && this.maxX >= other.minX && this.minY <= other.maxY && this.maxY >= other.minY && this.minZ <= other.maxZ && this.maxZ >= other.minZ;
    }

    public void save(@NotNull ConfigurationSection section) {
        section.set("world", (Object)this.worldName);
        section.set("min.x", (Object)this.minX);
        section.set("min.y", (Object)this.minY);
        section.set("min.z", (Object)this.minZ);
        section.set("max.x", (Object)this.maxX);
        section.set("max.y", (Object)this.maxY);
        section.set("max.z", (Object)this.maxZ);
    }

    @Nullable
    public static PortalRegion load(@NotNull ConfigurationSection section) {
        String worldName = section.getString("world");
        if (worldName == null) {
            return null;
        }
        if (!section.contains("min") || !section.contains("max")) {
            return null;
        }
        int minX = section.getInt("min.x");
        int minY = section.getInt("min.y");
        int minZ = section.getInt("min.z");
        int maxX = section.getInt("max.x");
        int maxY = section.getInt("max.y");
        int maxZ = section.getInt("max.z");
        return new PortalRegion(worldName, minX, minY, minZ, maxX, maxY, maxZ);
    }

    public String toString() {
        return String.format("Region{world=%s, (%d,%d,%d) to (%d,%d,%d)}", this.worldName, this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
    }
}

