/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.worldManager.service;

import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jetbrains.annotations.NotNull;
import org.texboobcat.worldManager.api.AddonManager;
import org.texboobcat.worldManager.api.TeleportHook;
import org.texboobcat.worldManager.api.WorldAddon;
import org.texboobcat.worldManager.api.WorldCreationHook;
import org.texboobcat.worldManager.api.WorldLoadHook;
import org.texboobcat.worldManager.api.WorldUnloadHook;

public class WorldManagerAddonManager
implements AddonManager {
    private final Set<WorldAddon> addons = ConcurrentHashMap.newKeySet();
    private final Set<WorldCreationHook> creationHooks = new CopyOnWriteArraySet<WorldCreationHook>();
    private final Set<WorldLoadHook> loadHooks = new CopyOnWriteArraySet<WorldLoadHook>();
    private final Set<WorldUnloadHook> unloadHooks = new CopyOnWriteArraySet<WorldUnloadHook>();
    private final Set<TeleportHook> teleportHooks = new CopyOnWriteArraySet<TeleportHook>();

    @Override
    public boolean registerAddon(@NotNull WorldAddon addon) {
        return this.addons.add(addon);
    }

    @Override
    public boolean unregisterAddon(@NotNull WorldAddon addon) {
        return this.addons.remove(addon);
    }

    @Override
    @NotNull
    public Collection<WorldAddon> getRegisteredAddons() {
        return Set.copyOf(this.addons);
    }

    @Override
    public boolean isRegistered(@NotNull WorldAddon addon) {
        return this.addons.contains(addon);
    }

    @Override
    public void registerCreationHook(@NotNull WorldCreationHook hook) {
        this.creationHooks.add(hook);
    }

    @Override
    public void unregisterCreationHook(@NotNull WorldCreationHook hook) {
        this.creationHooks.remove(hook);
    }

    @Override
    public void registerLoadHook(@NotNull WorldLoadHook hook) {
        this.loadHooks.add(hook);
    }

    @Override
    public void unregisterLoadHook(@NotNull WorldLoadHook hook) {
        this.loadHooks.remove(hook);
    }

    @Override
    public void registerUnloadHook(@NotNull WorldUnloadHook hook) {
        this.unloadHooks.add(hook);
    }

    @Override
    public void unregisterUnloadHook(@NotNull WorldUnloadHook hook) {
        this.unloadHooks.remove(hook);
    }

    @Override
    public void registerTeleportHook(@NotNull TeleportHook hook) {
        this.teleportHooks.add(hook);
    }

    @Override
    public void unregisterTeleportHook(@NotNull TeleportHook hook) {
        this.teleportHooks.remove(hook);
    }

    @Override
    @NotNull
    public Collection<WorldCreationHook> getCreationHooks() {
        return Set.copyOf(this.creationHooks);
    }

    @Override
    @NotNull
    public Collection<WorldLoadHook> getLoadHooks() {
        return Set.copyOf(this.loadHooks);
    }

    @Override
    @NotNull
    public Collection<WorldUnloadHook> getUnloadHooks() {
        return Set.copyOf(this.unloadHooks);
    }

    @Override
    @NotNull
    public Collection<TeleportHook> getTeleportHooks() {
        return Set.copyOf(this.teleportHooks);
    }
}

