/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.worldManager.service;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.texboobcat.worldManager.WorldManager;
import org.texboobcat.worldManager.api.WorldCreationHook;
import org.texboobcat.worldManager.api.WorldLoadHook;
import org.texboobcat.worldManager.api.WorldOperationService;
import org.texboobcat.worldManager.api.WorldUnloadHook;
import org.texboobcat.worldManager.api.event.WorldCreateEvent;
import org.texboobcat.worldManager.api.event.WorldCreatedEvent;
import org.texboobcat.worldManager.api.event.WorldDeleteEvent;
import org.texboobcat.worldManager.api.event.WorldDeletedEvent;
import org.texboobcat.worldManager.api.event.WorldLoadEvent;
import org.texboobcat.worldManager.api.event.WorldLoadedEvent;
import org.texboobcat.worldManager.api.event.WorldUnloadEvent;
import org.texboobcat.worldManager.api.event.WorldUnloadedEvent;
import org.texboobcat.worldManager.model.ManagedWorld;

public class WorldManagerOperationService
implements WorldOperationService {
    private final WorldManager plugin;

    public WorldManagerOperationService(WorldManager plugin) {
        this.plugin = plugin;
    }

    @Override
    @NotNull
    public CompletableFuture<World> createWorld(@NotNull WorldOperationService.WorldCreationOptions options) {
        CompletableFuture<World> future = new CompletableFuture<World>();
        WorldCreateEvent event = new WorldCreateEvent(options.getName(), options.getEnvironment(), options.getSeed(), options.getGenerator());
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            future.complete(null);
            return future;
        }
        for (WorldCreationHook hook : this.plugin.getAddonManager().getCreationHooks()) {
            if (hook.onBeforeCreate(options.getName(), options.getEnvironment())) continue;
            future.complete(null);
            return future;
        }
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            try {
                World world;
                WorldCreator creator = new WorldCreator(options.getName()).environment(options.getEnvironment());
                if (options.getSeed() != null) {
                    creator.seed(options.getSeed().longValue());
                }
                if (options.getGenerator() != null) {
                    creator.generator(options.getGenerator());
                }
                if (options.getGeneratorSettings() != null) {
                    creator.generatorSettings(options.getGeneratorSettings());
                }
                if (options.getStructures() != null) {
                    creator.generateStructures(options.getStructures().booleanValue());
                }
                if ((world = Bukkit.createWorld((WorldCreator)creator)) != null) {
                    ManagedWorld mw = null;
                    if (options.isAutoRegister()) {
                        mw = this.plugin.getRegistry().ensure(world.getName());
                        mw.setEnvironment(options.getEnvironment());
                        this.plugin.getRegistry().save();
                        if (options.isAutoLoad()) {
                            mw.applyToWorldIfLoaded();
                        }
                    }
                    WorldCreatedEvent createdEvent = new WorldCreatedEvent(world, mw);
                    Bukkit.getPluginManager().callEvent((Event)createdEvent);
                    for (WorldCreationHook hook : this.plugin.getAddonManager().getCreationHooks()) {
                        hook.onAfterCreate(world, mw);
                    }
                    future.complete(world);
                } else {
                    for (WorldCreationHook hook : this.plugin.getAddonManager().getCreationHooks()) {
                        hook.onCreateFailed(options.getName(), "World creation returned null");
                    }
                    future.complete(null);
                }
            }
            catch (Exception e) {
                for (WorldCreationHook hook : this.plugin.getAddonManager().getCreationHooks()) {
                    hook.onCreateFailed(options.getName(), e.getMessage());
                }
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    @Override
    @NotNull
    public CompletableFuture<World> loadWorld(@NotNull String worldName, @NotNull World.Environment environment, boolean autoRegister) {
        CompletableFuture<World> future = new CompletableFuture<World>();
        World existing = Bukkit.getWorld((String)worldName);
        if (existing != null) {
            future.complete(existing);
            return future;
        }
        WorldLoadEvent event = new WorldLoadEvent(worldName, environment);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            future.complete(null);
            return future;
        }
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            try {
                WorldCreator creator = new WorldCreator(worldName).environment(environment);
                World world = Bukkit.createWorld((WorldCreator)creator);
                if (world != null) {
                    ManagedWorld mw = null;
                    if (autoRegister) {
                        mw = this.plugin.getRegistry().ensure(world.getName());
                        mw.setEnvironment(environment);
                        mw.applyToWorldIfLoaded();
                        this.plugin.getRegistry().save();
                    } else {
                        mw = this.plugin.getRegistry().get(world.getName());
                        if (mw != null) {
                            mw.applyToWorldIfLoaded();
                        }
                    }
                    WorldLoadedEvent loadedEvent = new WorldLoadedEvent(world, mw);
                    Bukkit.getPluginManager().callEvent((Event)loadedEvent);
                    for (WorldLoadHook hook : this.plugin.getAddonManager().getLoadHooks()) {
                        hook.onWorldLoaded(world, mw);
                    }
                    future.complete(world);
                } else {
                    future.complete(null);
                }
            }
            catch (Exception e) {
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> unloadWorld(@NotNull String worldName, boolean save, boolean evacuatePlayers, @Nullable String evacuationWorld) {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        World world = Bukkit.getWorld((String)worldName);
        if (world == null) {
            future.complete(false);
            return future;
        }
        ManagedWorld mw = this.plugin.getRegistry().get(worldName);
        WorldUnloadEvent event = new WorldUnloadEvent(world, mw, save);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            future.complete(false);
            return future;
        }
        for (WorldUnloadHook hook : this.plugin.getAddonManager().getUnloadHooks()) {
            if (hook.onBeforeUnload(world, mw)) continue;
            future.complete(false);
            return future;
        }
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            try {
                boolean success;
                if (evacuatePlayers && !world.getPlayers().isEmpty()) {
                    World targetWorld;
                    World world2 = targetWorld = evacuationWorld != null ? Bukkit.getWorld((String)evacuationWorld) : (World)Bukkit.getWorlds().get(0);
                    if (targetWorld != null && targetWorld != world) {
                        for (Player p : new ArrayList(world.getPlayers())) {
                            p.teleport(targetWorld.getSpawnLocation());
                        }
                    }
                }
                if (success = Bukkit.unloadWorld((World)world, (boolean)save)) {
                    WorldUnloadedEvent unloadedEvent = new WorldUnloadedEvent(worldName, mw);
                    Bukkit.getPluginManager().callEvent((Event)unloadedEvent);
                    for (WorldUnloadHook hook : this.plugin.getAddonManager().getUnloadHooks()) {
                        hook.onAfterUnload(worldName, mw);
                    }
                }
                future.complete(success);
            }
            catch (Exception e) {
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> deleteWorld(@NotNull String worldName, boolean unloadFirst, boolean moveToTrash, boolean createBackup) {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        ManagedWorld mw = this.plugin.getRegistry().get(worldName);
        WorldDeleteEvent event = new WorldDeleteEvent(worldName, mw, moveToTrash);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            future.complete(false);
            return future;
        }
        CompletableFuture<Boolean> unloadFuture = unloadFirst ? this.unloadWorld(worldName, true, true, null) : CompletableFuture.completedFuture(true);
        unloadFuture.thenAccept(unloadSuccess -> {
            if (!unloadSuccess.booleanValue() && unloadFirst) {
                future.complete(false);
                return;
            }
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
                try {
                    boolean success;
                    File worldFolder = new File(Bukkit.getWorldContainer(), worldName);
                    if (!worldFolder.exists()) {
                        future.complete(false);
                        return;
                    }
                    if (createBackup) {
                        // empty if block
                    }
                    if (moveToTrash) {
                        File trashDir = new File(Bukkit.getWorldContainer(), "trash");
                        trashDir.mkdirs();
                        File trashDest = new File(trashDir, worldName);
                        success = worldFolder.renameTo(trashDest);
                    } else {
                        success = this.deleteDirectory(worldFolder);
                    }
                    if (success) {
                        this.plugin.getRegistry().unregister(worldName);
                        this.plugin.getRegistry().save();
                        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                            WorldDeletedEvent deletedEvent = new WorldDeletedEvent(worldName, moveToTrash);
                            Bukkit.getPluginManager().callEvent((Event)deletedEvent);
                        });
                    }
                    future.complete(success);
                }
                catch (Exception e) {
                    future.completeExceptionally(e);
                }
            });
        });
        return future;
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> cloneWorld(@NotNull String sourceWorld, @NotNull String targetWorld, boolean loadTarget) {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try {
                File sourceFolder = new File(Bukkit.getWorldContainer(), sourceWorld);
                File targetFolder = new File(Bukkit.getWorldContainer(), targetWorld);
                if (!sourceFolder.exists() || targetFolder.exists()) {
                    future.complete(false);
                    return;
                }
                this.copyDirectory(sourceFolder, targetFolder);
                if (loadTarget) {
                    ManagedWorld sourceMw = this.plugin.getRegistry().get(sourceWorld);
                    World.Environment env = sourceMw != null && sourceMw.getEnvironment() != null ? sourceMw.getEnvironment() : World.Environment.NORMAL;
                    this.loadWorld(targetWorld, env, true).thenAccept(world -> future.complete(world != null));
                } else {
                    future.complete(true);
                }
            }
            catch (Exception e) {
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> importWorld(@NotNull File source, @NotNull String targetName, boolean deleteSource, boolean loadAfterImport) {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        if (!source.exists()) {
            this.plugin.getLogger().warning("Import source does not exist: " + source.getAbsolutePath());
            future.complete(false);
            return future;
        }
        File targetFolder = new File(Bukkit.getWorldContainer(), targetName);
        if (targetFolder.exists()) {
            this.plugin.getLogger().warning("Import target already exists: " + targetName);
            future.complete(false);
            return future;
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try {
                boolean success = false;
                if (source.isDirectory()) {
                    this.plugin.getLogger().info("Importing world from directory: " + source.getName());
                    this.copyDirectory(source, targetFolder);
                    success = true;
                } else if (source.getName().toLowerCase().endsWith(".zip")) {
                    this.plugin.getLogger().info("Importing world from ZIP: " + source.getName());
                    success = this.extractZip(source, targetFolder);
                } else {
                    this.plugin.getLogger().warning("Unsupported import source type: " + source.getName());
                    future.complete(false);
                    return;
                }
                if (!success) {
                    future.complete(false);
                    return;
                }
                if (deleteSource) {
                    try {
                        if (source.isDirectory()) {
                            this.deleteDirectory(source);
                        } else {
                            source.delete();
                        }
                        this.plugin.getLogger().info("Deleted import source: " + source.getName());
                    }
                    catch (Exception e) {
                        this.plugin.getLogger().warning("Failed to delete source: " + e.getMessage());
                    }
                }
                if (loadAfterImport) {
                    World.Environment env = this.detectEnvironment(targetFolder);
                    ((CompletableFuture)this.loadWorld(targetName, env, true).thenAccept(world -> {
                        if (world != null) {
                            this.plugin.getLogger().info("Imported and loaded world: " + targetName);
                            future.complete(true);
                        } else {
                            this.plugin.getLogger().warning("Import succeeded but load failed: " + targetName);
                            future.complete(false);
                        }
                    })).exceptionally(ex -> {
                        this.plugin.getLogger().severe("Error loading imported world: " + ex.getMessage());
                        future.complete(false);
                        return null;
                    });
                } else {
                    this.plugin.getLogger().info("World imported successfully: " + targetName);
                    future.complete(true);
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Error importing world: " + e.getMessage());
                e.printStackTrace();
                if (targetFolder.exists()) {
                    try {
                        this.deleteDirectory(targetFolder);
                    }
                    catch (Exception ex2) {
                        this.plugin.getLogger().warning("Failed to cleanup failed import: " + ex2.getMessage());
                    }
                }
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> exportWorld(@NotNull String worldName, @NotNull File destination, boolean unloadFirst) {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        File worldFolder = new File(Bukkit.getWorldContainer(), worldName);
        if (!worldFolder.exists() || !worldFolder.isDirectory()) {
            this.plugin.getLogger().warning("Export failed: world folder doesn't exist: " + worldName);
            future.complete(false);
            return future;
        }
        if (destination.exists() && !destination.isFile()) {
            this.plugin.getLogger().warning("Export failed: destination is not a file: " + destination.getAbsolutePath());
            future.complete(false);
            return future;
        }
        if (destination.getParentFile() != null) {
            destination.getParentFile().mkdirs();
        }
        World world = Bukkit.getWorld((String)worldName);
        CompletableFuture<Boolean> unloadFuture = unloadFirst && world != null ? this.unloadWorld(worldName, true, true, null) : CompletableFuture.completedFuture(true);
        ((CompletableFuture)unloadFuture.thenAccept(unloadSuccess -> {
            if (!unloadSuccess.booleanValue() && unloadFirst) {
                this.plugin.getLogger().warning("Export failed: could not unload world: " + worldName);
                future.complete(false);
                return;
            }
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
                try {
                    this.plugin.getLogger().info("Exporting world to ZIP: " + worldName + " -> " + destination.getName());
                    boolean success = this.createZip(worldFolder, destination);
                    if (success) {
                        this.plugin.getLogger().info("World exported successfully: " + worldName);
                        future.complete(true);
                    } else {
                        this.plugin.getLogger().warning("Failed to create ZIP archive");
                        future.complete(false);
                    }
                }
                catch (Exception e) {
                    this.plugin.getLogger().severe("Error exporting world: " + e.getMessage());
                    e.printStackTrace();
                    if (destination.exists()) {
                        try {
                            destination.delete();
                        }
                        catch (Exception ex) {
                            this.plugin.getLogger().warning("Failed to cleanup failed export: " + ex.getMessage());
                        }
                    }
                    future.completeExceptionally(e);
                }
            });
        })).exceptionally(ex -> {
            this.plugin.getLogger().severe("Error during unload before export: " + ex.getMessage());
            future.complete(false);
            return null;
        });
        return future;
    }

    @Override
    @NotNull
    public Collection<String> getLoadableWorlds() {
        ArrayList<String> loadable = new ArrayList<String>();
        File container = Bukkit.getWorldContainer();
        File[] files = container.listFiles();
        if (files != null) {
            for (File f : files) {
                String name;
                if (!f.isDirectory() || !new File(f, "level.dat").exists() || Bukkit.getWorld((String)(name = f.getName())) != null) continue;
                loadable.add(name);
            }
        }
        return loadable;
    }

    @Override
    public boolean worldExists(@NotNull String worldName) {
        File worldFolder = new File(Bukkit.getWorldContainer(), worldName);
        return worldFolder.exists() && worldFolder.isDirectory();
    }

    @Override
    public boolean isWorldLoaded(@NotNull String worldName) {
        return Bukkit.getWorld((String)worldName) != null;
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> saveWorld(@NotNull String worldName) {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        World world = Bukkit.getWorld((String)worldName);
        if (world == null) {
            future.complete(false);
            return future;
        }
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            try {
                world.save();
                future.complete(true);
            }
            catch (Exception e) {
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    @Override
    @NotNull
    public CompletableFuture<Integer> regenerateChunks(@NotNull String worldName, int centerX, int centerZ, int radiusChunks) {
        CompletableFuture<Integer> future = new CompletableFuture<Integer>();
        World world = Bukkit.getWorld((String)worldName);
        if (world == null) {
            future.complete(0);
            return future;
        }
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            try {
                int count = 0;
                for (int x = centerX - radiusChunks; x <= centerX + radiusChunks; ++x) {
                    for (int z = centerZ - radiusChunks; z <= centerZ + radiusChunks; ++z) {
                        if (!world.regenerateChunk(x, z)) continue;
                        ++count;
                    }
                }
                future.complete(count);
            }
            catch (Exception e) {
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    private boolean deleteDirectory(File dir) {
        if (!dir.exists()) {
            return false;
        }
        File[] files = dir.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    this.deleteDirectory(f);
                    continue;
                }
                f.delete();
            }
        }
        return dir.delete();
    }

    private void copyDirectory(File source, File target) throws Exception {
        File[] files;
        if (!target.exists()) {
            target.mkdirs();
        }
        if ((files = source.listFiles()) != null) {
            for (File f : files) {
                File targetFile = new File(target, f.getName());
                if (f.isDirectory()) {
                    this.copyDirectory(f, targetFile);
                    continue;
                }
                if (f.getName().equals("session.lock") || f.getName().equals("uid.dat")) continue;
                Files.copy(f.toPath(), targetFile.toPath(), new CopyOption[0]);
            }
        }
    }

    private boolean extractZip(File zipFile, File targetFolder) throws Exception {
        targetFolder.mkdirs();
        try (ZipInputStream zis = new ZipInputStream(new FileInputStream(zipFile));){
            ZipEntry entry;
            byte[] buffer = new byte[8192];
            while ((entry = zis.getNextEntry()) != null) {
                File entryFile = new File(targetFolder, entry.getName());
                if (!entryFile.getCanonicalPath().startsWith(targetFolder.getCanonicalPath())) {
                    throw new SecurityException("ZIP entry outside target directory: " + entry.getName());
                }
                if (entry.isDirectory()) {
                    entryFile.mkdirs();
                } else {
                    entryFile.getParentFile().mkdirs();
                    try (FileOutputStream fos = new FileOutputStream(entryFile);){
                        int len;
                        while ((len = zis.read(buffer)) > 0) {
                            fos.write(buffer, 0, len);
                        }
                    }
                }
                zis.closeEntry();
            }
        }
        return true;
    }

    private World.Environment detectEnvironment(File worldFolder) {
        if (new File(worldFolder, "DIM-1").exists()) {
            return World.Environment.NETHER;
        }
        if (new File(worldFolder, "DIM1").exists()) {
            return World.Environment.THE_END;
        }
        return World.Environment.NORMAL;
    }

    private boolean createZip(File sourceFolder, File zipFile) throws Exception {
        try (ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(zipFile));){
            this.zipDirectory(sourceFolder, sourceFolder.getName(), zos);
            boolean bl = true;
            return bl;
        }
    }

    private void zipDirectory(File folder, String parentPath, ZipOutputStream zos) throws Exception {
        File[] files = folder.listFiles();
        if (files == null) {
            return;
        }
        byte[] buffer = new byte[8192];
        for (File file : files) {
            if (file.getName().equals("session.lock") || file.getName().equals("uid.dat")) continue;
            String filePath = parentPath + "/" + file.getName();
            if (file.isDirectory()) {
                zos.putNextEntry(new ZipEntry(filePath + "/"));
                zos.closeEntry();
                this.zipDirectory(file, filePath, zos);
                continue;
            }
            zos.putNextEntry(new ZipEntry(filePath));
            try (FileInputStream fis = new FileInputStream(file);){
                int len;
                while ((len = fis.read(buffer)) > 0) {
                    zos.write(buffer, 0, len);
                }
            }
            zos.closeEntry();
        }
    }
}

