/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.worldManager.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.texboobcat.worldManager.WorldManager;
import org.texboobcat.worldManager.api.TeleportHook;
import org.texboobcat.worldManager.api.TeleportationService;
import org.texboobcat.worldManager.api.event.WorldTeleportEvent;

public class WorldManagerTeleportationService
implements TeleportationService {
    private final WorldManager plugin;

    public WorldManagerTeleportationService(WorldManager plugin) {
        this.plugin = plugin;
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> teleport(@NotNull Player player, @NotNull Location destination, @Nullable String cause, boolean bypassWarmup, boolean bypassCooldown) {
        long remaining;
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        if (!bypassCooldown && (remaining = this.getRemainingCooldown(player.getUniqueId())) > 0L) {
            future.complete(false);
            return future;
        }
        WorldTeleportEvent event = new WorldTeleportEvent(player, player.getLocation(), destination, cause);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            future.complete(false);
            return future;
        }
        for (TeleportHook hook : this.plugin.getAddonManager().getTeleportHooks()) {
            if (hook.onBeforeTeleport(player, player.getLocation(), destination, cause)) continue;
            future.complete(false);
            return future;
        }
        int warmup = bypassWarmup ? 0 : this.plugin.getConfig().getInt("options.tp_warmup_seconds", 0);
        int maxHist = this.plugin.getConfig().getInt("options.tp_history_max", 10);
        Location from = player.getLocation().clone();
        Runnable teleportTask = () -> {
            if (!player.isOnline()) {
                future.complete(false);
                return;
            }
            this.plugin.getLastLocation().put(player.getUniqueId(), from);
            this.plugin.pushHistory(player.getUniqueId(), from, maxHist);
            player.teleportAsync(destination).thenAccept(success -> {
                if (success.booleanValue()) {
                    this.plugin.getLastTeleportAt().put(player.getUniqueId(), System.currentTimeMillis());
                    for (TeleportHook hook : this.plugin.getAddonManager().getTeleportHooks()) {
                        hook.onAfterTeleport(player, from, destination, cause);
                    }
                } else {
                    for (TeleportHook hook : this.plugin.getAddonManager().getTeleportHooks()) {
                        hook.onTeleportFailed(player, from, destination, cause, "Teleport failed");
                    }
                }
                future.complete((Boolean)success);
            });
        };
        if (warmup > 0) {
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, teleportTask, (long)warmup * 20L);
        } else {
            teleportTask.run();
        }
        return future;
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> teleportImmediately(@NotNull Player player, @NotNull Location destination, @Nullable String cause) {
        return this.teleport(player, destination, cause, true, true);
    }

    @Override
    public long getRemainingCooldown(@NotNull UUID playerUUID) {
        int cooldown = this.plugin.getConfig().getInt("options.tp_cooldown_seconds", 0);
        if (cooldown <= 0) {
            return 0L;
        }
        Long last = this.plugin.getLastTeleportAt().get(playerUUID);
        if (last == null) {
            return 0L;
        }
        long elapsed = System.currentTimeMillis() - last;
        long remaining = (long)cooldown * 1000L - elapsed;
        return Math.max(0L, (remaining + 999L) / 1000L);
    }

    @Override
    public void resetCooldown(@NotNull UUID playerUUID) {
        this.plugin.getLastTeleportAt().remove(playerUUID);
    }

    @Override
    public void addToHistory(@NotNull UUID playerUUID, @NotNull Location location) {
        int maxHist = this.plugin.getConfig().getInt("options.tp_history_max", 10);
        this.plugin.pushHistory(playerUUID, location, maxHist);
    }

    @Override
    @NotNull
    public Collection<Location> getHistory(@NotNull UUID playerUUID) {
        return new ArrayList<Location>(this.plugin.getHistory(playerUUID));
    }

    @Override
    public void clearHistory(@NotNull UUID playerUUID) {
        this.plugin.getHistory(playerUUID).clear();
    }

    @Override
    @Nullable
    public Location getLastLocation(@NotNull UUID playerUUID) {
        Location loc = this.plugin.getLastLocation().get(playerUUID);
        return loc != null ? loc.clone() : null;
    }

    @Override
    public void setLastLocation(@NotNull UUID playerUUID, @NotNull Location location) {
        this.plugin.getLastLocation().put(playerUUID, location.clone());
    }
}

