/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.worldManager.service;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.texboobcat.worldManager.WorldManager;
import org.texboobcat.worldManager.model.ManagedWorld;

public class WorldRegistry {
    private final WorldManager plugin;
    private final Map<String, ManagedWorld> worlds = new HashMap<String, ManagedWorld>();
    private File file;
    private FileConfiguration data;
    private int loadedVersion = 1;

    public WorldRegistry(WorldManager plugin) {
        this.plugin = plugin;
    }

    public void load() {
        try {
            if (!this.plugin.getDataFolder().exists()) {
                this.plugin.getDataFolder().mkdirs();
            }
            this.file = new File(this.plugin.getDataFolder(), "worlds.yml");
            if (!this.file.exists()) {
                this.file.createNewFile();
            }
            this.data = YamlConfiguration.loadConfiguration((File)this.file);
            this.loadedVersion = this.data.getInt("version", 1);
            this.worlds.clear();
            ConfigurationSection root = this.data.getConfigurationSection("worlds");
            if (root != null) {
                for (String name : root.getKeys(false)) {
                    ManagedWorld mw = ManagedWorld.load(name, root.getConfigurationSection(name));
                    this.worlds.put(name.toLowerCase(), mw);
                }
            }
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Failed to load worlds.yml: " + e.getMessage());
        }
    }

    public void save() {
        if (this.data == null) {
            this.data = new YamlConfiguration();
        }
        if (this.plugin.getConfig().getBoolean("options.backup_worlds_on_save", true)) {
            try {
                this.backupWorldsFile();
            }
            catch (IOException ex) {
                this.plugin.getLogger().warning("Backup worlds.yml failed: " + ex.getMessage());
            }
        }
        this.data.set("worlds", null);
        ConfigurationSection root = this.data.createSection("worlds");
        for (ManagedWorld mw : this.worlds.values()) {
            ConfigurationSection sec = root.createSection(mw.getName());
            mw.save(sec);
        }
        this.data.set("version", (Object)2);
        try {
            this.data.save(this.file);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Failed to save worlds.yml: " + e.getMessage());
        }
    }

    public int getLoadedVersion() {
        return this.loadedVersion;
    }

    public File getDataFile() {
        return this.file;
    }

    public File backupWorldsFile() throws IOException {
        if (this.file == null || !this.file.exists()) {
            return this.file;
        }
        File backupsDir = new File(this.plugin.getDataFolder(), "backups");
        if (!backupsDir.exists()) {
            backupsDir.mkdirs();
        }
        String ts = new SimpleDateFormat("yyyyMMdd-HHmmss").format(new Date());
        File dest = new File(backupsDir, "worlds-" + ts + ".yml");
        Files.copy(this.file.toPath(), dest.toPath(), new CopyOption[0]);
        return dest;
    }

    public boolean migrateToLatest(boolean force) {
        int latest = 2;
        if (!force && this.loadedVersion >= latest) {
            return false;
        }
        try {
            File backup = this.backupWorldsFile();
            this.plugin.getLogger().info("Backup created: " + (backup != null ? backup.getAbsolutePath() : "<none>"));
        }
        catch (IOException e) {
            this.plugin.getLogger().warning("Failed to create worlds.yml backup before migration: " + e.getMessage());
        }
        this.save();
        this.loadedVersion = latest;
        return true;
    }

    public ManagedWorld get(String name) {
        if (name == null) {
            return null;
        }
        return this.worlds.get(name.toLowerCase());
    }

    public ManagedWorld ensure(String name) {
        ManagedWorld mw = this.get(name);
        if (mw == null) {
            mw = new ManagedWorld(name);
            this.worlds.put(name.toLowerCase(), mw);
        }
        return mw;
    }

    public Collection<ManagedWorld> all() {
        return this.worlds.values();
    }

    public List<String> allNames() {
        return this.worlds.values().stream().map(ManagedWorld::getName).collect(Collectors.toList());
    }

    public void unregister(String name) {
        if (name != null) {
            this.worlds.remove(name.toLowerCase());
        }
    }

    public World importWorld(String folderName, World.Environment env) {
        File container = Bukkit.getWorldContainer();
        File folder = new File(container, folderName);
        if (!folder.exists() || !folder.isDirectory()) {
            return null;
        }
        WorldCreator creator = new WorldCreator(folderName).environment(env);
        return Bukkit.createWorld((WorldCreator)creator);
    }
}

