/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.worldManager.task;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.event.world.WorldInitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class SmartPregenTask
implements Runnable {
    private final Plugin plugin;
    private final World world;
    private final Region region;
    private final int centerX;
    private final int centerZ;
    private final Mode mode;
    private final int chunksPerTick;
    private final int maxInFlight;
    private final int progressIntervalSeconds;
    private final int structureGridSpacing;
    private final CommandSender sink;
    private long processed = 0L;
    private final long total;
    private long lastReportMs = 0L;
    private double emaCps = 0.0;
    private final double emaAlpha = 0.2;
    private final AtomicLong completed = new AtomicLong(0L);
    private long lastCompleted = 0L;
    private BukkitTask task;
    private final AtomicInteger inFlight = new AtomicInteger(0);
    private final boolean adaptiveThrottle;
    private final double minTpsTarget;
    private final double recoverTpsTarget;
    private volatile int dynChunksPerTick;
    private volatile int dynMaxInFlight;
    private final int minChunksPerTick = 1;
    private final int minMaxInFlight = 1;
    private final File metaFile;
    private final TaskListener listener = new TaskListener();
    private long metaLoadedChunks = 0L;
    private volatile boolean paused = false;
    private final boolean skipPlayers;
    private final int skipRadiusBlocks;
    private final boolean persist;
    private final File stateFile;
    private final ArrayDeque<int[]> deferred = new ArrayDeque();
    private final Set<Long> deferredSet = new HashSet<Long>();
    private int spiralX;
    private int spiralZ;
    private int spiralLayer = 0;
    private int spiralLeg = 0;
    private int spiralSteps = 1;
    private int spiralStepCount = 0;
    private int spiralLegCount = 0;
    private int ringR = 0;
    private List<int[]> ringBuffer = Collections.emptyList();
    private int ringIndex = 0;
    private int mortonSize;
    private long mortonIndex = 0L;
    private long mortonMax = 0L;
    private final Set<Long> visited = new HashSet<Long>();

    public SmartPregenTask(Plugin plugin, World world, Region region, int centerX, int centerZ, Mode mode, int chunksPerTick, int maxInFlight, int progressIntervalSeconds, int structureGridSpacing, boolean skipPlayers, int skipRadiusBlocks, boolean persist, File stateFile, CommandSender sink) {
        this.plugin = plugin;
        this.world = world;
        this.region = region;
        this.centerX = centerX;
        this.centerZ = centerZ;
        this.mode = mode;
        this.chunksPerTick = Math.max(1, chunksPerTick);
        this.maxInFlight = Math.max(this.chunksPerTick, Math.max(1, maxInFlight));
        this.progressIntervalSeconds = Math.max(1, progressIntervalSeconds);
        this.structureGridSpacing = Math.max(4, structureGridSpacing);
        this.skipPlayers = skipPlayers;
        this.skipRadiusBlocks = Math.max(0, skipRadiusBlocks);
        this.persist = persist;
        this.stateFile = stateFile;
        this.sink = sink;
        this.total = region.totalChunks();
        this.spiralX = centerX;
        this.spiralZ = centerZ;
        this.initMorton();
        boolean at = true;
        double minTps = 19.5;
        double recTps = 19.85;
        try {
            at = plugin.getConfig().getBoolean("options.pregen.adaptive_throttle", true);
            minTps = plugin.getConfig().getDouble("options.pregen.min_tps", 19.5);
            recTps = plugin.getConfig().getDouble("options.pregen.recover_tps", 19.85);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.adaptiveThrottle = at;
        this.minTpsTarget = minTps;
        this.recoverTpsTarget = recTps;
        this.dynChunksPerTick = this.chunksPerTick;
        this.dynMaxInFlight = this.maxInFlight;
        File metaDir = stateFile != null && stateFile.getParentFile() != null ? stateFile.getParentFile() : plugin.getDataFolder();
        this.metaFile = new File(metaDir, "pregen-meta.txt");
    }

    private void initMorton() {
        int n;
        int width = this.region.maxX() - this.region.minX() + 1;
        int height = this.region.maxZ() - this.region.minZ() + 1;
        for (n = 1; n < Math.max(width, height); n <<= 1) {
        }
        this.mortonSize = Math.max(1, n);
        this.mortonIndex = 0L;
        this.mortonMax = 1L * (long)this.mortonSize * (long)this.mortonSize;
    }

    public void start() {
        this.task = Bukkit.getScheduler().runTaskTimer(this.plugin, (Runnable)this, 1L, 1L);
        try {
            Bukkit.getPluginManager().registerEvents((Listener)this.listener, this.plugin);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.persist) {
            this.safeWriteState();
        }
        this.appendMeta("START", 0L);
    }

    public void cancel() {
        if (this.task != null) {
            this.task.cancel();
        }
        try {
            HandlerList.unregisterAll((Listener)this.listener);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.appendMeta("CANCEL", 0L);
    }

    @Override
    public void run() {
        int[] next;
        if (this.paused) {
            return;
        }
        int issued = 0;
        int attempts = 0;
        int tickBudget = Math.max(1, this.dynChunksPerTick);
        int inFlightLimit = Math.max(1, this.dynMaxInFlight);
        int maxAttempts = Math.max(tickBudget * 8, 128);
        while (issued < tickBudget && this.inFlight.get() < inFlightLimit && attempts < maxAttempts && (next = this.nextChunkFiltered()) != null) {
            int cx = next[0];
            int cz = next[1];
            long key = (long)cx << 32 ^ (long)cz & 0xFFFFFFFFL;
            if (!this.visited.add(key)) continue;
            ++this.processed;
            if (this.isAlreadyGenerated(cx, cz)) {
                this.completed.incrementAndGet();
            } else {
                this.issueLoad(cx, cz);
                ++issued;
            }
            ++attempts;
        }
        long now = System.currentTimeMillis();
        if (this.completed.get() >= this.total) {
            long comp = this.completed.get();
            if (this.sink != null) {
                this.sink.sendMessage(String.format("\u00a7aPregen complete for \u00a7b%s\u00a7a: \u00a7f%d/%d chunks", this.world.getName(), comp, this.total));
            }
            this.plugin.getLogger().info("Smart pregen complete for " + this.world.getName() + ": " + comp + "/" + this.total + " chunks");
            this.cancel();
            if (this.persist) {
                this.safeWriteState();
            }
            this.appendMeta("COMPLETE", comp);
            return;
        }
        if (now - this.lastReportMs >= (long)this.progressIntervalSeconds * 1000L) {
            long comp = this.completed.get();
            long dtMs = this.lastReportMs == 0L ? (long)this.progressIntervalSeconds * 1000L : now - this.lastReportMs;
            double dtSec = Math.max(0.001, (double)dtMs / 1000.0);
            long deltaCompleted = Math.max(0L, comp - this.lastCompleted);
            double instantCps = (double)deltaCompleted / dtSec;
            this.emaCps = this.emaCps == 0.0 ? instantCps : 0.2 * instantCps + 0.8 * this.emaCps;
            long remaining = Math.max(0L, this.total - comp);
            double etaSec = this.emaCps > 0.01 ? (double)remaining / this.emaCps : -1.0;
            String etaStr = etaSec < 0.0 ? "--" : this.formatEta(etaSec);
            this.lastReportMs = now;
            this.lastCompleted = comp;
            if (this.adaptiveThrottle) {
                this.autoThrottle();
            }
            if (this.sink != null) {
                this.sink.sendMessage(String.format("\u00a77Pregen \u00a7f%s\u00a77: \u00a7f%d/%d\u00a77 (%.1f cps), ETA \u00a7f%s", this.world.getName(), comp, this.total, this.emaCps, etaStr));
            }
            if (this.persist) {
                this.safeWriteState();
            }
        }
    }

    private int[] nextChunkFiltered() {
        int[] n;
        long key;
        int[] d;
        for (int spins = 0; !this.deferred.isEmpty() && spins < 64 && (d = this.deferred.pollFirst()) != null; ++spins) {
            key = (long)d[0] << 32 ^ (long)d[1] & 0xFFFFFFFFL;
            this.deferredSet.remove(key);
            if (this.skipPlayers && this.isNearPlayers(d[0], d[1])) {
                if (this.deferred.size() >= 8192) continue;
                this.deferred.addLast(d);
                this.deferredSet.add(key);
                continue;
            }
            return d;
        }
        while (true) {
            if ((n = this.nextChunk()) == null) {
                return null;
            }
            if (!this.skipPlayers || !this.isNearPlayers(n[0], n[1])) break;
            key = (long)n[0] << 32 ^ (long)n[1] & 0xFFFFFFFFL;
            if (this.deferredSet.contains(key) || this.deferred.size() >= 8192) continue;
            this.deferred.addLast(n);
            this.deferredSet.add(key);
        }
        return n;
    }

    private boolean isNearPlayers(int cx, int cz) {
        if (this.skipRadiusBlocks <= 0) {
            return false;
        }
        int x = (cx << 4) + 8;
        int z = (cz << 4) + 8;
        int r2 = this.skipRadiusBlocks * this.skipRadiusBlocks;
        try {
            for (Player p : this.world.getPlayers()) {
                int dz;
                int dx;
                Location l = p.getLocation();
                if (l.getWorld() != this.world || (dx = (int)(l.getX() - (double)x)) * dx + (dz = (int)(l.getZ() - (double)z)) * dz > r2) continue;
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    private void issueLoad(int cx, int cz) {
        boolean scheduled = false;
        try {
            Method m = World.class.getMethod("getChunkAtAsync", Integer.TYPE, Integer.TYPE);
            Object futureObj = m.invoke((Object)this.world, cx, cz);
            if (futureObj instanceof CompletableFuture) {
                CompletableFuture fut = (CompletableFuture)futureObj;
                this.inFlight.incrementAndGet();
                fut.whenComplete((ch, ex) -> {
                    this.inFlight.decrementAndGet();
                    if (ex == null) {
                        this.completed.incrementAndGet();
                    }
                });
                scheduled = true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (!scheduled) {
            this.world.getChunkAt(cx, cz).load(true);
            this.completed.incrementAndGet();
        }
    }

    private boolean isAlreadyGenerated(int cx, int cz) {
        try {
            Method m = World.class.getMethod("isChunkGenerated", Integer.TYPE, Integer.TYPE);
            Object r = m.invoke((Object)this.world, cx, cz);
            if (r instanceof Boolean) {
                return (Boolean)r;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            return this.world.isChunkLoaded(cx, cz);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private String formatEta(double seconds) {
        long s = Math.max(0L, Math.round(seconds));
        long h = s / 3600L;
        long m = (s %= 3600L) / 60L;
        s %= 60L;
        if (h > 0L) {
            return String.format(Locale.ROOT, "%dh %dm %ds", h, m, s);
        }
        if (m > 0L) {
            return String.format(Locale.ROOT, "%dm %ds", m, s);
        }
        return String.format(Locale.ROOT, "%ds", s);
    }

    private int[] nextChunk() {
        switch (this.mode.ordinal()) {
            case 0: {
                return this.nextSpiral();
            }
            case 1: {
                return this.nextRing();
            }
            case 2: {
                return this.nextMorton();
            }
            case 3: {
                return this.nextStructureBiased();
            }
        }
        return null;
    }

    private int[] nextSpiral() {
        do {
            if (this.processed >= this.total) {
                return null;
            }
            if (!this.region.contains(this.spiralX, this.spiralZ)) continue;
            int cx = this.spiralX;
            int cz = this.spiralZ;
            this.advanceSpiral();
            return new int[]{cx, cz};
        } while (this.advanceSpiral());
        return null;
    }

    private boolean advanceSpiral() {
        if (this.spiralLayer != 0 || this.spiralLeg != 0 || this.spiralStepCount == 0) {
            // empty if block
        }
        if (this.spiralLeg == 0) {
            ++this.spiralX;
        } else if (this.spiralLeg == 1) {
            --this.spiralZ;
        } else if (this.spiralLeg == 2) {
            --this.spiralX;
        } else if (this.spiralLeg == 3) {
            ++this.spiralZ;
        }
        ++this.spiralStepCount;
        if (this.spiralStepCount >= this.spiralSteps) {
            this.spiralStepCount = 0;
            this.spiralLeg = (this.spiralLeg + 1) % 4;
            ++this.spiralLegCount;
            if (this.spiralLegCount % 2 == 0) {
                ++this.spiralSteps;
                ++this.spiralLayer;
            }
        }
        int margin = 2;
        return this.spiralX >= this.region.minX() - margin && this.spiralX <= this.region.maxX() + margin && this.spiralZ >= this.region.minZ() - margin && this.spiralZ <= this.region.maxZ() + margin || this.spiralLayer <= Math.max(this.region.maxX() - this.centerX, this.centerX - this.region.minX()) + Math.max(this.region.maxZ() - this.centerZ, this.centerZ - this.region.minZ()) + 4;
    }

    private int[] nextRing() {
        int[] p;
        do {
            if (this.processed >= this.total) {
                return null;
            }
            if (this.ringBuffer != null && this.ringIndex < this.ringBuffer.size()) continue;
            ++this.ringR;
            this.ringBuffer = this.buildRing(this.centerX, this.centerZ, this.ringR);
            this.ringIndex = 0;
            if (!this.ringBuffer.isEmpty()) continue;
            return null;
        } while (!this.region.contains((p = this.ringBuffer.get(this.ringIndex++))[0], p[1]));
        return p;
    }

    private List<int[]> buildRing(int cx0, int cz0, int r) {
        int i;
        if (r <= 0) {
            return Collections.singletonList(new int[]{cx0, cz0});
        }
        ArrayList<int[]> pts = new ArrayList<int[]>(r * 8);
        int x = cx0 - r;
        int z = cz0 - r;
        for (i = 0; i < 2 * r; ++i) {
            pts.add(new int[]{x + i, z});
        }
        for (i = 0; i < 2 * r; ++i) {
            pts.add(new int[]{cx0 + r, z + i});
        }
        for (i = 0; i < 2 * r; ++i) {
            pts.add(new int[]{cx0 + r - i, cz0 + r});
        }
        for (i = 0; i < 2 * r; ++i) {
            pts.add(new int[]{x, cz0 + r - i});
        }
        return pts;
    }

    private int[] nextMorton() {
        int minX = this.region.minX();
        int minZ = this.region.minZ();
        int width = this.region.maxX() - minX + 1;
        int height = this.region.maxZ() - minZ + 1;
        while (this.mortonIndex < this.mortonMax) {
            long idx;
            ++this.mortonIndex;
            int lx = (int)SmartPregenTask.deinterleave(idx & 0xFFFFFFFFL);
            int lz = (int)SmartPregenTask.deinterleave(idx >> 1 & 0xFFFFFFFFL);
            if (lx >= this.mortonSize || lz >= this.mortonSize) continue;
            int gx = minX + lx;
            int gz = minZ + lz;
            if (gx < minX || gx >= minX + width || gz < minZ || gz >= minZ + height || !this.region.contains(gx, gz)) continue;
            return new int[]{gx, gz};
        }
        return null;
    }

    private static long deinterleave(long x) {
        x &= 0x55555555L;
        x = (x ^ x >> 1) & 0x33333333L;
        x = (x ^ x >> 2) & 0xF0F0F0FL;
        x = (x ^ x >> 4) & 0xFF00FFL;
        x = (x ^ x >> 8) & 0xFFFFL;
        return x;
    }

    private int[] nextStructureBiased() {
        int[] p2;
        do {
            if (this.processed >= this.total) {
                return null;
            }
            if (this.ringBuffer != null && this.ringIndex < this.ringBuffer.size()) continue;
            ++this.ringR;
            List<int[]> ring = this.buildRing(this.centerX, this.centerZ, this.ringR);
            long seed = this.world.getSeed();
            int spacing = this.structureGridSpacing;
            int offX = (int)(seed & 0x1FL);
            int offZ = (int)(seed >> 5 & 0x1FL);
            ring.sort(Comparator.comparingDouble(p -> this.structureScore(p[0], p[1], offX, offZ, spacing, seed)));
            this.ringBuffer = ring;
            this.ringIndex = 0;
            if (!this.ringBuffer.isEmpty()) continue;
            return null;
        } while (!this.region.contains((p2 = this.ringBuffer.get(this.ringIndex++))[0], p2[1]));
        return p2;
    }

    private double structureScore(int cx, int cz, int offX, int offZ, int spacing, long seed) {
        int ax = this.nearestAnchor(cx, offX, spacing);
        int az = this.nearestAnchor(cz, offZ, spacing);
        int dx = cx - ax;
        int dz = cz - az;
        double dist = Math.hypot(dx, dz);
        long h = this.mix(seed, (long)cx * 341873128712L ^ (long)cz * 132897987541L);
        double jitter = (double)(h & 0xFFFFL) / 65535.0;
        return dist - 0.75 * jitter;
    }

    private int nearestAnchor(int c, int off, int spacing) {
        int rel = c - off;
        int k = Math.round((float)rel / (float)spacing);
        return off + k * spacing;
    }

    private long mix(long a, long b) {
        long x = a ^ b + -7046029254386353131L + (a << 6) + (a >> 2);
        x ^= x << 13;
        x ^= x >>> 7;
        x ^= x << 17;
        return x;
    }

    public void pause() {
        this.paused = true;
        if (this.persist) {
            this.safeWriteState();
        }
    }

    public void resume() {
        this.paused = false;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public long getProcessed() {
        return this.processed;
    }

    public long getTotal() {
        return this.total;
    }

    public long getCompleted() {
        return this.completed.get();
    }

    public int getInFlight() {
        return this.inFlight.get();
    }

    public double getEmaCps() {
        return this.emaCps;
    }

    public int getDynChunksPerTick() {
        return this.dynChunksPerTick;
    }

    public int getDynMaxInFlight() {
        return this.dynMaxInFlight;
    }

    private void safeWriteState() {
        if (this.stateFile == null) {
            return;
        }
        try {
            File dir = this.stateFile.getParentFile();
            if (dir != null && !dir.exists()) {
                dir.mkdirs();
            }
            try (FileWriter w = new FileWriter(this.stateFile, StandardCharsets.UTF_8);){
                w.write("version=1\n");
                w.write("world=" + this.world.getName() + "\n");
                w.write("mode=" + this.mode.name() + "\n");
                if (this.region instanceof CircleRegion) {
                    w.write("region=CIRCLE\n");
                    w.write("centerX=" + this.centerX + "\n");
                    w.write("centerZ=" + this.centerZ + "\n");
                    w.write("radius=" + (this.centerX - ((CircleRegion)this.region).minX()) + "\n");
                } else if (this.region instanceof RectRegion) {
                    w.write("region=RECT\n");
                    w.write("minX=" + ((RectRegion)this.region).minX() + "\n");
                    w.write("minZ=" + ((RectRegion)this.region).minZ() + "\n");
                    w.write("maxX=" + ((RectRegion)this.region).maxX() + "\n");
                    w.write("maxZ=" + ((RectRegion)this.region).maxZ() + "\n");
                    w.write("centerX=" + this.centerX + "\n");
                    w.write("centerZ=" + this.centerZ + "\n");
                }
                w.write("cpt=" + this.chunksPerTick + "\n");
                w.write("maxInFlight=" + this.maxInFlight + "\n");
                w.write("progressSec=" + this.progressIntervalSeconds + "\n");
                w.write("grid=" + this.structureGridSpacing + "\n");
                w.write("skipPlayers=" + this.skipPlayers + "\n");
                w.write("skipRadius=" + this.skipRadiusBlocks + "\n");
                w.write("processed=" + this.processed + "\n");
                w.write("completed=" + this.completed.get() + "\n");
                w.write("metaLoaded=" + this.metaLoadedChunks + "\n");
                w.write("spiralX=" + this.spiralX + "\n");
                w.write("spiralZ=" + this.spiralZ + "\n");
                w.write("spiralLayer=" + this.spiralLayer + "\n");
                w.write("spiralLeg=" + this.spiralLeg + "\n");
                w.write("spiralSteps=" + this.spiralSteps + "\n");
                w.write("spiralStepCount=" + this.spiralStepCount + "\n");
                w.write("spiralLegCount=" + this.spiralLegCount + "\n");
                w.write("ringR=" + this.ringR + "\n");
                w.write("ringIndex=" + this.ringIndex + "\n");
                w.write("mortonSize=" + this.mortonSize + "\n");
                w.write("mortonIndex=" + this.mortonIndex + "\n");
                w.flush();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static SavedState readState(File f) {
        if (f == null || !f.exists()) {
            return null;
        }
        try {
            List<String> lines = Files.readAllLines(f.toPath(), StandardCharsets.UTF_8);
            HashMap<String, String> map = new HashMap<String, String>();
            for (String line : lines) {
                int p = line.indexOf(61);
                if (p <= 0) continue;
                map.put(line.substring(0, p), line.substring(p + 1));
            }
            SavedState s = new SavedState();
            s.worldName = (String)map.get("world");
            try {
                s.mode = Mode.valueOf(map.getOrDefault("mode", "STRUCTURE_BIASED"));
            }
            catch (Throwable t) {
                s.mode = Mode.STRUCTURE_BIASED;
            }
            s.region = map.getOrDefault("region", "CIRCLE");
            s.centerX = SmartPregenTask.parseInt((String)map.get("centerX"), 0);
            s.centerZ = SmartPregenTask.parseInt((String)map.get("centerZ"), 0);
            s.radius = SmartPregenTask.parseInt((String)map.get("radius"), 0);
            s.minX = SmartPregenTask.parseInt((String)map.get("minX"), 0);
            s.minZ = SmartPregenTask.parseInt((String)map.get("minZ"), 0);
            s.maxX = SmartPregenTask.parseInt((String)map.get("maxX"), 0);
            s.maxZ = SmartPregenTask.parseInt((String)map.get("maxZ"), 0);
            s.cpt = SmartPregenTask.parseInt((String)map.get("cpt"), 8);
            s.maxInFlight = SmartPregenTask.parseInt((String)map.get("maxInFlight"), 64);
            s.progressSec = SmartPregenTask.parseInt((String)map.get("progressSec"), 10);
            s.grid = SmartPregenTask.parseInt((String)map.get("grid"), 32);
            s.skipPlayers = Boolean.parseBoolean(map.getOrDefault("skipPlayers", "true"));
            s.skipRadius = SmartPregenTask.parseInt((String)map.get("skipRadius"), 96);
            s.processed = SmartPregenTask.parseLong((String)map.get("processed"), 0L);
            s.completed = SmartPregenTask.parseLong((String)map.get("completed"), s.processed);
            s.metaLoaded = SmartPregenTask.parseLong((String)map.get("metaLoaded"), 0L);
            s.spiralX = SmartPregenTask.parseInt((String)map.get("spiralX"), s.centerX);
            s.spiralZ = SmartPregenTask.parseInt((String)map.get("spiralZ"), s.centerZ);
            s.spiralLayer = SmartPregenTask.parseInt((String)map.get("spiralLayer"), 0);
            s.spiralLeg = SmartPregenTask.parseInt((String)map.get("spiralLeg"), 0);
            s.spiralSteps = SmartPregenTask.parseInt((String)map.get("spiralSteps"), 1);
            s.spiralStepCount = SmartPregenTask.parseInt((String)map.get("spiralStepCount"), 0);
            s.spiralLegCount = SmartPregenTask.parseInt((String)map.get("spiralLegCount"), 0);
            s.ringR = SmartPregenTask.parseInt((String)map.get("ringR"), 0);
            s.ringIndex = SmartPregenTask.parseInt((String)map.get("ringIndex"), 0);
            s.mortonSize = SmartPregenTask.parseInt((String)map.get("mortonSize"), 1);
            s.mortonIndex = SmartPregenTask.parseLong((String)map.get("mortonIndex"), 0L);
            return s;
        }
        catch (IOException e) {
            return null;
        }
    }

    private static int parseInt(String s, int def) {
        try {
            return Integer.parseInt(s);
        }
        catch (Throwable t) {
            return def;
        }
    }

    private static long parseLong(String s, long def) {
        try {
            return Long.parseLong(s);
        }
        catch (Throwable t) {
            return def;
        }
    }

    public static SmartPregenTask fromState(Plugin plugin, World world, SavedState s, CommandSender sink, File stateFile, boolean persist) {
        Region region = "RECT".equalsIgnoreCase(s.region) ? new RectRegion(s.minX, s.minZ, s.maxX, s.maxZ) : new CircleRegion(s.centerX, s.centerZ, s.radius);
        SmartPregenTask t = new SmartPregenTask(plugin, world, region, s.centerX, s.centerZ, s.mode, s.cpt, s.maxInFlight, s.progressSec, s.grid, s.skipPlayers, s.skipRadius, persist, stateFile, sink);
        t.spiralX = s.spiralX;
        t.spiralZ = s.spiralZ;
        t.spiralLayer = s.spiralLayer;
        t.spiralLeg = s.spiralLeg;
        t.spiralSteps = s.spiralSteps;
        t.spiralStepCount = s.spiralStepCount;
        t.spiralLegCount = s.spiralLegCount;
        t.ringR = s.ringR;
        t.ringIndex = s.ringIndex;
        t.mortonIndex = s.mortonIndex;
        t.mortonSize = s.mortonSize;
        t.processed = s.processed;
        t.completed.set(s.completed);
        t.lastCompleted = s.completed;
        t.metaLoadedChunks = s.metaLoaded;
        return t;
    }

    private void autoThrottle() {
        double recTps;
        double tps = this.getPaperTps1m();
        int online = this.safeOnlinePlayers();
        double minTps = online > 0 ? Math.max(19.6, this.minTpsTarget) : this.minTpsTarget;
        double d = recTps = online > 0 ? Math.max(19.85, this.recoverTpsTarget) : this.recoverTpsTarget;
        if (tps > 0.0) {
            if (tps < minTps) {
                this.dynChunksPerTick = Math.max(1, (int)Math.floor((double)this.dynChunksPerTick * 0.7));
                this.dynMaxInFlight = Math.max(1, (int)Math.floor((double)this.dynMaxInFlight * 0.75));
            } else if (tps > recTps) {
                this.dynChunksPerTick = Math.min(this.chunksPerTick, Math.max(this.dynChunksPerTick + 1, (int)Math.ceil((double)this.dynChunksPerTick * 1.08)));
                this.dynMaxInFlight = Math.min(this.maxInFlight, Math.max(this.dynMaxInFlight + 1, (int)Math.ceil((double)this.dynMaxInFlight * 1.05)));
            }
        }
    }

    private int safeOnlinePlayers() {
        try {
            return Bukkit.getOnlinePlayers().size();
        }
        catch (Throwable ignored) {
            return 0;
        }
    }

    private double getPaperTps1m() {
        try {
            double[] t;
            Method m = Bukkit.getServer().getClass().getMethod("getTPS", new Class[0]);
            Object tpsArr = m.invoke((Object)Bukkit.getServer(), new Object[0]);
            if (tpsArr instanceof double[] && (t = (double[])tpsArr).length > 0) {
                return t[0];
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return -1.0;
    }

    private void appendMeta(String type, long value) {
        if (this.metaFile == null) {
            return;
        }
        try {
            File dir = this.metaFile.getParentFile();
            if (dir != null && !dir.exists()) {
                dir.mkdirs();
            }
            try (FileWriter w = new FileWriter(this.metaFile, true);){
                long ts = System.currentTimeMillis();
                String regionDesc = this.region instanceof CircleRegion ? "CIRCLE:" + ((CircleRegion)this.region).centerX + "," + ((CircleRegion)this.region).centerZ + ",r=" + (this.centerX - ((CircleRegion)this.region).minX()) : "RECT:" + ((RectRegion)this.region).minX() + "," + ((RectRegion)this.region).minZ() + "," + ((RectRegion)this.region).maxX() + "," + ((RectRegion)this.region).maxZ();
                w.write(String.format(Locale.ROOT, "%d\t%s\t%s\tmode=%s\tdynCpt=%d\tinFlight=%d\tvalue=%d\n", ts, this.world.getName(), regionDesc, this.mode.name(), this.dynChunksPerTick, this.inFlight.get(), value));
                w.flush();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private class TaskListener
    implements Listener {
        private TaskListener() {
        }

        @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
        public void onWorldInit(WorldInitEvent e) {
            if (e.getWorld() != SmartPregenTask.this.world) {
                return;
            }
            SmartPregenTask.this.appendMeta("WORLD_INIT", 0L);
        }

        @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
        public void onChunkLoad(ChunkLoadEvent e) {
            int cz;
            if (e.getWorld() != SmartPregenTask.this.world) {
                return;
            }
            Chunk c = e.getChunk();
            int cx = c.getX();
            if (SmartPregenTask.this.region.contains(cx, cz = c.getZ())) {
                ++SmartPregenTask.this.metaLoadedChunks;
            }
        }

        @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
        public void onChunkUnload(ChunkUnloadEvent e) {
            if (e.getWorld() != SmartPregenTask.this.world) {
                return;
            }
        }
    }

    public static interface Region {
        public boolean contains(int var1, int var2);

        public long totalChunks();

        public int minX();

        public int maxX();

        public int minZ();

        public int maxZ();
    }

    public static enum Mode {
        SPIRAL,
        RING,
        MORTON,
        STRUCTURE_BIASED;

    }

    public static class CircleRegion
    implements Region {
        final int centerX;
        final int centerZ;
        final int radius;
        final long total;

        public CircleRegion(int centerX, int centerZ, int radius) {
            this.centerX = centerX;
            this.centerZ = centerZ;
            this.radius = Math.max(0, radius);
            long sum = 0L;
            long r2 = 1L * (long)radius * (long)radius;
            for (int dx = -radius; dx <= radius; ++dx) {
                long rem = r2 - 1L * (long)dx * (long)dx;
                int maxDz = (int)Math.floor(Math.sqrt(Math.max(0L, rem)));
                sum += 2L * (long)maxDz + 1L;
            }
            this.total = sum;
        }

        @Override
        public boolean contains(int cx, int cz) {
            int dx = cx - this.centerX;
            int dz = cz - this.centerZ;
            return 1L * (long)dx * (long)dx + 1L * (long)dz * (long)dz <= 1L * (long)this.radius * (long)this.radius;
        }

        @Override
        public long totalChunks() {
            return this.total;
        }

        @Override
        public int minX() {
            return this.centerX - this.radius;
        }

        @Override
        public int maxX() {
            return this.centerX + this.radius;
        }

        @Override
        public int minZ() {
            return this.centerZ - this.radius;
        }

        @Override
        public int maxZ() {
            return this.centerZ + this.radius;
        }
    }

    public static class RectRegion
    implements Region {
        final int minX;
        final int maxX;
        final int minZ;
        final int maxZ;
        final long total;

        public RectRegion(int minX, int minZ, int maxX, int maxZ) {
            this.minX = Math.min(minX, maxX);
            this.maxX = Math.max(minX, maxX);
            this.minZ = Math.min(minZ, maxZ);
            this.maxZ = Math.max(minZ, maxZ);
            long w = (long)this.maxX - (long)this.minX + 1L;
            long h = (long)this.maxZ - (long)this.minZ + 1L;
            this.total = Math.max(0L, w) * Math.max(0L, h);
        }

        @Override
        public boolean contains(int cx, int cz) {
            return cx >= this.minX && cx <= this.maxX && cz >= this.minZ && cz <= this.maxZ;
        }

        @Override
        public long totalChunks() {
            return this.total;
        }

        @Override
        public int minX() {
            return this.minX;
        }

        @Override
        public int maxX() {
            return this.maxX;
        }

        @Override
        public int minZ() {
            return this.minZ;
        }

        @Override
        public int maxZ() {
            return this.maxZ;
        }
    }

    public static class SavedState {
        public String worldName;
        public Mode mode;
        public String region;
        public int centerX;
        public int centerZ;
        public int radius;
        public int minX;
        public int minZ;
        public int maxX;
        public int maxZ;
        public int cpt;
        public int maxInFlight;
        public int progressSec;
        public int grid;
        public boolean skipPlayers;
        public int skipRadius;
        public long processed;
        public long completed;
        public long metaLoaded;
        public int spiralX;
        public int spiralZ;
        public int spiralLayer;
        public int spiralLeg;
        public int spiralSteps;
        public int spiralStepCount;
        public int spiralLegCount;
        public int ringR;
        public int ringIndex;
        public int mortonSize;
        public long mortonIndex;
    }
}

