/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.worldManager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.util.StringUtil;
import org.texboobcat.worldManager.WorldManager;

public class HelpCommand
implements CommandExecutor,
TabCompleter {
    private final WorldManager plugin;

    public HelpCommand(WorldManager plugin) {
        this.plugin = plugin;
    }

    private String msg(String path, String def) {
        FileConfiguration cfg = this.plugin.getConfig();
        String s = cfg.getString(path, def);
        return Objects.requireNonNullElse(s, def);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length >= 1) {
            String sub;
            switch (sub = args[0].toLowerCase(Locale.ROOT)) {
                case "list": {
                    sender.sendMessage("/world list - List loaded worlds");
                    return true;
                }
                case "info": {
                    sender.sendMessage(this.msg("messages.usage.info", "/%label% info <world> - Show world info").replace("%label%", label));
                    return true;
                }
                case "tp": {
                    sender.sendMessage(this.msg("messages.usage.tp", "/%label% tp [player] <world> - Teleport to world").replace("%label%", label));
                    return true;
                }
                case "back": {
                    sender.sendMessage(this.msg("messages.usage.back", "/%label% back [n] - Return to previous location").replace("%label%", label));
                    return true;
                }
                case "history": {
                    sender.sendMessage("/world history - Show teleport history");
                    return true;
                }
                case "gui": {
                    sender.sendMessage("/world gui - Open world selector GUI");
                    return true;
                }
                case "fav": 
                case "favorite": 
                case "favorites": {
                    sender.sendMessage(this.msg("messages.usage.fav", "/%label% fav <add|remove|list> [world] - Manage favorites").replace("%label%", label));
                    return true;
                }
                case "create": {
                    sender.sendMessage(this.msg("messages.usage.create", "/%label% create <name> [NORMAL|NETHER|THE_END]").replace("%label%", label));
                    return true;
                }
                case "import": {
                    sender.sendMessage(this.msg("messages.usage.import", "/%label% import <folder> [env]").replace("%label%", label));
                    return true;
                }
                case "unload": {
                    sender.sendMessage(this.msg("messages.usage.unload", "/%label% unload <world> [save:true|false]").replace("%label%", label));
                    return true;
                }
                case "delete": {
                    sender.sendMessage(this.msg("messages.usage.delete", "/%label% delete <world>").replace("%label%", label));
                    return true;
                }
                case "setspawn": {
                    sender.sendMessage(this.msg("messages.usage.setspawn", "/%label% setspawn <world>").replace("%label%", label));
                    return true;
                }
                case "config": {
                    sender.sendMessage(this.msg("messages.usage.config", "/%label% config <world> <key> <value>").replace("%label%", label));
                    sender.sendMessage(this.msg("messages.usage.config_allowed", "/%label% config <world> allowed-mobs <add|remove|clear|list> [MOB]").replace("%label%", label));
                    return true;
                }
                case "migrate": {
                    sender.sendMessage("/world migrate [force] - Backup and migrate worlds.yml to latest schema");
                    return true;
                }
            }
        }
        sender.sendMessage("\u00a7aWorldManager Commands:");
        sender.sendMessage("/" + label + " list");
        sender.sendMessage(this.msg("messages.usage.info", "/%label% info <world>").replace("%label%", label));
        sender.sendMessage(this.msg("messages.usage.tp", "/%label% tp [player] <world>").replace("%label%", label));
        sender.sendMessage(this.msg("messages.usage.back", "/%label% back [n]").replace("%label%", label));
        sender.sendMessage("/" + label + " history");
        sender.sendMessage("/" + label + " gui");
        sender.sendMessage(this.msg("messages.usage.fav", "/%label% fav <add|remove|list> [world]").replace("%label%", label));
        sender.sendMessage(this.msg("messages.usage.create", "/%label% create <name> [env]").replace("%label%", label));
        sender.sendMessage(this.msg("messages.usage.import", "/%label% import <folder> [env]").replace("%label%", label));
        sender.sendMessage(this.msg("messages.usage.unload", "/%label% unload <world> [save:true|false]").replace("%label%", label));
        sender.sendMessage(this.msg("messages.usage.delete", "/%label% delete <world>").replace("%label%", label));
        sender.sendMessage(this.msg("messages.usage.setspawn", "/%label% setspawn <world>").replace("%label%", label));
        sender.sendMessage(this.msg("messages.usage.config", "/%label% config <world> <key> <value>").replace("%label%", label));
        sender.sendMessage("/" + label + " migrate [force]");
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1) {
            List<String> subs = List.of("list", "info", "tp", "back", "history", "gui", "fav", "create", "import", "unload", "delete", "setspawn", "config", "migrate");
            return (List)StringUtil.copyPartialMatches((String)args[0], subs, new ArrayList());
        }
        return Collections.emptyList();
    }
}

